/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.mods;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import tk.wurst_client.events.listeners.RenderListener;
import tk.wurst_client.events.listeners.UpdateListener;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.utils.RenderUtils;

@Mod.Info(category=Mod.Category.RENDER, description="Helps you to find specific blocks.\nUse .search id <block id> or .search name <block name>\nto specify it.", name="Search", help="Mods/Search")
@Mod.Bypasses
public class SearchMod
extends Mod
implements UpdateListener,
RenderListener {
    private ArrayList<BlockPos> matchingBlocks = new ArrayList();
    private int range = 50;
    private int maxBlocks = 1000;
    public boolean notify = true;

    @Override
    public String getRenderName() {
        return String.valueOf(this.getName()) + " [" + SearchMod.wurst.options.searchID + "]";
    }

    @Override
    public void onEnable() {
        this.notify = true;
        SearchMod.wurst.events.add(UpdateListener.class, this);
        SearchMod.wurst.events.add(RenderListener.class, this);
    }

    @Override
    public void onRender() {
        for (BlockPos blockPos : this.matchingBlocks) {
            RenderUtils.searchBox(blockPos);
        }
    }

    @Override
    public void onUpdate() {
        this.updateMS();
        if (this.hasTimePassedM(3000L)) {
            this.matchingBlocks.clear();
            int y = this.range;
            while (y >= -this.range) {
                int x = this.range;
                while (x >= -this.range) {
                    int z = this.range;
                    while (z >= -this.range) {
                        int posX = (int)(SearchMod.mc.thePlayer.posX + (double)x);
                        int posY = (int)(SearchMod.mc.thePlayer.posY + (double)y);
                        int posZ = (int)(SearchMod.mc.thePlayer.posZ + (double)z);
                        BlockPos pos = new BlockPos(posX, posY, posZ);
                        if (Block.getIdFromBlock(SearchMod.mc.theWorld.getBlockState(pos).getBlock()) == SearchMod.wurst.options.searchID) {
                            this.matchingBlocks.add(pos);
                        }
                        if (this.matchingBlocks.size() >= this.maxBlocks) break;
                        --z;
                    }
                    if (this.matchingBlocks.size() >= this.maxBlocks) break;
                    --x;
                }
                if (this.matchingBlocks.size() >= this.maxBlocks) break;
                --y;
            }
            if (this.matchingBlocks.size() >= this.maxBlocks && this.notify) {
                SearchMod.wurst.chat.warning(String.valueOf(this.getName()) + " found \u00a7lA LOT\u00a7r of blocks.");
                SearchMod.wurst.chat.message("To prevent lag, it will only show the first " + this.maxBlocks + " blocks.");
                this.notify = false;
            } else if (this.matchingBlocks.size() < this.maxBlocks) {
                this.notify = true;
            }
            this.updateLastMS();
        }
    }

    @Override
    public void onDisable() {
        SearchMod.wurst.events.remove(UpdateListener.class, this);
        SearchMod.wurst.events.remove(RenderListener.class, this);
    }
}

