/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.navigator.gui;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.init.SoundEvents;
import org.darkstorm.minecraft.gui.util.RenderUtil;
import org.lwjgl.opengl.GL11;
import tk.wurst_client.WurstClient;
import tk.wurst_client.font.Fonts;
import tk.wurst_client.navigator.NavigatorItem;
import tk.wurst_client.navigator.PossibleKeybind;
import tk.wurst_client.navigator.gui.NavigatorMainScreen;
import tk.wurst_client.navigator.gui.NavigatorNewKeybindScreen;
import tk.wurst_client.navigator.gui.NavigatorRemoveKeybindScreen;
import tk.wurst_client.navigator.gui.NavigatorScreen;
import tk.wurst_client.navigator.settings.CheckboxSetting;
import tk.wurst_client.navigator.settings.NavigatorSetting;
import tk.wurst_client.navigator.settings.SliderSetting;
import tk.wurst_client.utils.MiscUtils;

public class NavigatorFeatureScreen
extends NavigatorScreen {
    private NavigatorItem item;
    private NavigatorMainScreen parent;
    private ButtonData activeButton;
    private GuiButton primaryButton;
    private int sliding = -1;
    private String text;
    private ArrayList<ButtonData> buttonDatas = new ArrayList();
    private ArrayList<SliderSetting> sliders = new ArrayList();
    private ArrayList<CheckboxSetting> checkboxes = new ArrayList();

    public NavigatorFeatureScreen(NavigatorItem item, NavigatorMainScreen parent) {
        this.item = item;
        this.parent = parent;
    }

    @Override
    protected void actionPerformed(GuiButton button) throws IOException {
        if (!button.enabled) {
            return;
        }
        WurstClient wurst = WurstClient.INSTANCE;
        switch (button.id) {
            case 0: {
                this.item.doPrimaryAction();
                this.primaryButton.displayString = this.item.getPrimaryAction();
                break;
            }
            case 1: {
                MiscUtils.openLink("https://www.wurst-client.tk/wiki/" + this.item.getHelpPage() + "/");
                wurst.navigator.analytics.trackEvent("help", "open", this.item.getName());
            }
        }
        wurst.navigator.addPreference(this.item.getName());
        wurst.files.saveNavigatorData();
    }

    @Override
    protected void onResize() {
        NavigatorItem[] seeAlso;
        ArrayList<PossibleKeybind> possibleKeybinds;
        boolean hasHelp;
        this.buttonDatas.clear();
        String primaryAction = this.item.getPrimaryAction();
        boolean hasPrimaryAction = !primaryAction.isEmpty();
        boolean bl = hasHelp = !this.item.getHelpPage().isEmpty();
        if (hasPrimaryAction) {
            this.primaryButton = new GuiButton(0, this.width / 2 - 151, this.height - 65, hasHelp ? 149 : 302, 18, primaryAction);
            this.buttonList.add(this.primaryButton);
        }
        if (hasHelp) {
            this.buttonList.add(new GuiButton(1, this.width / 2 + (hasPrimaryAction ? 2 : -151), this.height - 65, hasPrimaryAction ? 149 : 302, 20, "Help"));
        }
        this.text = "Type: " + this.item.getType();
        String description = this.item.getDescription();
        if (!description.isEmpty()) {
            this.text = String.valueOf(this.text) + "\n\nDescription:\n" + description;
        }
        Rectangle area = new Rectangle(this.middleX - 154, 60, 308, this.height - 103);
        ArrayList<NavigatorSetting> settings = this.item.getSettings();
        if (!settings.isEmpty()) {
            this.text = String.valueOf(this.text) + "\n\nSettings:";
            this.sliders.clear();
            this.checkboxes.clear();
            for (NavigatorSetting setting : settings) {
                setting.addToFeatureScreen(this);
            }
        }
        if (!(possibleKeybinds = this.item.getPossibleKeybinds()).isEmpty()) {
            this.text = String.valueOf(this.text) + "\n\nKeybinds:";
            ButtonData addKeybindButton = new ButtonData(this, area.x + area.width - 16, area.y + Fonts.segoe15.getStringHeight(this.text) - 8, 12, 8, "+", 65280){

                @Override
                public void press() {
                    mc.displayGuiScreen(new NavigatorNewKeybindScreen(possibleKeybinds, this));
                }
            };
            this.buttonDatas.add(addKeybindButton);
            HashMap<String, String> possibleKeybindsMap = new HashMap<String, String>();
            for (PossibleKeybind possibleKeybind : possibleKeybinds) {
                possibleKeybindsMap.put(possibleKeybind.getCommand(), possibleKeybind.getDescription());
            }
            final TreeMap<String, PossibleKeybind> existingKeybinds = new TreeMap<String, PossibleKeybind>();
            boolean noKeybindsSet = true;
            for (Map.Entry entry : WurstClient.INSTANCE.keybinds.entrySet()) {
                for (String command : (TreeSet)entry.getValue()) {
                    String keybindDescription = (String)possibleKeybindsMap.get(command);
                    if (keybindDescription == null) continue;
                    if (noKeybindsSet) {
                        noKeybindsSet = false;
                    }
                    this.text = String.valueOf(this.text) + "\n" + (String)entry.getKey() + ": " + keybindDescription;
                    existingKeybinds.put((String)entry.getKey(), new PossibleKeybind(command, keybindDescription));
                }
            }
            if (noKeybindsSet) {
                this.text = String.valueOf(this.text) + "\nNone";
            } else {
                this.buttonDatas.add(new ButtonData(this, addKeybindButton.x, addKeybindButton.y, addKeybindButton.width, addKeybindButton.height, "-", 0xFF0000){

                    @Override
                    public void press() {
                        mc.displayGuiScreen(new NavigatorRemoveKeybindScreen(existingKeybinds, this));
                    }
                });
                addKeybindButton.x -= 16;
            }
        }
        if ((seeAlso = this.item.getSeeAlso()).length != 0) {
            this.text = String.valueOf(this.text) + "\n\nSee also:\n";
            int i = 0;
            while (i < seeAlso.length) {
                int y = 60 + this.getTextHeight() + 2;
                final NavigatorItem seeAlsoItem = seeAlso[i];
                String name = seeAlsoItem.getName();
                this.text = String.valueOf(this.text) + "- " + name + (i == seeAlso.length - 1 ? "" : "\n");
                this.buttonDatas.add(new ButtonData(this, this.middleX - 148, y, Fonts.segoe15.getStringWidth(name) + 3, 8, "", 0x404040){

                    @Override
                    public void press() {
                        mc.displayGuiScreen(new NavigatorFeatureScreen(seeAlsoItem, parent));
                    }
                });
                ++i;
            }
        }
        this.setContentHeight(Fonts.segoe15.getStringHeight(this.text));
    }

    @Override
    protected void onKeyPress(char typedChar, int keyCode) {
        if (keyCode == 1) {
            this.parent.setExpanding(false);
            this.mc.displayGuiScreen(this.parent);
        }
    }

    @Override
    protected void onMouseClick(int x, int y, int button) {
        Rectangle area = new Rectangle(this.width / 2 - 154, 60, 308, this.height - 103);
        if (!area.contains(x, y)) {
            return;
        }
        if (this.activeButton != null) {
            this.mc.getSoundHandler().playSound(PositionedSoundRecord.getMasterRecord(SoundEvents.UI_BUTTON_CLICK, 1.0f));
            this.activeButton.press();
            WurstClient wurst = WurstClient.INSTANCE;
            wurst.navigator.addPreference(this.item.getName());
            wurst.files.saveNavigatorData();
            return;
        }
        area.height = 12;
        int i = 0;
        while (i < this.sliders.size()) {
            area.y = this.sliders.get(i).getY() + this.scroll;
            if (area.contains(x, y)) {
                this.sliding = i;
                return;
            }
            ++i;
        }
        i = 0;
        while (i < this.checkboxes.size()) {
            CheckboxSetting checkbox = this.checkboxes.get(i);
            area.y = checkbox.getY() + this.scroll;
            if (area.contains(x, y)) {
                checkbox.toggle();
                WurstClient wurst = WurstClient.INSTANCE;
                wurst.navigator.addPreference(this.item.getName());
                wurst.files.saveNavigatorData();
                return;
            }
            ++i;
        }
    }

    @Override
    protected void onMouseDrag(int x, int y, int button, long timeDragged) {
        if (button != 0) {
            return;
        }
        if (this.sliding != -1) {
            float mousePercentage = (float)(x - (this.middleX - 150)) / 298.0f;
            if (mousePercentage > 1.0f) {
                mousePercentage = 1.0f;
            } else if (mousePercentage < 0.0f) {
                mousePercentage = 0.0f;
            }
            SliderSetting slider = this.sliders.get(this.sliding);
            slider.setValue((double)((long)((slider.getMaximum() - slider.getMinimum()) * (double)mousePercentage / slider.getIncrement())) * 1000000.0 * slider.getIncrement() / 1000000.0 + slider.getMinimum());
        }
    }

    @Override
    protected void onMouseRelease(int x, int y, int button) {
        if (this.sliding != -1) {
            WurstClient wurst = WurstClient.INSTANCE;
            this.sliding = -1;
            wurst.navigator.addPreference(this.item.getName());
            wurst.files.saveNavigatorData();
        }
    }

    @Override
    protected void onUpdate() {
    }

    @Override
    protected void onRender(int mouseX, int mouseY, float partialTicks) {
        boolean hovering;
        int y2;
        int y1;
        int x2;
        int x1;
        this.drawCenteredString(Fonts.segoe22, this.item.getName(), this.middleX, 32, 0xFFFFFF);
        GL11.glDisable((int)3553);
        int bgx1 = this.middleX - 154;
        int bgx2 = this.middleX + 154;
        int bgy1 = 60;
        int bgy2 = this.height - 43;
        RenderUtil.scissorBox(bgx1, bgy1, bgx2, bgy2 - (this.buttonList.isEmpty() ? 0 : 24));
        GL11.glEnable((int)3089);
        for (SliderSetting slider : this.sliders) {
            boolean renderAsDisabled;
            x1 = bgx1 + 2;
            x2 = bgx2 - 2;
            y1 = slider.getY() + this.scroll + 4;
            y2 = y1 + 4;
            this.setColorToForeground();
            this.drawEngravedBox(x1, y1, x2, y2);
            boolean bl = renderAsDisabled = slider.isDisabled() || slider.isLocked() && slider.getLockMinX() == slider.getLockMaxX();
            if (!renderAsDisabled && slider.isLocked()) {
                GL11.glColor4f((float)0.75f, (float)0.125f, (float)0.125f, (float)0.25f);
                this.drawQuads(x1, y1, x1 + slider.getLockMinX(), y2);
                this.drawQuads(x1 + slider.getLockMaxX(), y1, x2, y2);
            }
            x1 = bgx1 + slider.getX();
            x2 = x1 + 8;
            y1 -= 2;
            y2 += 2;
            if (renderAsDisabled) {
                GL11.glColor4f((float)0.5f, (float)0.5f, (float)0.5f, (float)0.75f);
            } else {
                float percentage = slider.getPercentage();
                GL11.glColor4f((float)percentage, (float)(1.0f - percentage), (float)0.0f, (float)0.75f);
            }
            this.drawBox(x1, y1, x2, y2);
            String value = slider.getValueString();
            x1 = bgx2 - Fonts.segoe15.getStringWidth(value) - 2;
            this.drawString(Fonts.segoe15, value, x1, y1 -= 12, renderAsDisabled ? 0xAAAAAA : 0xFFFFFF);
            GL11.glDisable((int)3553);
        }
        this.activeButton = null;
        for (ButtonData buttonData : this.buttonDatas) {
            float alpha;
            x1 = buttonData.x;
            x2 = x1 + buttonData.width;
            y1 = buttonData.y + this.scroll;
            y2 = y1 + buttonData.height;
            if (buttonData.isLocked()) {
                alpha = 0.25f;
            } else if (mouseX >= x1 && mouseX <= x2 && mouseY >= y1 && mouseY <= y2) {
                alpha = 0.75f;
                this.activeButton = buttonData;
            } else {
                alpha = 0.375f;
            }
            float[] rgb = buttonData.color.getColorComponents(null);
            GL11.glColor4f((float)rgb[0], (float)rgb[1], (float)rgb[2], (float)alpha);
            this.drawBox(x1, y1, x2, y2);
            this.drawCenteredString(Fonts.segoe18, buttonData.buttonText, (x1 + x2) / 2 - 1, y1 + (buttonData.height - 12) / 2 - 1, buttonData.isLocked() ? 0xAAAAAA : buttonData.textColor);
            GL11.glDisable((int)3553);
        }
        for (CheckboxSetting checkbox : this.checkboxes) {
            x1 = bgx1 + 2;
            x2 = x1 + 10;
            y1 = checkbox.getY() + this.scroll + 2;
            y2 = y1 + 10;
            boolean bl = hovering = !checkbox.isLocked() && mouseX >= x1 && mouseX <= bgx2 - 2 && mouseY >= y1 && mouseY <= y2;
            if (hovering) {
                GL11.glColor4f((float)0.375f, (float)0.375f, (float)0.375f, (float)0.25f);
            } else {
                GL11.glColor4f((float)0.25f, (float)0.25f, (float)0.25f, (float)0.25f);
            }
            this.drawBox(x1, y1, x2, y2);
            if (checkbox.isChecked()) {
                GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)(hovering ? 0.75f : 0.375f));
                GL11.glBegin((int)7);
                GL11.glVertex2i((int)(x1 + 3), (int)(y1 + 5));
                GL11.glVertex2i((int)(x1 + 4), (int)(y1 + 6));
                GL11.glVertex2i((int)(x1 + 4), (int)(y1 + 8));
                GL11.glVertex2i((int)(x1 + 2), (int)(y1 + 6));
                GL11.glVertex2i((int)(x1 + 7), (int)(y1 + 2));
                GL11.glVertex2i((int)(x1 + 8), (int)(y1 + 3));
                GL11.glVertex2i((int)(x1 + 4), (int)(y1 + 6));
                GL11.glVertex2i((int)(x1 + 4), (int)(y1 + 8));
                GL11.glEnd();
                GL11.glColor4f((float)0.125f, (float)0.125f, (float)0.125f, (float)(hovering ? 0.75f : 0.375f));
                GL11.glBegin((int)2);
                GL11.glVertex2i((int)(x1 + 3), (int)(y1 + 5));
                GL11.glVertex2i((int)(x1 + 4), (int)(y1 + 6));
                GL11.glVertex2i((int)(x1 + 7), (int)(y1 + 2));
                GL11.glVertex2i((int)(x1 + 8), (int)(y1 + 3));
                GL11.glVertex2i((int)(x1 + 4), (int)(y1 + 8));
                GL11.glVertex2i((int)(x1 + 2), (int)(y1 + 6));
                GL11.glEnd();
            }
            this.drawString(Fonts.segoe15, checkbox.getName(), x1 += 12, --y1, checkbox.isLocked() ? 0xAAAAAA : 0xFFFFFF);
            GL11.glDisable((int)3553);
        }
        this.drawString(Fonts.segoe15, this.text, bgx1 + 2, bgy1 + this.scroll, 0xFFFFFF);
        GL11.glDisable((int)3089);
        int i = 0;
        while (i < this.buttonList.size()) {
            GuiButton button = (GuiButton)this.buttonList.get(i);
            x1 = button.xPosition;
            x2 = x1 + button.getButtonWidth();
            y1 = button.yPosition;
            y2 = y1 + 18;
            boolean bl = hovering = mouseX >= x1 && mouseX <= x2 && mouseY >= y1 && mouseY <= y2;
            if (this.item.isEnabled() && button.id == 0) {
                if (this.item.isBlocked()) {
                    GL11.glColor4f((float)(hovering ? 1.0f : 0.875f), (float)0.0f, (float)0.0f, (float)0.25f);
                } else {
                    GL11.glColor4f((float)0.0f, (float)(hovering ? 1.0f : 0.875f), (float)0.0f, (float)0.25f);
                }
            } else if (hovering) {
                GL11.glColor4f((float)0.375f, (float)0.375f, (float)0.375f, (float)0.25f);
            } else {
                GL11.glColor4f((float)0.25f, (float)0.25f, (float)0.25f, (float)0.25f);
            }
            GL11.glDisable((int)3553);
            this.drawBox(x1, y1, x2, y2);
            this.drawCenteredString(Fonts.segoe18, button.displayString, (x1 + x2) / 2, y1 + 2, 0xFFFFFF);
            ++i;
        }
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public NavigatorItem getItem() {
        return this.item;
    }

    public int getMiddleX() {
        return this.middleX;
    }

    public void addText(String text) {
        this.text = String.valueOf(this.text) + text;
    }

    public int getTextHeight() {
        return Fonts.segoe15.getStringHeight(this.text);
    }

    public void addButton(ButtonData button) {
        this.buttonDatas.add(button);
    }

    public void addSlider(SliderSetting slider) {
        this.sliders.add(slider);
    }

    public void addCheckbox(CheckboxSetting checkbox) {
        this.checkboxes.add(checkbox);
    }

    public abstract class ButtonData
    extends Rectangle {
        public String buttonText;
        public Color color;
        public int textColor;

        public ButtonData(int x, int y, int width, int height, String buttonText, int color) {
            super(x, y, width, height);
            this.textColor = 0xFFFFFF;
            this.buttonText = buttonText;
            this.color = new Color(color);
        }

        public abstract void press();

        public boolean isLocked() {
            return false;
        }
    }
}

