/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.navigator.gui;

import java.awt.Rectangle;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiTextField;
import org.darkstorm.minecraft.gui.util.RenderUtil;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import tk.wurst_client.WurstClient;
import tk.wurst_client.font.Fonts;
import tk.wurst_client.navigator.Navigator;
import tk.wurst_client.navigator.NavigatorItem;
import tk.wurst_client.navigator.gui.NavigatorFeatureScreen;
import tk.wurst_client.navigator.gui.NavigatorScreen;
import tk.wurst_client.utils.MiscUtils;

public class NavigatorMainScreen
extends NavigatorScreen {
    private static ArrayList<NavigatorItem> navigatorDisplayList = new ArrayList();
    private GuiTextField searchBar;
    private int hoveredItem = -1;
    private boolean hoveringArrow;
    private int clickTimer = -1;
    private boolean expanding = false;

    public NavigatorMainScreen() {
        this.hasBackground = false;
        this.nonScrollableArea = 0;
        this.searchBar = new GuiTextField(0, Fonts.segoe22, 0, 32, 200, 20);
        this.searchBar.setEnableBackgroundDrawing(false);
        this.searchBar.setMaxStringLength(128);
        this.searchBar.setFocused(true);
        Navigator navigator = WurstClient.INSTANCE.navigator;
        navigator.copyNavigatorList(navigatorDisplayList);
        navigator.analytics.trackPageView("/", "Navigator");
    }

    @Override
    protected void onResize() {
        this.searchBar.xPosition = this.middleX - 100;
        this.setContentHeight(navigatorDisplayList.size() / 3 * 20);
    }

    @Override
    protected void onKeyPress(char typedChar, int keyCode) {
        if (keyCode == 1 && this.clickTimer == -1) {
            this.mc.displayGuiScreen(null);
        }
        if (this.clickTimer == -1) {
            String oldText = this.searchBar.getText();
            this.searchBar.textboxKeyTyped(typedChar, keyCode);
            String newText = this.searchBar.getText();
            Navigator navigator = WurstClient.INSTANCE.navigator;
            if (newText.isEmpty()) {
                navigator.copyNavigatorList(navigatorDisplayList);
            } else if (!newText.equals(oldText)) {
                newText = newText.toLowerCase().trim();
                navigator.getSearchResults(navigatorDisplayList, newText);
            }
            this.setContentHeight(navigatorDisplayList.size() / 3 * 20);
        }
    }

    @Override
    protected void onMouseClick(int x, int y, int button) {
        if (this.clickTimer == -1 && this.hoveredItem != -1) {
            if (button == 0 && (Keyboard.isKeyDown((int)42) || this.hoveringArrow) || button == 2) {
                this.expanding = true;
            } else if (button == 0) {
                NavigatorItem item = navigatorDisplayList.get(this.hoveredItem);
                if (item.getPrimaryAction().isEmpty()) {
                    this.expanding = true;
                } else {
                    item.doPrimaryAction();
                    WurstClient wurst = WurstClient.INSTANCE;
                    wurst.navigator.addPreference(item.getName());
                    wurst.files.saveNavigatorData();
                }
            } else if (button == 1) {
                NavigatorItem item = navigatorDisplayList.get(this.hoveredItem);
                if (item.getHelpPage().isEmpty()) {
                    return;
                }
                MiscUtils.openLink("https://www.wurst-client.tk/wiki/" + item.getHelpPage() + "/");
                WurstClient wurst = WurstClient.INSTANCE;
                wurst.navigator.addPreference(item.getName());
                wurst.files.saveNavigatorData();
                wurst.navigator.analytics.trackEvent("help", "open", item.getName());
            }
        }
    }

    @Override
    protected void onMouseDrag(int x, int y, int button, long timeDragged) {
    }

    @Override
    protected void onMouseRelease(int x, int y, int button) {
    }

    @Override
    protected void onUpdate() {
        this.searchBar.updateCursorCounter();
        if (this.expanding) {
            if (this.clickTimer < 4) {
                ++this.clickTimer;
            } else {
                NavigatorItem item = navigatorDisplayList.get(this.hoveredItem);
                this.mc.displayGuiScreen(new NavigatorFeatureScreen(item, this));
                String query = this.searchBar.getText();
                if (query.isEmpty()) {
                    WurstClient.INSTANCE.navigator.analytics.trackPageView("/" + item.getType() + "/" + item.getName(), item.getName());
                } else {
                    WurstClient.INSTANCE.navigator.analytics.trackPageViewFromSearch(String.valueOf(item.getType()) + item.getName(), item.getName(), "/", query);
                }
            }
        } else if (!this.expanding && this.clickTimer > -1) {
            --this.clickTimer;
        }
        this.scrollbarLocked = this.clickTimer != -1;
    }

    @Override
    protected void onRender(int mouseX, int mouseY, float partialTicks) {
        boolean clickTimerNotRunning;
        boolean bl = clickTimerNotRunning = this.clickTimer == -1;
        if (clickTimerNotRunning) {
            Fonts.segoe22.drawString("Search: ", this.middleX - 150, 32, 0xFFFFFF);
            this.searchBar.drawTextBox();
            GL11.glDisable((int)3553);
        }
        int x = this.middleX - 50;
        if (clickTimerNotRunning) {
            this.hoveredItem = -1;
        }
        RenderUtil.scissorBox(0, 59, this.width, this.height - 42);
        GL11.glEnable((int)3089);
        int i = Math.max(-this.scroll * 3 / 20 - 3, 0);
        while (i < navigatorDisplayList.size()) {
            int y = 60 + i / 3 * 20 + this.scroll;
            if (y >= 40) {
                if (y > this.height - 40) break;
                int xi = 0;
                switch (i % 3) {
                    case 0: {
                        xi = x - 104;
                        break;
                    }
                    case 1: {
                        xi = x;
                        break;
                    }
                    case 2: {
                        xi = x + 104;
                    }
                }
                NavigatorItem item = navigatorDisplayList.get(i);
                Rectangle area = new Rectangle(xi, y, 100, 16);
                if (!clickTimerNotRunning) {
                    if (i == this.hoveredItem) {
                        float factor = this.expanding ? (this.clickTimer == 4 ? 1.0f : ((float)this.clickTimer + partialTicks) / 4.0f) : (this.clickTimer == 0 ? 0.0f : ((float)this.clickTimer - partialTicks) / 4.0f);
                        float antiFactor = 1.0f - factor;
                        area.x = (int)((float)area.x * antiFactor + (float)(this.middleX - 154) * factor);
                        area.y = (int)((float)area.y * antiFactor + 60.0f * factor);
                        area.width = (int)((float)area.width * antiFactor + 308.0f * factor);
                        area.height = (int)((float)area.height * antiFactor + (float)(this.height - 103) * factor);
                        this.drawBackgroundBox(area.x, area.y, area.x + area.width, area.y + area.height);
                    }
                } else {
                    boolean hovering = area.contains(mouseX, mouseY);
                    if (hovering) {
                        this.hoveredItem = i;
                    }
                    if (item.isEnabled()) {
                        if (item.isBlocked()) {
                            GL11.glColor4f((float)(hovering ? 1.0f : 0.875f), (float)0.0f, (float)0.0f, (float)0.5f);
                        } else {
                            GL11.glColor4f((float)0.0f, (float)(hovering ? 1.0f : 0.875f), (float)0.0f, (float)0.5f);
                        }
                    } else if (hovering) {
                        GL11.glColor4f((float)0.375f, (float)0.375f, (float)0.375f, (float)0.5f);
                    } else {
                        GL11.glColor4f((float)0.25f, (float)0.25f, (float)0.25f, (float)0.5f);
                    }
                    this.drawBox(area.x, area.y, area.x + area.width, area.y + area.height);
                    int bx1 = area.x + area.width - area.height;
                    int by1 = area.y + 2;
                    int by2 = by1 + area.height - 4;
                    GL11.glBegin((int)1);
                    GL11.glVertex2i((int)bx1, (int)by1);
                    GL11.glVertex2i((int)bx1, (int)by2);
                    GL11.glEnd();
                    if (hovering) {
                        this.hoveringArrow = mouseX >= bx1;
                    }
                    double oneThrird = (double)area.height / 3.0;
                    double twoThrirds = (double)area.height * 2.0 / 3.0;
                    double ax1 = (double)bx1 + oneThrird - 2.0;
                    double ax2 = (double)bx1 + twoThrirds + 2.0;
                    double ax3 = (double)bx1 + (double)area.height / 2.0;
                    double ay1 = (double)area.y + oneThrird;
                    double ay2 = (double)area.y + twoThrirds;
                    GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)(hovering ? 0.75f : 0.375f));
                    GL11.glBegin((int)4);
                    GL11.glVertex2d((double)ax1, (double)ay1);
                    GL11.glVertex2d((double)ax2, (double)ay1);
                    GL11.glVertex2d((double)ax3, (double)ay2);
                    GL11.glEnd();
                    GL11.glLineWidth((float)1.0f);
                    GL11.glColor4f((float)0.125f, (float)0.125f, (float)0.125f, (float)(hovering ? 0.75f : 0.5f));
                    GL11.glBegin((int)2);
                    GL11.glVertex2d((double)ax1, (double)ay1);
                    GL11.glVertex2d((double)ax2, (double)ay1);
                    GL11.glVertex2d((double)ax3, (double)ay2);
                    GL11.glEnd();
                    if (clickTimerNotRunning) {
                        String buttonText = item.getName();
                        Fonts.segoe15.drawString(buttonText, area.x + 4, area.y + 2, 0xFFFFFF);
                        GL11.glDisable((int)3553);
                    }
                }
            }
            ++i;
        }
        GL11.glDisable((int)3089);
    }

    public void setExpanding(boolean expanding) {
        this.expanding = expanding;
    }
}

