/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.navigator.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeSet;
import net.minecraft.client.gui.GuiButton;
import org.darkstorm.minecraft.gui.util.RenderUtil;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import tk.wurst_client.WurstClient;
import tk.wurst_client.font.Fonts;
import tk.wurst_client.navigator.PossibleKeybind;
import tk.wurst_client.navigator.gui.NavigatorFeatureScreen;
import tk.wurst_client.navigator.gui.NavigatorScreen;
import tk.wurst_client.options.KeybindManager;

public class NavigatorNewKeybindScreen
extends NavigatorScreen {
    private ArrayList<PossibleKeybind> possibleKeybinds;
    private NavigatorFeatureScreen parent;
    private int hoveredCommand = -1;
    private int selectedCommand = -1;
    private String selectedKey = "NONE";
    private String text;
    private GuiButton okButton;
    private boolean choosingKey;

    public NavigatorNewKeybindScreen(ArrayList<PossibleKeybind> possibleKeybinds, NavigatorFeatureScreen parent) {
        this.possibleKeybinds = possibleKeybinds;
        this.parent = parent;
    }

    @Override
    protected void actionPerformed(GuiButton button) throws IOException {
        if (!button.enabled) {
            return;
        }
        switch (button.id) {
            case 0: {
                if (this.choosingKey) {
                    WurstClient wurst = WurstClient.INSTANCE;
                    if (wurst.keybinds.get(this.selectedKey) != null) {
                        ((TreeSet)wurst.keybinds.get(this.selectedKey)).add(this.possibleKeybinds.get(this.selectedCommand).getCommand());
                    } else {
                        wurst.keybinds.put(this.selectedKey, this.possibleKeybinds.get(this.selectedCommand).getCommand());
                    }
                    wurst.files.saveKeybinds();
                    this.mc.displayGuiScreen(this.parent);
                    wurst.navigator.addPreference(this.parent.getItem().getName());
                    wurst.files.saveNavigatorData();
                    break;
                }
                this.choosingKey = true;
                this.okButton.enabled = false;
                break;
            }
            case 1: {
                this.mc.displayGuiScreen(this.parent);
            }
        }
    }

    @Override
    protected void onResize() {
        this.okButton = new GuiButton(0, this.width / 2 - 151, this.height - 65, 149, 18, "OK");
        this.okButton.enabled = this.selectedCommand != -1;
        this.buttonList.add(this.okButton);
        this.buttonList.add(new GuiButton(1, this.width / 2 + 2, this.height - 65, 149, 18, "Cancel"));
    }

    @Override
    protected void onKeyPress(char typedChar, int keyCode) {
        if (this.choosingKey) {
            this.selectedKey = Keyboard.getKeyName((int)keyCode);
            this.okButton.enabled = !this.selectedKey.equals("NONE");
        } else if (keyCode == 1) {
            this.mc.displayGuiScreen(this.parent);
        }
    }

    @Override
    protected void onMouseClick(int x, int y, int button) {
        if (this.hoveredCommand != -1) {
            this.selectedCommand = this.hoveredCommand;
            this.okButton.enabled = true;
        }
    }

    @Override
    protected void onMouseDrag(int x, int y, int button, long timeDragged) {
    }

    @Override
    protected void onMouseRelease(int x, int y, int button) {
    }

    @Override
    protected void onUpdate() {
        if (this.choosingKey) {
            this.text = "Now press the key that should trigger this keybind.";
            if (!this.selectedKey.equals("NONE")) {
                this.text = String.valueOf(this.text) + "\n\nKey: " + this.selectedKey;
                KeybindManager keybinds = WurstClient.INSTANCE.keybinds;
                if (keybinds.get(this.selectedKey) != null) {
                    this.text = String.valueOf(this.text) + "\n\nWARNING: This key is already bound to the following command(s):";
                    ((TreeSet)keybinds.get(this.selectedKey)).forEach(cmd -> {
                        String string = this.text = String.valueOf(this.text) + "\n- " + cmd;
                    });
                }
            }
        } else {
            this.text = "Select what this keybind should do.";
        }
        if (this.choosingKey) {
            this.setContentHeight(Fonts.segoe15.getStringHeight(this.text));
        } else {
            this.setContentHeight(this.possibleKeybinds.size() * 24 - 10);
        }
    }

    @Override
    protected void onRender(int mouseX, int mouseY, float partialTicks) {
        this.drawCenteredString(Fonts.segoe22, "New Keybind", this.middleX, 32, 0xFFFFFF);
        GL11.glDisable((int)3553);
        int bgx1 = this.middleX - 154;
        int bgx2 = this.middleX + 154;
        int bgy1 = 60;
        int bgy2 = this.height - 43;
        RenderUtil.scissorBox(bgx1, bgy1, bgx2, bgy2 - (this.buttonList.isEmpty() ? 0 : 24));
        GL11.glEnable((int)3089);
        if (!this.choosingKey) {
            this.hoveredCommand = -1;
            int yi = bgy1 - 12 + this.scroll;
            int i = 0;
            while (i < this.possibleKeybinds.size()) {
                PossibleKeybind possibleKeybind = this.possibleKeybinds.get(i);
                int x1 = bgx1 + 2;
                int x2 = bgx2 - 2;
                int y1 = yi += 24;
                int y2 = y1 + 20;
                if (mouseX >= x1 && mouseX <= x2 && mouseY >= y1 && mouseY <= y2) {
                    this.hoveredCommand = i;
                    if (i == this.selectedCommand) {
                        GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)0.375f);
                    } else {
                        GL11.glColor4f((float)0.25f, (float)0.25f, (float)0.25f, (float)0.375f);
                    }
                } else if (i == this.selectedCommand) {
                    GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)0.25f);
                } else {
                    GL11.glColor4f((float)0.25f, (float)0.25f, (float)0.25f, (float)0.25f);
                }
                this.drawBox(x1, y1, x2, y2);
                this.drawString(Fonts.segoe15, String.valueOf(possibleKeybind.getDescription()) + "\n" + possibleKeybind.getCommand(), x1 + 1, y1 - 1, 0xFFFFFF);
                GL11.glDisable((int)3553);
                ++i;
            }
        }
        this.drawString(Fonts.segoe15, this.text, bgx1 + 2, bgy1 + this.scroll, 0xFFFFFF);
        GL11.glDisable((int)3089);
        int i = 0;
        while (i < this.buttonList.size()) {
            GuiButton button = (GuiButton)this.buttonList.get(i);
            int x1 = button.xPosition;
            int x2 = x1 + button.getButtonWidth();
            int y1 = button.yPosition;
            int y2 = y1 + 18;
            if (!button.enabled) {
                GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.25f);
            } else if (mouseX >= x1 && mouseX <= x2 && mouseY >= y1 && mouseY <= y2) {
                GL11.glColor4f((float)0.375f, (float)0.375f, (float)0.375f, (float)0.25f);
            } else {
                GL11.glColor4f((float)0.25f, (float)0.25f, (float)0.25f, (float)0.25f);
            }
            GL11.glDisable((int)3553);
            this.drawBox(x1, y1, x2, y2);
            this.drawCenteredString(Fonts.segoe18, button.displayString, (x1 + x2) / 2, y1 + 2, 0xFFFFFF);
            ++i;
        }
    }
}

