/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.navigator.gui;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.client.gui.GuiButton;
import org.darkstorm.minecraft.gui.util.RenderUtil;
import org.lwjgl.opengl.GL11;
import tk.wurst_client.WurstClient;
import tk.wurst_client.font.Fonts;
import tk.wurst_client.navigator.PossibleKeybind;
import tk.wurst_client.navigator.gui.NavigatorFeatureScreen;
import tk.wurst_client.navigator.gui.NavigatorScreen;

public class NavigatorRemoveKeybindScreen
extends NavigatorScreen {
    private NavigatorFeatureScreen parent;
    private TreeMap<String, PossibleKeybind> existingKeybinds;
    private String hoveredKey = "";
    private String selectedKey = "";
    private String text = "Select the keybind you want to remove.";
    private GuiButton removeButton;

    public NavigatorRemoveKeybindScreen(TreeMap<String, PossibleKeybind> existingKeybinds, NavigatorFeatureScreen parent) {
        this.existingKeybinds = existingKeybinds;
        this.parent = parent;
    }

    @Override
    protected void actionPerformed(GuiButton button) throws IOException {
        if (!button.enabled) {
            return;
        }
        switch (button.id) {
            case 0: {
                WurstClient wurst = WurstClient.INSTANCE;
                if (((TreeSet)wurst.keybinds.get(this.selectedKey)).size() == 1) {
                    wurst.keybinds.remove(this.selectedKey);
                } else {
                    ((TreeSet)wurst.keybinds.get(this.selectedKey)).remove(this.existingKeybinds.get(this.selectedKey).getCommand());
                }
                wurst.files.saveKeybinds();
                this.mc.displayGuiScreen(this.parent);
                wurst.navigator.addPreference(this.parent.getItem().getName());
                wurst.files.saveNavigatorData();
                break;
            }
            case 1: {
                this.mc.displayGuiScreen(this.parent);
            }
        }
    }

    @Override
    protected void onResize() {
        this.removeButton = new GuiButton(0, this.width / 2 - 151, this.height - 65, 149, 18, "Remove");
        this.removeButton.enabled = !this.selectedKey.isEmpty();
        this.buttonList.add(this.removeButton);
        this.buttonList.add(new GuiButton(1, this.width / 2 + 2, this.height - 65, 149, 18, "Cancel"));
    }

    @Override
    protected void onKeyPress(char typedChar, int keyCode) {
        if (keyCode == 1) {
            this.mc.displayGuiScreen(this.parent);
        }
    }

    @Override
    protected void onMouseClick(int x, int y, int button) {
        if (!this.hoveredKey.isEmpty()) {
            this.selectedKey = this.hoveredKey;
            this.removeButton.enabled = true;
        }
    }

    @Override
    protected void onMouseDrag(int x, int y, int button, long timeDragged) {
    }

    @Override
    protected void onMouseRelease(int x, int y, int button) {
    }

    @Override
    protected void onUpdate() {
        this.setContentHeight(this.existingKeybinds.size() * 24 - 10);
    }

    @Override
    protected void onRender(int mouseX, int mouseY, float partialTicks) {
        this.drawCenteredString(Fonts.segoe22, "Remove Keybind", this.middleX, 32, 0xFFFFFF);
        GL11.glDisable((int)3553);
        int bgx1 = this.middleX - 154;
        int bgx2 = this.middleX + 154;
        int bgy1 = 60;
        int bgy2 = this.height - 43;
        RenderUtil.scissorBox(bgx1, bgy1, bgx2, bgy2 - (this.buttonList.isEmpty() ? 0 : 24));
        GL11.glEnable((int)3089);
        this.hoveredKey = "";
        int yi = bgy1 - 12 + this.scroll;
        for (Map.Entry<String, PossibleKeybind> entry : this.existingKeybinds.entrySet()) {
            String key = entry.getKey();
            PossibleKeybind keybind = entry.getValue();
            int x1 = bgx1 + 2;
            int x2 = bgx2 - 2;
            int y1 = yi += 24;
            int y2 = y1 + 20;
            if (mouseX >= x1 && mouseX <= x2 && mouseY >= y1 && mouseY <= y2) {
                this.hoveredKey = key;
                if (key.equals(this.selectedKey)) {
                    GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)0.375f);
                } else {
                    GL11.glColor4f((float)0.25f, (float)0.25f, (float)0.25f, (float)0.375f);
                }
            } else if (key.equals(this.selectedKey)) {
                GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)0.25f);
            } else {
                GL11.glColor4f((float)0.25f, (float)0.25f, (float)0.25f, (float)0.25f);
            }
            this.drawBox(x1, y1, x2, y2);
            this.drawString(Fonts.segoe15, String.valueOf(key) + ": " + keybind.getDescription() + "\n" + keybind.getCommand(), x1 + 1, y1 - 1, 0xFFFFFF);
            GL11.glDisable((int)3553);
        }
        this.drawString(Fonts.segoe15, this.text, bgx1 + 2, bgy1 + this.scroll, 0xFFFFFF);
        GL11.glDisable((int)3089);
        int i = 0;
        while (i < this.buttonList.size()) {
            GuiButton button = (GuiButton)this.buttonList.get(i);
            int x1 = button.xPosition;
            int x2 = x1 + button.getButtonWidth();
            int y1 = button.yPosition;
            int y2 = y1 + 18;
            if (!button.enabled) {
                GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.25f);
            } else if (mouseX >= x1 && mouseX <= x2 && mouseY >= y1 && mouseY <= y2) {
                GL11.glColor4f((float)0.375f, (float)0.375f, (float)0.375f, (float)0.25f);
            } else {
                GL11.glColor4f((float)0.25f, (float)0.25f, (float)0.25f, (float)0.25f);
            }
            GL11.glDisable((int)3553);
            this.drawBox(x1, y1, x2, y2);
            this.drawCenteredString(Fonts.segoe18, button.displayString, (x1 + x2) / 2, y1 + 2, 0xFFFFFF);
            ++i;
        }
    }
}

