/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.navigator.gui;

import java.awt.Rectangle;
import java.io.IOException;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class NavigatorScreen
extends GuiScreen {
    protected int scroll = 0;
    private int scrollKnobPosition = 2;
    private boolean scrolling;
    private int maxScroll;
    protected boolean scrollbarLocked;
    protected int middleX;
    protected boolean hasBackground = true;
    protected int nonScrollableArea = 26;
    private boolean showScrollbar;

    @Override
    public final void initGui() {
        this.middleX = this.width / 2;
        this.onResize();
    }

    @Override
    public final void keyTyped(char typedChar, int keyCode) throws IOException {
        this.onKeyPress(typedChar, keyCode);
    }

    @Override
    public final void mouseClicked(int x, int y, int button) throws IOException {
        super.mouseClicked(x, y, button);
        if (new Rectangle(this.width / 2 + 170, 60, 12, this.height - 103).contains(x, y)) {
            this.scrolling = true;
        }
        this.onMouseClick(x, y, button);
    }

    @Override
    public final void mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (this.scrolling && !this.scrollbarLocked && clickedMouseButton == 0) {
            this.scroll = this.maxScroll == 0 ? 0 : (int)((float)(mouseY - 72) * (float)this.maxScroll / (float)(this.height - 131));
            if (this.scroll > 0) {
                this.scroll = 0;
            } else if (this.scroll < this.maxScroll) {
                this.scroll = this.maxScroll;
            }
        }
        this.onMouseDrag(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    @Override
    public final void mouseReleased(int x, int y, int button) {
        super.mouseReleased(x, y, button);
        this.scrolling = false;
        this.onMouseRelease(x, y, button);
    }

    @Override
    public final void updateScreen() {
        this.onUpdate();
        if (!this.scrollbarLocked) {
            this.scroll += Mouse.getDWheel() / 10;
            if (this.scroll > 0) {
                this.scroll = 0;
            } else if (this.scroll < this.maxScroll) {
                this.scroll = this.maxScroll;
            }
            this.scrollKnobPosition = this.maxScroll == 0 ? 0 : (int)((float)((this.height - 131) * this.scroll) / (float)this.maxScroll);
            this.scrollKnobPosition += 2;
        }
    }

    @Override
    public final void drawScreen(int mouseX, int mouseY, float partialTicks) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3553);
        GL11.glShadeModel((int)7425);
        int bgx1 = this.middleX - 154;
        int bgx2 = this.middleX + 154;
        int bgy1 = 60;
        int bgy2 = this.height - 43;
        if (this.hasBackground) {
            this.drawBackgroundBox(bgx1, bgy1, bgx2, bgy2);
        }
        if (this.showScrollbar) {
            int x1 = bgx2 + 16;
            int x2 = x1 + 12;
            int y1 = bgy1;
            int y2 = bgy2;
            this.drawBackgroundBox(x1, y1, x2, y2);
            y2 = (y1 += this.scrollKnobPosition) + 24;
            this.drawForegroundBox(x1 += 2, y1, x2 -= 2, y2);
            ++x1;
            --x2;
            y1 += 8;
            y2 -= 15;
            int i = 0;
            while (i < 3) {
                this.drawDownShadow(x1, y1, x2, y2);
                y1 += 4;
                y2 += 4;
                ++i;
            }
        }
        this.onRender(mouseX, mouseY, partialTicks);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    protected abstract void onResize();

    protected abstract void onKeyPress(char var1, int var2);

    protected abstract void onMouseClick(int var1, int var2, int var3);

    protected abstract void onMouseDrag(int var1, int var2, int var3, long var4);

    protected abstract void onMouseRelease(int var1, int var2, int var3);

    protected abstract void onUpdate();

    protected abstract void onRender(int var1, int var2, float var3);

    @Override
    public final boolean doesGuiPauseGame() {
        return false;
    }

    protected final void setContentHeight(int contentHeight) {
        this.maxScroll = this.height - contentHeight - this.nonScrollableArea - 120;
        if (this.maxScroll > 0) {
            this.maxScroll = 0;
        }
        this.showScrollbar = this.maxScroll != 0;
    }

    protected final void drawQuads(int x1, int y1, int x2, int y2) {
        GL11.glBegin((int)7);
        GL11.glVertex2i((int)x1, (int)y1);
        GL11.glVertex2i((int)x2, (int)y1);
        GL11.glVertex2i((int)x2, (int)y2);
        GL11.glVertex2i((int)x1, (int)y2);
        GL11.glEnd();
    }

    protected final void drawBoxShadow(int x1, int y1, int x2, int y2) {
        double xi1 = (double)x1 - 0.1;
        double xi2 = (double)x2 + 0.1;
        double yi1 = (double)y1 - 0.1;
        double yi2 = (double)y2 + 0.1;
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
        GL11.glBegin((int)2);
        GL11.glVertex2d((double)xi1, (double)yi1);
        GL11.glVertex2d((double)xi2, (double)yi1);
        GL11.glVertex2d((double)xi2, (double)yi2);
        GL11.glVertex2d((double)xi1, (double)yi2);
        GL11.glEnd();
        xi1 -= 0.9;
        xi2 += 0.9;
        yi1 -= 0.9;
        yi2 += 0.9;
        GL11.glBegin((int)9);
        GL11.glColor4f((float)0.125f, (float)0.125f, (float)0.125f, (float)0.75f);
        GL11.glVertex2d((double)x1, (double)y1);
        GL11.glVertex2d((double)x2, (double)y1);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex2d((double)xi2, (double)yi1);
        GL11.glVertex2d((double)xi1, (double)yi1);
        GL11.glVertex2d((double)xi1, (double)yi2);
        GL11.glColor4f((float)0.125f, (float)0.125f, (float)0.125f, (float)0.75f);
        GL11.glVertex2d((double)x1, (double)y2);
        GL11.glEnd();
        GL11.glBegin((int)9);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glVertex2d((double)x2, (double)y1);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex2d((double)xi2, (double)yi1);
        GL11.glVertex2d((double)xi2, (double)yi2);
        GL11.glVertex2d((double)xi1, (double)yi2);
        GL11.glColor4f((float)0.125f, (float)0.125f, (float)0.125f, (float)0.75f);
        GL11.glVertex2d((double)x1, (double)y2);
        GL11.glEnd();
    }

    protected final void drawInvertedBoxShadow(int x1, int y1, int x2, int y2) {
        double xi1 = (double)x1 + 0.1;
        double xi2 = (double)x2 - 0.1;
        double yi1 = (double)y1 + 0.1;
        double yi2 = (double)y2 - 0.1;
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
        GL11.glLineWidth((float)1.0f);
        GL11.glBegin((int)2);
        GL11.glVertex2d((double)xi1, (double)yi1);
        GL11.glVertex2d((double)xi2, (double)yi1);
        GL11.glVertex2d((double)xi2, (double)yi2);
        GL11.glVertex2d((double)xi1, (double)yi2);
        GL11.glEnd();
        xi1 += 0.9;
        xi2 -= 0.9;
        yi1 += 0.9;
        yi2 -= 0.9;
        GL11.glBegin((int)9);
        GL11.glColor4f((float)0.125f, (float)0.125f, (float)0.125f, (float)0.75f);
        GL11.glVertex2d((double)x1, (double)y1);
        GL11.glVertex2d((double)x2, (double)y1);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex2d((double)xi2, (double)yi1);
        GL11.glVertex2d((double)xi1, (double)yi1);
        GL11.glVertex2d((double)xi1, (double)yi2);
        GL11.glColor4f((float)0.125f, (float)0.125f, (float)0.125f, (float)0.75f);
        GL11.glVertex2d((double)x1, (double)y2);
        GL11.glEnd();
        GL11.glBegin((int)9);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glVertex2d((double)x2, (double)y1);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex2d((double)xi2, (double)yi1);
        GL11.glVertex2d((double)xi2, (double)yi2);
        GL11.glVertex2d((double)xi1, (double)yi2);
        GL11.glColor4f((float)0.125f, (float)0.125f, (float)0.125f, (float)0.75f);
        GL11.glVertex2d((double)x1, (double)y2);
        GL11.glEnd();
    }

    protected final void drawDownShadow(int x1, int y1, int x2, int y2) {
        double yi1 = (double)y1 + 0.1;
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
        GL11.glLineWidth((float)1.0f);
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)x1, (double)yi1);
        GL11.glVertex2d((double)x2, (double)yi1);
        GL11.glEnd();
        GL11.glBegin((int)9);
        GL11.glColor4f((float)0.125f, (float)0.125f, (float)0.125f, (float)0.75f);
        GL11.glVertex2i((int)x1, (int)y1);
        GL11.glVertex2i((int)x2, (int)y1);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex2i((int)x2, (int)y2);
        GL11.glVertex2i((int)x1, (int)y2);
        GL11.glEnd();
    }

    protected final void drawBox(int x1, int y1, int x2, int y2) {
        this.drawQuads(x1, y1, x2, y2);
        this.drawBoxShadow(x1, y1, x2, y2);
    }

    protected final void drawEngravedBox(int x1, int y1, int x2, int y2) {
        this.drawQuads(x1, y1, x2, y2);
        this.drawInvertedBoxShadow(x1, y1, x2, y2);
    }

    protected final void setColorToBackground() {
        GL11.glColor4f((float)0.25f, (float)0.25f, (float)0.25f, (float)0.5f);
    }

    protected final void setColorToForeground() {
        GL11.glColor4f((float)0.25f, (float)0.25f, (float)0.25f, (float)0.25f);
    }

    protected final void drawBackgroundBox(int x1, int y1, int x2, int y2) {
        this.setColorToBackground();
        this.drawBox(x1, y1, x2, y2);
    }

    protected final void drawForegroundBox(int x1, int y1, int x2, int y2) {
        this.setColorToForeground();
        this.drawBox(x1, y1, x2, y2);
    }
}

