/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.navigator.settings;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import tk.wurst_client.WurstClient;
import tk.wurst_client.navigator.PossibleKeybind;
import tk.wurst_client.navigator.gui.NavigatorFeatureScreen;
import tk.wurst_client.navigator.settings.NavigatorSetting;

public class CheckboxSetting
implements NavigatorSetting {
    private final String name;
    private boolean checked;
    private boolean locked;
    private boolean lockChecked;
    private int y;

    public CheckboxSetting(String name, boolean checked) {
        this.name = name;
        this.checked = checked;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void addToFeatureScreen(NavigatorFeatureScreen featureScreen) {
        featureScreen.addText("\n\n");
        this.y = 60 + featureScreen.getTextHeight() - 8;
        this.update();
        featureScreen.addCheckbox(this);
    }

    @Override
    public ArrayList<PossibleKeybind> getPossibleKeybinds(String featureName) {
        ArrayList<PossibleKeybind> possibleKeybinds = new ArrayList<PossibleKeybind>();
        String fullName = String.valueOf(featureName) + " " + this.name;
        String command = ".setcheckbox " + featureName.toLowerCase() + " " + this.name.toLowerCase().replace(" ", "_") + " ";
        possibleKeybinds.add(new PossibleKeybind(String.valueOf(command) + "toggle", "Toggle " + fullName));
        possibleKeybinds.add(new PossibleKeybind(String.valueOf(command) + "on", "Enable " + fullName));
        possibleKeybinds.add(new PossibleKeybind(String.valueOf(command) + "off", "Disable " + fullName));
        return possibleKeybinds;
    }

    public final boolean isChecked() {
        return this.locked ? this.lockChecked : this.checked;
    }

    public final void setChecked(boolean checked) {
        if (!this.locked) {
            this.checked = checked;
            this.update();
            WurstClient.INSTANCE.files.saveNavigatorData();
        }
    }

    public final void toggle() {
        this.setChecked(!this.isChecked());
    }

    public final void lock(boolean lockChecked) {
        this.lockChecked = lockChecked;
        this.locked = true;
        this.update();
    }

    public final void unlock() {
        this.locked = false;
        this.update();
    }

    public final boolean isLocked() {
        return this.locked;
    }

    public final int getY() {
        return this.y;
    }

    @Override
    public final void save(JsonObject json) {
        json.addProperty(this.name, Boolean.valueOf(this.checked));
    }

    @Override
    public final void load(JsonObject json) {
        this.checked = json.get(this.name).getAsBoolean();
    }

    @Override
    public void update() {
    }
}

