/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.navigator.settings;

import com.google.gson.JsonObject;
import java.awt.Color;
import java.util.ArrayList;
import tk.wurst_client.WurstClient;
import tk.wurst_client.navigator.PossibleKeybind;
import tk.wurst_client.navigator.gui.NavigatorFeatureScreen;
import tk.wurst_client.navigator.settings.NavigatorSetting;

public class ModeSetting
implements NavigatorSetting {
    private String name;
    private String[] modes;
    private int selected;
    private NavigatorFeatureScreen.ButtonData[] buttons;
    private boolean locked;
    private int lockSelected;

    public ModeSetting(String name, String[] modes, int selected) {
        this.name = name;
        this.modes = modes;
        this.selected = selected;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void addToFeatureScreen(NavigatorFeatureScreen featureScreen) {
        featureScreen.addText("\n" + this.name + ":");
        int y = 0;
        this.buttons = new NavigatorFeatureScreen.ButtonData[this.modes.length];
        int i = 0;
        while (i < this.modes.length) {
            NavigatorFeatureScreen.ButtonData button;
            int x = featureScreen.getMiddleX();
            switch (i % 3) {
                case 0: {
                    x -= 148;
                    featureScreen.addText("\n\n");
                    y = 60 + featureScreen.getTextHeight() - 6;
                    break;
                }
                case 1: {
                    x -= 48;
                    break;
                }
                case 2: {
                    x += 52;
                }
            }
            final int iFinal = i;
            NavigatorFeatureScreen navigatorFeatureScreen = featureScreen;
            navigatorFeatureScreen.getClass();
            this.buttons[i] = button = new NavigatorFeatureScreen.ButtonData(navigatorFeatureScreen, x, y, 96, 16, this.modes[i], i == this.getSelected() ? 65280 : 0x404040){

                @Override
                public void press() {
                    ModeSetting.this.setSelected(iFinal);
                    WurstClient.INSTANCE.files.saveNavigatorData();
                }

                @Override
                public boolean isLocked() {
                    return ModeSetting.this.locked;
                }
            };
            featureScreen.addButton(button);
            ++i;
        }
    }

    @Override
    public ArrayList<PossibleKeybind> getPossibleKeybinds(String featureName) {
        ArrayList<PossibleKeybind> possibleKeybinds = new ArrayList<PossibleKeybind>();
        String fullName = String.valueOf(featureName) + " " + this.name;
        String command = ".setmode " + featureName.toLowerCase() + " " + this.name.toLowerCase().replace(" ", "_") + " ";
        String description = "Set " + fullName + " to ";
        possibleKeybinds.add(new PossibleKeybind(String.valueOf(command) + "next", "Next " + fullName));
        possibleKeybinds.add(new PossibleKeybind(String.valueOf(command) + "prev", "Previous " + fullName));
        String[] stringArray = this.modes;
        int n = this.modes.length;
        int n2 = 0;
        while (n2 < n) {
            String mode = stringArray[n2];
            possibleKeybinds.add(new PossibleKeybind(String.valueOf(command) + mode.toLowerCase().replace(" ", "_"), String.valueOf(description) + mode));
            ++n2;
        }
        return possibleKeybinds;
    }

    public final int getSelected() {
        return this.locked ? this.lockSelected : this.selected;
    }

    public final void setSelected(int selected) {
        if (!this.locked) {
            this.selected = selected;
            if (this.buttons != null) {
                int i = 0;
                while (i < this.buttons.length) {
                    this.buttons[i].color = i == selected ? new Color(65280) : new Color(0x404040);
                    ++i;
                }
            }
            this.update();
        }
    }

    public final String[] getModes() {
        return this.modes;
    }

    public final String getSelectedMode() {
        return this.modes[this.getSelected()];
    }

    public final void nextMode() {
        ++this.selected;
        if (this.selected >= this.modes.length) {
            this.selected = 0;
        }
        this.update();
    }

    public final void prevMode() {
        --this.selected;
        if (this.selected <= -1) {
            this.selected = this.modes.length - 1;
        }
        this.update();
    }

    public final int indexOf(String mode) {
        int i = 0;
        while (i < this.modes.length) {
            if (this.modes[i].equalsIgnoreCase(mode)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final void lock(int lockSelected) {
        this.lockSelected = lockSelected;
        if (this.buttons != null) {
            int i = 0;
            while (i < this.buttons.length) {
                this.buttons[i].color = i == lockSelected ? new Color(65280) : new Color(0x404040);
                ++i;
            }
        }
        this.locked = true;
        this.update();
    }

    public final void unlock() {
        this.locked = false;
        this.setSelected(this.selected);
    }

    public final boolean isLocked() {
        return this.locked;
    }

    @Override
    public final void save(JsonObject json) {
        json.addProperty(this.name, (Number)this.selected);
    }

    @Override
    public final void load(JsonObject json) {
        this.setSelected(json.get(this.name).getAsInt());
    }

    @Override
    public void update() {
    }
}

