/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.navigator.settings;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import tk.wurst_client.navigator.PossibleKeybind;
import tk.wurst_client.navigator.gui.NavigatorFeatureScreen;
import tk.wurst_client.navigator.settings.NavigatorSetting;

public class SliderSetting
implements NavigatorSetting {
    private final String name;
    private double value;
    private String valueString;
    private final double minimum;
    private final double maximum;
    private final double increment;
    private int x;
    private int y;
    private float percentage;
    private final ValueDisplay valueDisplay;
    private boolean locked;
    private double lockMinimum;
    private double lockMaximum;
    private boolean disabled;

    public SliderSetting(String name, double value, double minimum, double maximum, double increment, ValueDisplay display) {
        this.name = name;
        this.value = value;
        this.minimum = minimum;
        this.maximum = maximum;
        this.increment = increment;
        this.valueDisplay = display;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void addToFeatureScreen(NavigatorFeatureScreen featureScreen) {
        featureScreen.addText("\n" + this.name + ":\n");
        this.y = 60 + featureScreen.getTextHeight();
        double newValue = this.getValue();
        this.valueString = this.valueDisplay.getValueString(newValue);
        this.percentage = (float)((newValue - this.minimum) / (this.maximum - this.minimum));
        this.x = (int)(this.percentage * 298.0f) + 1;
        this.update();
        featureScreen.addSlider(this);
    }

    @Override
    public ArrayList<PossibleKeybind> getPossibleKeybinds(String featureName) {
        ArrayList<PossibleKeybind> possibleKeybinds = new ArrayList<PossibleKeybind>();
        String fullName = String.valueOf(featureName) + " " + this.name;
        String command = ".setslider " + featureName.toLowerCase() + " " + this.name.toLowerCase().replace(" ", "_") + " ";
        possibleKeybinds.add(new PossibleKeybind(String.valueOf(command) + "more", "Increase " + fullName));
        possibleKeybinds.add(new PossibleKeybind(String.valueOf(command) + "less", "Decrease " + fullName));
        return possibleKeybinds;
    }

    public final double getValue() {
        return this.locked ? Math.min(Math.max(this.lockMinimum, this.value), this.lockMaximum) : this.value;
    }

    public final float getValueF() {
        return (float)this.getValue();
    }

    public final void setValue(double value) {
        if (!this.disabled) {
            this.value = this.locked ? Math.min(Math.max(this.lockMinimum, value), this.lockMaximum) : Math.min(Math.max(this.minimum, value), this.maximum);
        }
        double newValue = this.getValue();
        this.valueString = this.valueDisplay.getValueString(newValue);
        this.percentage = (float)((newValue - this.minimum) / (this.maximum - this.minimum));
        this.x = (int)(this.percentage * 298.0f) + 1;
        this.update();
    }

    public final void increaseValue() {
        this.setValue(this.getValue() + this.increment);
    }

    public final void decreaseValue() {
        this.setValue(this.getValue() - this.increment);
    }

    public final String getValueString() {
        return this.valueString;
    }

    public final double getMinimum() {
        return this.minimum;
    }

    public final double getMaximum() {
        return this.maximum;
    }

    public final double getIncrement() {
        return this.increment;
    }

    public final void lockToMinMax(double lockMinimum, double lockMaximum) {
        this.lockMinimum = Math.min(this.maximum, Math.max(lockMinimum, this.minimum));
        this.lockMaximum = Math.min(this.maximum, Math.max(lockMaximum, this.minimum));
        this.locked = true;
        double lockValue = Math.min(Math.max(this.lockMinimum, this.value), this.lockMaximum);
        this.valueString = this.valueDisplay.getValueString(lockValue);
        this.percentage = (float)((lockValue - this.minimum) / (this.maximum - this.minimum));
        this.x = (int)(this.percentage * 298.0f) + 1;
        this.update();
    }

    public final void lockToMin(double lockMinimum) {
        this.lockToMinMax(lockMinimum, this.maximum);
    }

    public final void lockToMax(double lockMaximum) {
        this.lockToMinMax(this.minimum, lockMaximum);
    }

    public final void lockToValue(double lockValue) {
        this.lockToMinMax(lockValue, lockValue);
    }

    public final void unlock() {
        this.locked = false;
        this.setValue(this.value);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public int getLockMinX() {
        return (int)((this.lockMinimum - this.minimum) / (this.maximum - this.minimum) * 298.0);
    }

    public int getLockMaxX() {
        return (int)((this.lockMaximum - this.minimum) / (this.maximum - this.minimum) * 298.0);
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final float getPercentage() {
        return this.percentage;
    }

    @Override
    public final void save(JsonObject json) {
        json.addProperty(this.name, (Number)this.getValue());
    }

    @Override
    public final void load(JsonObject json) {
        this.value = json.get(this.name).getAsDouble();
    }

    @Override
    public void update() {
    }

    public static enum ValueDisplay {
        DECIMAL(v -> Double.toString(v)),
        INTEGER(v -> Integer.toString((int)v)),
        PERCENTAGE(v -> String.valueOf(v * 1000000.0 * 100.0 * 1000000.0 / 1.0E12) + "%"),
        DEGREES(v -> String.valueOf((int)v) + "\u00b0"),
        NONE(v -> "");

        private ValueProcessor processor;

        private ValueDisplay(ValueProcessor processor) {
            this.processor = processor;
        }

        public String getValueString(double value) {
            return this.processor.getValueString(value);
        }

        private static interface ValueProcessor {
            public String getValueString(double var1);
        }
    }
}

