/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.network.play.client.CPacketPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class BlockUtils {
    public static void faceBlockClient(BlockPos blockPos) {
        double diffX = (double)blockPos.getX() + 0.5 - Minecraft.getMinecraft().thePlayer.posX;
        double diffY = (double)blockPos.getY() + 0.5 - (Minecraft.getMinecraft().thePlayer.posY + (double)Minecraft.getMinecraft().thePlayer.getEyeHeight());
        double diffZ = (double)blockPos.getZ() + 0.5 - Minecraft.getMinecraft().thePlayer.posZ;
        double dist = MathHelper.sqrt_double(diffX * diffX + diffZ * diffZ);
        float yaw = (float)(Math.atan2(diffZ, diffX) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(diffY, dist) * 180.0 / Math.PI));
        Minecraft.getMinecraft().thePlayer.rotationYaw += MathHelper.wrapDegrees(yaw - Minecraft.getMinecraft().thePlayer.rotationYaw);
        Minecraft.getMinecraft().thePlayer.rotationPitch += MathHelper.wrapDegrees(pitch - Minecraft.getMinecraft().thePlayer.rotationPitch);
    }

    public static void faceBlockPacket(BlockPos blockPos) {
        double diffX = (double)blockPos.getX() + 0.5 - Minecraft.getMinecraft().thePlayer.posX;
        double diffY = (double)blockPos.getY() + 0.5 - (Minecraft.getMinecraft().thePlayer.posY + (double)Minecraft.getMinecraft().thePlayer.getEyeHeight());
        double diffZ = (double)blockPos.getZ() + 0.5 - Minecraft.getMinecraft().thePlayer.posZ;
        double dist = MathHelper.sqrt_double(diffX * diffX + diffZ * diffZ);
        float yaw = (float)(Math.atan2(diffZ, diffX) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(diffY, dist) * 180.0 / Math.PI));
        Minecraft.getMinecraft().thePlayer.connection.sendPacket(new CPacketPlayer.Rotation(Minecraft.getMinecraft().thePlayer.rotationYaw + MathHelper.wrapDegrees(yaw - Minecraft.getMinecraft().thePlayer.rotationYaw), Minecraft.getMinecraft().thePlayer.rotationPitch + MathHelper.wrapDegrees(pitch - Minecraft.getMinecraft().thePlayer.rotationPitch), Minecraft.getMinecraft().thePlayer.onGround));
    }

    public static void faceBlockClientHorizontally(BlockPos blockPos) {
        double diffX = (double)blockPos.getX() + 0.5 - Minecraft.getMinecraft().thePlayer.posX;
        double diffZ = (double)blockPos.getZ() + 0.5 - Minecraft.getMinecraft().thePlayer.posZ;
        float yaw = (float)(Math.atan2(diffZ, diffX) * 180.0 / Math.PI) - 90.0f;
        Minecraft.getMinecraft().thePlayer.rotationYaw += MathHelper.wrapDegrees(yaw - Minecraft.getMinecraft().thePlayer.rotationYaw);
    }

    public static float getPlayerBlockDistance(BlockPos blockPos) {
        return BlockUtils.getPlayerBlockDistance(blockPos.getX(), blockPos.getY(), blockPos.getZ());
    }

    public static float getPlayerBlockDistance(double posX, double posY, double posZ) {
        float xDiff = (float)(Minecraft.getMinecraft().thePlayer.posX - posX);
        float yDiff = (float)(Minecraft.getMinecraft().thePlayer.posY - posY);
        float zDiff = (float)(Minecraft.getMinecraft().thePlayer.posZ - posZ);
        return BlockUtils.getBlockDistance(xDiff, yDiff, zDiff);
    }

    public static float getBlockDistance(float xDiff, float yDiff, float zDiff) {
        return MathHelper.sqrt_float((xDiff - 0.5f) * (xDiff - 0.5f) + (yDiff - 0.5f) * (yDiff - 0.5f) + (zDiff - 0.5f) * (zDiff - 0.5f));
    }

    public static float getHorizontalPlayerBlockDistance(BlockPos blockPos) {
        float xDiff = (float)(Minecraft.getMinecraft().thePlayer.posX - (double)blockPos.getX());
        float zDiff = (float)(Minecraft.getMinecraft().thePlayer.posZ - (double)blockPos.getZ());
        return MathHelper.sqrt_float((xDiff - 0.5f) * (xDiff - 0.5f) + (zDiff - 0.5f) * (zDiff - 0.5f));
    }
}

