/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.versions.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import ru.turikhay.exceptions.ParseException;

public class DateTypeAdapter
implements JsonDeserializer<Date>,
JsonSerializer<Date> {
    private final DateFormat enUsFormat = DateFormat.getDateTimeInstance(2, 2, Locale.US);
    private final DateFormat iso8601Format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    @Override
    public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!(json instanceof JsonPrimitive)) {
            throw new JsonParseException("The date should be a string value");
        }
        Date date = this.toDate(json.getAsString());
        if (typeOfT == Date.class) {
            return date;
        }
        throw new IllegalArgumentException(this.getClass() + " cannot deserialize to " + typeOfT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
        DateFormat var4 = this.enUsFormat;
        DateFormat dateFormat = this.enUsFormat;
        synchronized (dateFormat) {
            return new JsonPrimitive(this.toString(src));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(Date date) {
        DateFormat var2 = this.enUsFormat;
        DateFormat dateFormat = this.enUsFormat;
        synchronized (dateFormat) {
            String result = this.iso8601Format.format(date);
            return result.substring(0, 22) + ":" + result.substring(22);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date toDate(String string) {
        DateFormat var2 = this.enUsFormat;
        DateFormat dateFormat = this.enUsFormat;
        synchronized (dateFormat) {
            Date var10000;
            try {
                var10000 = this.enUsFormat.parse(string);
            }
            catch (Exception var7) {
                Date var100002;
                try {
                    var100002 = this.iso8601Format.parse(string);
                }
                catch (Exception var6) {
                    Date var100003;
                    try {
                        String e = string.replace("Z", "+00:00");
                        e = e.substring(0, 22) + e.substring(23);
                        var100003 = this.iso8601Format.parse(e);
                    }
                    catch (Exception var5) {
                        throw new ParseException("Invalid date: " + string, var5);
                    }
                    return var100003;
                }
                return var100002;
            }
            return var10000;
        }
    }
}

