/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.accounts;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.ui.accounts.UsernameField;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.center.CenterPanel;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.loc.LocalizableRadioButton;
import ru.turikhay.tlauncher.ui.progress.ProgressBar;
import ru.turikhay.tlauncher.ui.scenes.AccountEditorScene;
import ru.turikhay.tlauncher.ui.swing.CheckBoxListener;
import ru.turikhay.tlauncher.ui.text.ExtendedPasswordField;

public class AccountEditor
extends CenterPanel {
    private static final String passlock = "passlock";
    private final AccountEditorScene scene;
    public final UsernameField username;
    public final BlockablePasswordField password;
    public final ButtonGroup authGroup;
    public final LinkedHashMap<Account.AccountType, AuthTypeRadio> radioMap = new LinkedHashMap();
    public final LocalizableButton save;
    private final ProgressBar progressBar;

    public AccountEditor(AccountEditorScene sc) {
        super(squareInsets);
        this.scene = sc;
        ActionListener enterHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccountEditor.this.defocus();
                ((AccountEditor)AccountEditor.this).scene.handler.saveEditor();
            }
        };
        this.username = new UsernameField((CenterPanel)this, UsernameField.UsernameState.EMAIL);
        this.username.addActionListener(enterHandler);
        this.password = new BlockablePasswordField(null);
        this.password.addActionListener(enterHandler);
        this.password.setEnabled(false);
        this.authGroup = new ButtonGroup();
        this.save = new LocalizableButton("account.save");
        this.save.addActionListener(enterHandler);
        this.progressBar = new ProgressBar();
        this.progressBar.setPreferredSize(new Dimension(200, 20));
        this.add((Component)this.del(0));
        this.add((Component)AccountEditor.sepPan(this.username));
        this.add(Box.createVerticalStrut(5));
        this.add((Component)AccountEditor.sepPan(this.password));
        this.add((Component)this.del(0));
        this.add((Component)AccountEditor.sepPan(this.save));
        this.add((Component)AccountEditor.sepPan(this.progressBar));
    }

    public Account.AccountType getSelectedAccountType() {
        Map.Entry<Account.AccountType, AuthTypeRadio> en;
        Iterator<Map.Entry<Account.AccountType, AuthTypeRadio>> i$ = this.radioMap.entrySet().iterator();
        do {
            if (i$.hasNext()) continue;
            return Account.AccountType.MOJANG;
        } while (!(en = i$.next()).getValue().isSelected());
        return en.getKey();
    }

    public void setSelectedAccountType(Account.AccountType type) {
        AuthTypeRadio selectable = this.radioMap.get((Object)type);
        if (selectable != null) {
            selectable.setSelected(true);
        }
    }

    public void fill(Account account) {
        this.setSelectedAccountType(account.getType());
        this.username.setText(account.getUsername());
        this.password.setText(null);
    }

    public void clear() {
        this.setSelectedAccountType(null);
        this.username.setText(null);
        this.password.setText(null);
    }

    public Account get() {
        Account account = new Account();
        account.setUsername(this.username.getValue());
        Account.AccountType type = this.getSelectedAccountType();
        switch (SyntheticClass_1.$SwitchMap$ru$turikhay$tlauncher$minecraft$auth$Account$AccountType[type.ordinal()]) {
            case 1: 
            case 2: {
                if (!this.password.hasPassword()) break;
                account.setPassword(this.password.getPassword());
            }
        }
        account.setType(type);
        return account;
    }

    @Override
    public Insets getInsets() {
        return squareInsets;
    }

    @Override
    public void block(Object reason) {
        super.block(reason);
        if (!reason.equals("empty")) {
            this.progressBar.setIndeterminate(true);
        }
    }

    @Override
    public void unblock(Object reason) {
        super.unblock(reason);
        if (!reason.equals("empty")) {
            this.progressBar.setIndeterminate(false);
        }
    }

    private class BlockablePasswordField
    extends ExtendedPasswordField
    implements Blockable {
        private BlockablePasswordField() {
        }

        @Override
        public void block(Object reason) {
            this.setEnabled(false);
        }

        @Override
        public void unblock(Object reason) {
            this.setEnabled(true);
        }

        BlockablePasswordField(Object x1) {
            this();
        }
    }

    public class AuthTypeRadio
    extends LocalizableRadioButton {
        private final Account.AccountType type;

        private AuthTypeRadio(Account.AccountType type) {
            super("account.auth." + type.toString());
            AccountEditor.this.radioMap.put(type, this);
            AccountEditor.this.authGroup.add(this);
            this.type = type;
            final boolean free = type == Account.AccountType.FREE;
            this.addItemListener(new CheckBoxListener(){

                @Override
                public void itemStateChanged(boolean newstate) {
                    if (newstate && !AccountEditor.this.password.hasPassword()) {
                        AccountEditor.this.password.setText(null);
                    }
                    Blocker.setBlocked(AccountEditor.this.password, AccountEditor.passlock, newstate &= free);
                    AccountEditor.this.username.setState(newstate ? UsernameField.UsernameState.USERNAME : UsernameField.UsernameState.EMAIL);
                    AccountEditor.this.defocus();
                }
            });
        }

        public Account.AccountType getAccountType() {
            return this.type;
        }
    }

    static class SyntheticClass_1 {
        static final int[] $SwitchMap$ru$turikhay$tlauncher$minecraft$auth$Account$AccountType = new int[Account.AccountType.values().length];

        SyntheticClass_1() {
        }

        static {
            try {
                SyntheticClass_1.$SwitchMap$ru$turikhay$tlauncher$minecraft$auth$Account$AccountType[Account.AccountType.ELY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SyntheticClass_1.$SwitchMap$ru$turikhay$tlauncher$minecraft$auth$Account$AccountType[Account.AccountType.MOJANG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SyntheticClass_1.$SwitchMap$ru$turikhay$tlauncher$minecraft$auth$Account$AccountType[Account.AccountType.FREE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

