/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util.statistics;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import ru.turikhay.tlauncher.exceptions.ConnectServerConfig;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.util.U;
import ru.turikhay.util.salf.connection.ConfigSeacher;
import ru.turikhay.util.salf.connection.ServerEntity;
import ru.turikhay.util.statistics.StatisticsCommand;

public class StatisticsSending
extends Thread {
    private static ConfigSeacher configSeacher = new ConfigSeacher(TLauncher.getStatisticsConfigUrl(), "StatisticsConfigUrl.json");
    private StatisticsCommand command;
    private Object object;

    public StatisticsSending(StatisticsCommand command, Object object) {
        this.command = command;
        this.object = object;
    }

    @Override
    public void run() {
        try {
            try {
                ServerEntity server = configSeacher.readServer();
                this.sendData(server);
            }
            catch (IOException | ConnectServerConfig var3) {
                this.log("can't send data by old data");
                configSeacher.saveConfigFromServer();
                ServerEntity server = configSeacher.readServer();
                this.sendData(server);
            }
        }
        catch (IOException | ConnectServerConfig var4) {
            this.log("can't send statistics using command " + this.command.name());
            U.log(var4);
        }
    }

    private void sendData(ServerEntity entity) throws ConnectServerConfig, IOException {
        Socket socket = new Socket(entity.getUrl(), entity.getPort());
        OutputStream outputStream = socket.getOutputStream();
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.print(this.command.name() + "\n");
        String line = new Gson().toJson(this.object);
        this.log("send to server = " + line);
        printWriter.print(line);
        printWriter.close();
        socket.close();
    }

    private void log(String line) {
        U.debug("[StatisticsSending] ", line);
    }
}

