/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.versions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import net.minecraft.launcher.versions.ExtractRules;
import net.minecraft.launcher.versions.Rule;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.tukaani.xz.XZInputStream;
import ru.turikhay.tlauncher.downloader.Downloadable;
import ru.turikhay.tlauncher.downloader.RetryDownloadException;
import ru.turikhay.tlauncher.repository.Repository;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.OS;
import ru.turikhay.util.U;

public class Library {
    protected static final String FORGE_LIB_SUFFIX = ".pack.xz";
    protected static final StrSubstitutor SUBSTITUTOR;
    protected String name;
    protected List<Rule> rules;
    protected Map<OS, String> natives;
    protected ExtractRules extract;
    protected String url;
    protected String exact_url;
    protected String packed;
    protected String checksum;
    protected List<String> deleteEntries;

    public boolean equals(Object o) {
        if (o != null && o instanceof Library) {
            Library lib = (Library)o;
            return this.name == null ? lib.name == null : this.name.equalsIgnoreCase(lib.name);
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getPlainName() {
        String[] split = this.name.split(":", 3);
        return split[0] + "." + split[1];
    }

    public List<Rule> getRules() {
        return this.rules == null ? null : Collections.unmodifiableList(this.rules);
    }

    public boolean appliesToCurrentEnvironment() {
        if (this.rules == null) {
            return true;
        }
        Rule.Action lastAction = Rule.Action.DISALLOW;
        for (Rule rule : this.rules) {
            Rule.Action action = rule.getAppliedAction();
            if (action == null) continue;
            lastAction = action;
        }
        return lastAction == Rule.Action.ALLOW;
    }

    public Map<OS, String> getNatives() {
        return this.natives;
    }

    public ExtractRules getExtractRules() {
        return this.extract;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public List<String> getDeleteEntriesList() {
        return this.deleteEntries;
    }

    String getArtifactBaseDir() {
        if (this.name == null) {
            throw new IllegalStateException("Cannot get artifact dir of empty/blank artifact");
        }
        String[] parts = this.name.split(":", 3);
        return String.format("%s/%s/%s", parts[0].replaceAll("\\.", "/"), parts[1], parts[2]);
    }

    public String getArtifactPath() {
        return this.getArtifactPath(null);
    }

    public String getArtifactPath(String classifier) {
        if (this.name == null) {
            throw new IllegalStateException("Cannot get artifact path of empty/blank artifact");
        }
        return String.format("%s/%s", this.getArtifactBaseDir(), this.getArtifactFilename(classifier));
    }

    String getArtifactFilename(String classifier) {
        if (this.name == null) {
            throw new IllegalStateException("Cannot get artifact filename of empty/blank artifact");
        }
        String[] parts = this.name.split(":", 3);
        String result = classifier == null ? String.format("%s-%s.jar", parts[1], parts[2]) : String.format("%s-%s%s.jar", parts[1], parts[2], "-" + classifier);
        return SUBSTITUTOR.replace(result);
    }

    public String toString() {
        return "Library{name='" + this.name + '\'' + ", rules=" + this.rules + ", natives=" + this.natives + ", extract=" + this.extract + ", packed='" + this.packed + "'}";
    }

    public Downloadable getDownloadable(Repository versionSource, File file, OS os) {
        String path;
        Repository repo = null;
        boolean isForge = "forge".equals(this.packed);
        if (this.exact_url == null) {
            String tempFile = this.natives != null && this.appliesToCurrentEnvironment() ? this.natives.get((Object)os) : null;
            path = this.getArtifactPath(tempFile) + (isForge ? FORGE_LIB_SUFFIX : "");
            if (this.url == null) {
                repo = Repository.LIBRARY_REPO;
            } else if (this.url.startsWith("/")) {
                repo = versionSource;
                path = this.url.substring(1) + path;
            } else {
                path = this.url + path;
            }
        } else {
            path = this.exact_url;
        }
        if (isForge) {
            File tempFile1 = new File(file.getAbsolutePath() + FORGE_LIB_SUFFIX);
            return new ForgeLibDownloadable(path, tempFile1, file);
        }
        return repo == null ? new LibraryDownloadable(path, file) : new LibraryDownloadable(repo, path, file);
    }

    /*
     * Loose catch block
     */
    private static synchronized void unpackLibrary(File library, File output, boolean retryOnOutOfMemory) throws IOException {
        JarOutputStream jos;
        XZInputStream in;
        block8: {
            Library.forgeLibLog("Synchronized unpacking:", library);
            output.delete();
            in = null;
            jos = null;
            try {
                FileInputStream in1 = new FileInputStream(library);
                in = new XZInputStream(in1);
                Library.forgeLibLog("Decompressing...");
                byte[] e = Library.readFully(in);
                Library.forgeLibLog("Decompressed successfully");
                String end = new String(e, e.length - 4, 4);
                if (!end.equals("SIGN")) {
                    throw new RetryDownloadException("signature missing");
                }
                Library.forgeLibLog("Signature matches!");
                int x = e.length;
                int len = e[x - 8] & 0xFF | (e[x - 7] & 0xFF) << 8 | (e[x - 6] & 0xFF) << 16 | (e[x - 5] & 0xFF) << 24;
                Library.forgeLibLog("Now getting checksums...");
                byte[] checksums = Arrays.copyOfRange(e, e.length - len - 8, e.length - 8);
                FileUtil.createFile(output);
                FileOutputStream jarBytes = new FileOutputStream(output);
                jos = new JarOutputStream(jarBytes);
                Library.forgeLibLog("Now unpacking...");
                Pack200.newUnpacker().unpack((InputStream)new ByteArrayInputStream(e), jos);
                Library.forgeLibLog("Unpacked successfully");
                Library.forgeLibLog("Now trying to write checksums...");
                jos.putNextEntry(new JarEntry("checksums.sha1"));
                jos.write(checksums);
                jos.closeEntry();
                Library.forgeLibLog("Now finishing...");
            }
            catch (OutOfMemoryError var15) {
                Library.forgeLibLog("Out of memory, oops", var15);
                U.gc();
                if (!retryOnOutOfMemory) {
                    throw var15;
                }
                Library.forgeLibLog("Retrying...");
                Library.close(in, jos);
                FileUtil.deleteFile(library);
                Library.unpackLibrary(library, output, false);
                Library.close(in, jos);
                FileUtil.deleteFile(library);
            }
            catch (IOException var16) {
                output.delete();
                throw var16;
                {
                    catch (Throwable throwable) {
                        Library.close(in, jos);
                        FileUtil.deleteFile(library);
                        throw throwable;
                    }
                }
            }
            break block8;
            return;
        }
        Library.close(in, jos);
        FileUtil.deleteFile(library);
        Library.forgeLibLog("Done:", output);
    }

    private static synchronized void unpackLibrary(File library, File output) throws IOException {
        Library.unpackLibrary(library, output, true);
    }

    private static void close(Closeable ... closeables) {
        Closeable[] arr$ = closeables;
        int len$ = closeables.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Closeable c = arr$[i$];
            try {
                c.close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static byte[] readFully(InputStream stream) throws IOException {
        int len;
        byte[] data = new byte[4096];
        ByteArrayOutputStream entryBuffer = new ByteArrayOutputStream();
        do {
            if ((len = stream.read(data)) <= 0) continue;
            entryBuffer.write(data, 0, len);
        } while (len != -1);
        return entryBuffer.toByteArray();
    }

    private static void forgeLibLog(Object ... o) {
        U.log("[ForgeLibDownloadable]", o);
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("platform", OS.CURRENT.getName());
        map.put("arch", OS.Arch.CURRENT.asString());
        SUBSTITUTOR = new StrSubstitutor(map);
    }

    public class LibraryDownloadable
    extends Downloadable {
        private LibraryDownloadable(Repository repo, String path, File file) {
            super(repo, path, file);
        }

        private LibraryDownloadable(String path, File file) {
            super(path, file);
        }

        public Library getDownloadableLibrary() {
            return Library.this;
        }

        public Library getLibrary() {
            return Library.this;
        }
    }

    public class ForgeLibDownloadable
    extends LibraryDownloadable {
        private final File unpacked;

        public ForgeLibDownloadable(String url, File packedLib, File unpackedLib) {
            super(url, packedLib);
            this.unpacked = unpackedLib;
        }

        @Override
        protected void onComplete() throws RetryDownloadException {
            super.onComplete();
            try {
                Library.unpackLibrary(this.getDestination(), this.unpacked);
            }
            catch (Throwable var2) {
                throw new RetryDownloadException("cannot unpack forge library", var2);
            }
        }
    }

    static class SyntheticClass_1 {
        SyntheticClass_1() {
        }
    }
}

