/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util.async;

import java.util.concurrent.atomic.AtomicInteger;
import ru.turikhay.util.U;

public abstract class ExtendedThread
extends Thread {
    private static AtomicInteger threadNum = new AtomicInteger();
    private final ExtendedThreadCaller caller;
    private String blockReason;
    private final Object monitor = new Object();

    public ExtendedThread(String name) {
        super(name + "#" + threadNum.incrementAndGet());
        this.caller = new ExtendedThreadCaller();
    }

    public ExtendedThread() {
        this("ExtendedThread");
    }

    public ExtendedThreadCaller getCaller() {
        return this.caller;
    }

    public void startAndWait() {
        super.start();
        while (!this.isThreadLocked()) {
            U.sleepFor(100L);
        }
    }

    @Override
    public abstract void run();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lockThread(String reason) {
        if (reason == null) {
            throw new NullPointerException();
        }
        this.checkCurrent();
        this.blockReason = reason;
        Object var2 = this.monitor;
        Object object = this.monitor;
        synchronized (object) {
            while (this.blockReason != null) {
                try {
                    this.monitor.wait();
                }
                catch (InterruptedException var5) {
                    var5.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockThread(String reason) {
        if (reason == null) {
            throw new NullPointerException();
        }
        if (!reason.equals(this.blockReason)) {
            throw new IllegalStateException("Unlocking denied! Locked with: " + this.blockReason + ", tried to unlock with: " + reason);
        }
        this.blockReason = null;
        Object var2 = this.monitor;
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.notifyAll();
        }
    }

    public void tryUnlock(String reason) {
        if (reason == null) {
            throw new NullPointerException();
        }
        if (reason.equals(this.blockReason)) {
            this.unlockThread(reason);
        }
    }

    public boolean isThreadLocked() {
        return this.blockReason != null;
    }

    public boolean isCurrent() {
        return Thread.currentThread().equals(this);
    }

    protected void checkCurrent() {
        if (!this.isCurrent()) {
            throw new IllegalStateException("Illegal thread!");
        }
    }

    protected void threadLog(Object ... o) {
        U.log("[" + this.getName() + "]", o);
    }

    public class ExtendedThreadCaller
    extends RuntimeException {
        private ExtendedThreadCaller() {
        }

        ExtendedThreadCaller(SyntheticClass_1 x1) {
            this();
        }
    }

    static class SyntheticClass_1 {
        SyntheticClass_1() {
        }
    }
}

