/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.eplus.client.gui;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.darkhax.bookshelf.client.gui.GuiGraphicButton;
import net.darkhax.bookshelf.lib.util.EnchantmentUtils;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.darkhax.bookshelf.lib.util.ModUtils;
import net.darkhax.eplus.EnchantingPlus;
import net.darkhax.eplus.client.gui.GuiEnchantmentLabel;
import net.darkhax.eplus.common.network.packet.PacketEnchantItem;
import net.darkhax.eplus.common.network.packet.PacketRepairItem;
import net.darkhax.eplus.handler.ConfigurationHandler;
import net.darkhax.eplus.inventory.ContainerAdvancedTable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import org.lwjgl.input.Mouse;

public class GuiAdvancedTable
extends GuiContainer {
    private static int guiOffset = 26;
    private static final ResourceLocation TEXTURE = new ResourceLocation("eplus", "textures/gui/enchant.png");
    private static final ResourceLocation BUTTON_ENCHANT = new ResourceLocation("eplus", "textures/gui/button_enchant.png");
    private static final ResourceLocation BUTTON_REPAIR = new ResourceLocation("eplus", "textures/gui/button_repair.png");
    private List<GuiEnchantmentLabel> enchantmentList = new ArrayList<GuiEnchantmentLabel>();
    private final EntityPlayer player;
    private final ContainerAdvancedTable container;
    private double sliderIndex = 0.0;
    private double enchantingPages = 0.0;
    private Map<Enchantment, Integer> enchantments;
    private boolean clicked = false;
    private boolean sliding = false;
    private int totalCost = 0;
    private boolean dirty = false;
    private GuiEnchantmentLabel last;

    public GuiAdvancedTable(InventoryPlayer inventory, World world, BlockPos pos) {
        super((Container)new ContainerAdvancedTable(inventory, world, pos));
        this.player = inventory.field_70458_d;
        this.container = (ContainerAdvancedTable)this.field_147002_h;
        this.field_146999_f = 235;
        this.field_147000_g = 182;
        this.field_73735_i = -1.0f;
    }

    protected void func_146284_a(GuiButton button) {
        HashMap<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
        for (GuiEnchantmentLabel label : this.enchantmentList) {
            if (label.enchantmentLevel == this.enchantments.get(label.enchantment) || label.locked) continue;
            enchants.put(label.enchantment, label.enchantmentLevel);
        }
        switch (button.field_146127_k) {
            case 0: {
                if (enchants.size() > 0) {
                    EnchantingPlus.network.sendToServer((IMessage)new PacketEnchantItem(this.totalCost, enchants));
                }
            }
            case 1: {
                if (enchants.size() != 0 || this.totalCost <= 0 || !ConfigurationHandler.allowRepairs) break;
                EnchantingPlus.network.sendToServer((IMessage)new PacketRepairItem(this.totalCost));
            }
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        boolean flag = Mouse.isButtonDown((int)0);
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        for (GuiEnchantmentLabel label : this.enchantmentList) {
            if (label.yPos < this.field_147009_r + 15 || label.yPos >= this.field_147009_r + 87) {
                label.show(false);
            } else {
                label.show(true);
            }
            label.draw(this.field_146289_q);
        }
        int adjustedMouseX = mouseX - this.field_147003_i;
        int adjustedMouseY = mouseY - this.field_147009_r;
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        int tempY = adjustedMouseY - 16;
        if (tempY <= 0) {
            tempY = 0;
        } else if (tempY >= 57) {
            tempY = 57;
        }
        double d = this.sliderIndex = this.sliding ? (double)Math.round((double)tempY / 57.0 * this.enchantingPages / 0.25) * 0.25 : this.sliderIndex;
        if (this.sliderIndex >= this.enchantingPages) {
            this.sliderIndex = this.enchantingPages;
        }
        double sliderY = this.sliding ? (double)tempY : 57.0 * (this.sliderIndex / this.enchantingPages);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.field_147003_i + guiOffset + 180, this.field_147009_r + 16 + (int)sliderY, 0, 182, 12, 15);
        if (!this.clicked && flag) {
            for (GuiEnchantmentLabel label : this.enchantmentList) {
                if (this.getSelectedLabel(mouseX, mouseY) != label || label.locked) continue;
                label.dragging = true;
            }
            if (adjustedMouseX <= 191 + guiOffset && adjustedMouseX >= 180 + guiOffset && this.enchantingPages != 0.0) {
                this.sliding = true;
            }
        }
        for (GuiEnchantmentLabel label : this.enchantmentList) {
            if (!label.dragging || this.getSelectedLabel(mouseX, mouseY) == label) continue;
            label.dragging = false;
            this.last = label;
        }
        if (!flag) {
            for (GuiEnchantmentLabel label : this.enchantmentList) {
                if (this.getSelectedLabel(mouseX, mouseY) != label) continue;
                label.dragging = false;
                this.last = label;
            }
            this.sliding = false;
        }
        this.clicked = flag;
        for (GuiEnchantmentLabel label : this.enchantmentList) {
            if (!label.dragging) continue;
            label.scroll(adjustedMouseX - 36, guiOffset + this.field_147003_i + 10);
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.updateEnchantmentLabels();
        int maxWidth = this.field_147003_i - 20;
        ArrayList<List> information = new ArrayList<List>();
        ItemStack stack = this.container.tableInventory.func_70301_a(0);
        information.add(this.field_146289_q.func_78271_c(String.format("%s: %s", I18n.func_135052_a((String)"tooltip.eplus.playerlevel", (Object[])new Object[0]), this.player.field_71068_ca), maxWidth));
        if (ItemStackUtils.isValidStack((ItemStack)stack)) {
            if (this.hasLevelChanged()) {
                boolean negExp;
                boolean exp = this.totalCost <= EnchantmentUtils.getExperienceFromLevel((int)1) && this.totalCost >= -EnchantmentUtils.getExperienceFromLevel((int)1);
                boolean bl = negExp = this.totalCost < 0;
                int finalCost = exp ? this.totalCost : (negExp ? -EnchantmentUtils.getLevelsFromExperience((int)(-this.totalCost)) : EnchantmentUtils.getLevelsFromExperience((int)this.totalCost));
                information.add(this.field_146289_q.func_78271_c(String.format("%s: %s", exp ? I18n.func_135052_a((String)"tooltip.eplus.experienceGained", (Object[])new Object[0]) : I18n.func_135052_a((String)"tooltip.eplus.enchant", (Object[])new Object[0]), finalCost), maxWidth));
            } else if (ConfigurationHandler.allowRepairs && stack.func_77948_v() && stack.func_77951_h()) {
                information.add(this.field_146289_q.func_78271_c(String.format("%s: %s", I18n.func_135052_a((String)"tooltip.eplus.repair", (Object[])new Object[0]), EnchantmentUtils.getLevelsFromExperience((int)this.totalCost)), maxWidth));
            }
        }
        information.add(this.field_146289_q.func_78271_c(String.format("%s: %s", I18n.func_135052_a((String)"tooltip.eplus.maxlevel", (Object[])new Object[0]), Float.valueOf(this.container.getEnchantingPower())), maxWidth));
        for (List display : information) {
            int height;
            int n = height = information.indexOf(display) == 0 ? this.field_147009_r + this.field_146289_q.field_78288_b + 8 : this.field_147009_r + (this.field_146289_q.field_78288_b + 8) * (information.indexOf(display) + 1);
            if (information.indexOf(display) > 0) {
                for (int i = information.indexOf(display) - 1; i >= 0; --i) {
                    height += (this.field_146289_q.field_78288_b + 3) * (((List)information.get(i)).size() - 1);
                }
            }
            this.drawHoveringText(display, this.field_147003_i - 20 - maxWidth, height, this.field_146289_q);
        }
        GuiEnchantmentLabel label = this.getSelectedLabel(mouseX, mouseY);
        if (GuiAdvancedTable.func_146272_n() && label != null && label.enchantment != null) {
            String enchName = ChatFormatting.BOLD + label.getTranslatedName();
            String description = I18n.func_135052_a((String)("description." + label.enchantment.func_77320_a()), (Object[])new Object[0]);
            description = description.startsWith("description.") ? ChatFormatting.RED + I18n.func_135052_a((String)"tooltip.eplus.nodesc", (Object[])new Object[0]) + ": description." + label.enchantment.func_77320_a() : ChatFormatting.LIGHT_PURPLE + description;
            ArrayList<String> display = new ArrayList<String>();
            display.add(enchName);
            display.addAll(this.field_146289_q.func_78271_c(description, 215));
            display.add(ChatFormatting.BLUE + "" + ChatFormatting.ITALIC + ModUtils.getModName((IForgeRegistryEntry.Impl)label.enchantment));
            this.drawHoveringText(display, mouseX, mouseY, this.field_146289_q);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int eventDWheel = Mouse.getEventDWheel();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c - this.field_147003_i;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1 - this.field_147009_r;
        if (eventDWheel != 0 && (mouseX >= 35 + guiOffset && mouseX <= this.field_146999_f + guiOffset - 32 || mouseX >= 180 + guiOffset && mouseX <= 192 + guiOffset) && mouseY >= 15 && mouseY <= 87) {
            if (eventDWheel < 0) {
                this.sliderIndex += 0.25;
                if (this.sliderIndex >= this.enchantingPages) {
                    this.sliderIndex = this.enchantingPages;
                }
            } else {
                this.sliderIndex -= 0.25;
                if (this.sliderIndex <= 0.0) {
                    this.sliderIndex = 0.0;
                }
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new GuiGraphicButton(0, this.field_147003_i + guiOffset + 9, this.field_147009_r + 38, BUTTON_ENCHANT));
        this.field_146292_n.add(new GuiGraphicButton(1, this.field_147003_i + guiOffset + 9, this.field_147009_r + 63, BUTTON_REPAIR));
        this.dirty = true;
    }

    public void func_73876_c() {
        super.func_73876_c();
        Map<Enchantment, Integer> enchantments = this.updateEnchantmentState(this.container.getEnchantments());
        this.handleChangedScreenSize(enchantments);
        this.updateEnchantmentLabels();
        this.enchantingPages = (double)this.enchantmentList.size() / 4.0 > 1.0 ? (double)this.enchantmentList.size() / 4.0 - 1.0 : 0.0;
        this.totalCost = 0;
        this.updateEnchantmentLabels(enchantments);
    }

    private GuiEnchantmentLabel getSelectedLabel(int mouseX, int mouseY) {
        if (mouseX < this.field_147003_i + guiOffset + 35 || mouseX > this.field_147003_i + this.field_146999_f - 32) {
            return null;
        }
        for (GuiEnchantmentLabel label : this.enchantmentList) {
            if (!label.show || mouseY < label.yPos || mouseY > label.yPos + label.height) continue;
            return label;
        }
        return null;
    }

    private void updateEnchantmentLabel(int level, GuiEnchantmentLabel label) {
        label.yPos = label.startingYPos - (int)(72.0 * this.sliderIndex);
        if (!label.locked && label.enchantmentLevel > level) {
            int cost = this.totalCost + this.container.enchantmentCost(label.enchantment, label.enchantmentLevel, level);
            if (!this.container.canPurchase(this.player, cost)) {
                while (label.enchantmentLevel > 0) {
                    label.dragging = false;
                    --label.enchantmentLevel;
                    cost = this.totalCost + this.container.enchantmentCost(label.enchantment, label.enchantmentLevel, level);
                    if (!this.container.canPurchase(this.player, cost)) continue;
                }
            }
            this.totalCost = cost;
        } else if (label.enchantmentLevel < level && !label.locked) {
            this.totalCost += this.container.getRebate(label.enchantment, label.enchantmentLevel, level);
        }
    }

    private void updateEnchantmentLabels(Map<Enchantment, Integer> enchantments) {
        if (!this.enchantmentList.isEmpty() && this.hasLevelChanged()) {
            for (GuiEnchantmentLabel label : this.enchantmentList) {
                if (label == this.last) continue;
                this.updateEnchantmentLabel(enchantments.get(label.enchantment), label);
            }
            if (this.last != null) {
                this.updateEnchantmentLabel(enchantments.get(this.last.enchantment), this.last);
            }
        } else if (ConfigurationHandler.allowRepairs && !this.hasLevelChanged()) {
            this.totalCost += this.container.getRepairCost();
            for (GuiEnchantmentLabel label : this.enchantmentList) {
                label.yPos = label.startingYPos - (int)(72.0 * this.sliderIndex);
            }
        }
    }

    private void handleChangedScreenSize(Map<Enchantment, Integer> enchantments) {
        if (this.dirty) {
            List<GuiEnchantmentLabel> labels = this.getEnchantmentLabels(enchantments, 35 + guiOffset + this.field_147003_i, 15 + this.field_147009_r);
            for (GuiEnchantmentLabel label : this.enchantmentList) {
                for (GuiEnchantmentLabel tempItem : labels) {
                    if (label.enchantment != tempItem.enchantment) continue;
                    label.startingXPos = label.xPos = tempItem.xPos;
                    label.startingYPos = label.yPos = tempItem.yPos;
                }
            }
            this.dirty = false;
        }
    }

    protected boolean hasLevelChanged() {
        for (GuiEnchantmentLabel label : this.enchantmentList) {
            if (label.enchantmentLevel == label.currentLevel) continue;
            return true;
        }
        return false;
    }

    private void updateEnchantmentLabels() {
        int labelIndex = 0;
        for (GuiEnchantmentLabel label : this.enchantmentList) {
            label.locked = false;
        }
        for (GuiEnchantmentLabel mainLabel : this.enchantmentList) {
            if (mainLabel.enchantmentLevel != 0) {
                ++labelIndex;
                for (GuiEnchantmentLabel otherLabel : this.enchantmentList) {
                    if (mainLabel == otherLabel || EnchantmentUtils.areEnchantmentsCompatible((Enchantment)mainLabel.enchantment, (Enchantment)otherLabel.enchantment)) continue;
                    otherLabel.locked = true;
                }
                continue;
            }
            if (this.player.field_71075_bZ.field_75098_d || ConfigurationHandler.maxEnchantmentAmount <= 0 || labelIndex < ConfigurationHandler.maxEnchantmentAmount) continue;
            mainLabel.locked = true;
        }
    }

    private List<GuiEnchantmentLabel> getEnchantmentLabels(Map<Enchantment, Integer> map, int x, int y) {
        ArrayList<GuiEnchantmentLabel> labels = new ArrayList<GuiEnchantmentLabel>();
        if (map == null) {
            return labels;
        }
        int pixelHeight = 0;
        int yPos = y;
        for (Enchantment enchantment : map.keySet()) {
            labels.add(new GuiEnchantmentLabel(this.container, enchantment, map.get(enchantment), x, yPos));
            yPos = y + ++pixelHeight * 18;
        }
        return labels;
    }

    private Map<Enchantment, Integer> updateEnchantmentState(Map<Enchantment, Integer> enchantments) {
        if (this.enchantments != enchantments) {
            this.enchantments = enchantments;
            this.enchantmentList = this.getEnchantmentLabels(enchantments, 35 + guiOffset + this.field_147003_i, 15 + this.field_147009_r);
            this.enchantingPages = 0.0;
            this.sliderIndex = 0.0;
            this.sliding = false;
            this.clicked = false;
            return this.enchantments;
        }
        return enchantments;
    }
}

