/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.eplus.common.network.packet;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.darkhax.bookshelf.lib.util.PlayerUtils;
import net.darkhax.eplus.handler.PlayerHandler;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class PacketSyncUnlockedEnchantments
implements IMessage {
    private List<String> enchantments;

    public PacketSyncUnlockedEnchantments() {
    }

    public PacketSyncUnlockedEnchantments(List<Enchantment> enchantments) {
        this.enchantments = new ArrayList<String>();
        for (Enchantment ench : enchantments) {
            this.enchantments.add(ench.getRegistryName().toString());
        }
    }

    public void fromBytes(ByteBuf buf) {
        int count = buf.readInt();
        this.enchantments = new ArrayList<String>();
        for (int pos = 0; pos < count; ++pos) {
            this.enchantments.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.enchantments.size());
        for (String enchant : this.enchantments) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)enchant);
        }
    }

    public static class PacketHandler
    implements IMessageHandler<PacketSyncUnlockedEnchantments, IMessage> {
        public IMessage onMessage(PacketSyncUnlockedEnchantments packet, MessageContext ctx) {
            EntityPlayer player = PlayerUtils.getClientPlayer();
            List<Enchantment> enchants = PlayerHandler.getUnlockedEnchantments(player);
            for (String enchant : packet.enchantments) {
                Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(enchant));
                if (ench == null || enchants.contains(ench)) continue;
                enchants.add(ench);
            }
            return null;
        }
    }
}

