/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.eplus.handler;

import java.io.File;
import net.minecraftforge.common.config.Configuration;

public final class ConfigurationHandler {
    public static Configuration config;
    public static boolean printDebug;
    public static boolean useQuestMode;
    public static boolean allowRepairs;
    public static boolean allowDisenchanting;
    public static boolean allowModifierTooltips;
    public static boolean needsBookShelves;
    public static int maxEnchantmentAmount;
    public static float costFactor;
    public static int repairFactor;
    public static int bonusShelves;
    public static float scrollDrop;
    public static String[] blacklistedItems;
    public static String[] blacklistedEnchantments;
    public static boolean allowScrollLoot;

    public static void initConfig(File configFile) {
        config = new Configuration(configFile);
        String settings = "settings";
        printDebug = config.getBoolean("printDebug", "settings", printDebug, "If true, Enchanting Plus will ocasionally write messages to the console.");
        useQuestMode = config.getBoolean("useQuestMode", "settings", useQuestMode, "Quest Mode requires that users collect scrolls to unlock enchantments, before they can make use of them at the table.");
        allowRepairs = config.getBoolean("allowRepairs", "settings", allowRepairs, "If this is true, players will be able to repair damaged items at the advanced enchanting table, using experience points");
        allowDisenchanting = config.getBoolean("allowDisenchanting", "settings", allowDisenchanting, "If this is true, players will be able to disenchant enchanted items they come across.");
        allowModifierTooltips = config.getBoolean("allowModifierTooltips", "settings", allowModifierTooltips, "If true, special information will be written to the Scroll Modifier item tooltips.");
        bonusShelves = config.getInt("bonusShelves", "settings", bonusShelves, 0, 128, "An additional amount of bookshelves to factor in to the max level calculation. For each bonus shelf, 2 additional levels will be added to the max level cap of the table.");
        needsBookShelves = config.getBoolean("needBookshelves", "settings", needsBookShelves, "Should the table restrict the level of effects based on the amount of bookshelves?");
        maxEnchantmentAmount = config.getInt("maxEnchantmentAmount", "settings", maxEnchantmentAmount, 0, 4096, "What is the maximum number of enchantments that could be applied at the Enchantment Table?");
        costFactor = config.getFloat("costFactor", "settings", costFactor, 0.0f, 128.0f, "A number used when calculated enchantment cost. This number is treated as a % based factor. 0.30 = 30% of the original cost. 1.5 = 150% of the original cost.");
        repairFactor = config.getInt("repairFactor", "settings", repairFactor, 0, 128, "A number used when calculating the repair costs. A higher factor means higher repair costs.");
        scrollDrop = config.getFloat("scrollDropRate", "settings", scrollDrop, 0.0f, 1.0f, "The percent chance that a hostile mob should drop a scroll. Default is 0.01 which is 1%");
        blacklistedItems = config.getStringList("blacklistedItems", "settings", blacklistedItems, "A list of blacklisted items and blocks. Things in this list won't be enchantable at the eplus table. The format is the same as minecraft's id system. For example, minecraft:chainmail_helmet will prevent chainmail helmets from becoming enchanted.");
        blacklistedEnchantments = config.getStringList("blacklistedEnchantments", "settings", blacklistedEnchantments, "A list of blacklisted enchantment ids. Each entry should be an integer.");
        allowScrollLoot = config.getBoolean("allowScrollLoot", "settings", true, "If disabled, scrolls will only spawn in custom village chests.");
        if (config.hasChanged()) {
            config.save();
        }
    }

    static {
        printDebug = true;
        useQuestMode = true;
        allowRepairs = true;
        allowDisenchanting = true;
        allowModifierTooltips = true;
        needsBookShelves = true;
        maxEnchantmentAmount = 5;
        costFactor = 1.0f;
        repairFactor = 5;
        bonusShelves = 2;
        scrollDrop = 0.01f;
        blacklistedItems = new String[0];
        blacklistedEnchantments = new String[0];
        allowScrollLoot = true;
    }
}

