/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.eplus.handler;

import java.util.ArrayList;
import java.util.List;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.darkhax.eplus.block.BlockAdvancedTable;
import net.darkhax.eplus.block.BlockBookDecoration;
import net.darkhax.eplus.handler.ConfigurationHandler;
import net.darkhax.eplus.item.ItemBook;
import net.darkhax.eplus.item.ItemScroll;
import net.darkhax.eplus.item.ItemTableUpgrade;
import net.darkhax.eplus.modifiers.ScrollModifier;
import net.darkhax.eplus.tileentity.TileEntityAdvancedTable;
import net.darkhax.eplus.tileentity.TileEntityDecoration;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public final class ContentHandler {
    private static List<ResourceLocation> enchantBlacklist = new ArrayList<ResourceLocation>();
    private static List<ResourceLocation> itemBlacklist = new ArrayList<ResourceLocation>();
    public static List<ScrollModifier> modifiers = new ArrayList<ScrollModifier>();
    private static int achievementCount = 0;
    public static Block blockAdvancedTable;
    public static Block blockArcaneInscriber;
    public static Block blockDecoration;
    public static Item itemTableUpgrade;
    public static Item itemScroll;

    public static void addScrollModifier(ScrollModifier modifier) {
        modifiers.add(modifier);
    }

    public static void blacklistEnchantment(Enchantment enchant) {
        if (enchant != null && !enchantBlacklist.contains(enchant.getRegistryName())) {
            enchantBlacklist.add(enchant.getRegistryName());
        }
    }

    public static void blacklistItem(Item item) {
        if (item != null && !itemBlacklist.contains(item.getRegistryName())) {
            itemBlacklist.add(item.getRegistryName());
        }
    }

    public static ScrollModifier findScrollModifier(ItemStack stack) {
        for (ScrollModifier modifier : modifiers) {
            if (!ItemStackUtils.areStacksSimilar((ItemStack)modifier.stack, (ItemStack)stack)) continue;
            return modifier;
        }
        return null;
    }

    public static void initBlacklist() {
        for (String entry : ConfigurationHandler.blacklistedItems) {
            ContentHandler.blacklistItem((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(entry)));
        }
        for (String entry : ConfigurationHandler.blacklistedEnchantments) {
            ContentHandler.blacklistEnchantment((Enchantment)Enchantment.field_185264_b.func_82594_a((Object)new ResourceLocation(entry)));
        }
    }

    public static void initBlocks() {
        blockAdvancedTable = new BlockAdvancedTable();
        ContentHandler.registerBlock(blockAdvancedTable, "advanced_table");
        GameRegistry.registerTileEntity(TileEntityAdvancedTable.class, (String)"advanced_table");
        blockDecoration = new BlockBookDecoration();
        ContentHandler.registerBlock(blockDecoration, new ItemBook(), "decoration");
        GameRegistry.registerTileEntity(TileEntityDecoration.class, (String)"decoration");
    }

    public static void initItems() {
        itemTableUpgrade = new ItemTableUpgrade();
        ContentHandler.registerItem(itemTableUpgrade, "table_upgrade");
        itemScroll = new ItemScroll();
        ContentHandler.registerItem(itemScroll, "scroll");
    }

    public static void initModifiers() {
        ContentHandler.addScrollModifier(new ScrollModifier(new ItemStack(Items.field_151065_br), -0.05f, 0.1f, false));
        ContentHandler.addScrollModifier(new ScrollModifier(new ItemStack(Blocks.field_150343_Z), 0.1f, -0.05f, false));
        ContentHandler.addScrollModifier(new ScrollModifier(new ItemStack(Items.field_151045_i), 0.25f, -0.05f, false));
        ContentHandler.addScrollModifier(new ScrollModifier(new ItemStack(Items.field_151166_bC), -0.05f, 0.25f, false));
        ContentHandler.addScrollModifier(new ScrollModifier(new ItemStack(Items.field_151079_bi), 0.05f, 0.0f, false));
        ContentHandler.addScrollModifier(new ScrollModifier(new ItemStack(Blocks.field_150426_aN), 0.0f, 0.05f, false));
        ContentHandler.addScrollModifier(new ScrollModifier(new ItemStack(Items.field_151061_bv), 0.0f, 0.1f, false));
    }

    public static void initRecipes() {
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemTableUpgrade), (Object[])new Object[]{"gbg", "o o", "geg", Character.valueOf('b'), Items.field_151099_bA, Character.valueOf('o'), Blocks.field_150343_Z, Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('g'), Items.field_151043_k});
        GameRegistry.addRecipe((ItemStack)new ItemStack(blockAdvancedTable), (Object[])new Object[]{"gbg", "oto", "geg", Character.valueOf('b'), Items.field_151099_bA, Character.valueOf('o'), Blocks.field_150343_Z, Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('g'), Items.field_151043_k, Character.valueOf('t'), Blocks.field_150381_bn});
        GameRegistry.addRecipe((ItemStack)new ItemStack(blockDecoration), (Object[])new Object[]{" g ", "gbg", " g ", Character.valueOf('g'), Items.field_151114_aO, Character.valueOf('b'), Items.field_151134_bR});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(blockAdvancedTable), (Object[])new Object[]{Blocks.field_150381_bn, itemTableUpgrade});
    }

    public static boolean isEnchantmentBlacklisted(Enchantment enchant) {
        return enchant != null && enchantBlacklist.contains(enchant.getRegistryName());
    }

    public static boolean isItemBlacklisted(Item item) {
        return item != null && itemBlacklist.contains(item.getRegistryName());
    }

    public static Achievement registerAchievement(String key, Item item) {
        int posX = achievementCount % 8;
        int posY = achievementCount / 8;
        ++achievementCount;
        return new Achievement(key, key, posX, posY + 1, item, null).func_75971_g();
    }

    private static void registerBlock(Block block, ItemBlock item, String ID) {
        block.setRegistryName(ID);
        GameRegistry.register((IForgeRegistryEntry)block);
        GameRegistry.register((IForgeRegistryEntry)item, (ResourceLocation)block.getRegistryName());
    }

    private static void registerBlock(Block block, String ID) {
        block.setRegistryName(ID);
        GameRegistry.register((IForgeRegistryEntry)block);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock(block), (ResourceLocation)block.getRegistryName());
    }

    private static void registerItem(Item item, String ID) {
        if (item.getRegistryName() == null) {
            item.setRegistryName(ID);
        }
        GameRegistry.register((IForgeRegistryEntry)item);
    }
}

