/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.eplus.handler;

import java.util.ArrayList;
import java.util.List;
import net.darkhax.eplus.EnchantingPlus;
import net.darkhax.eplus.common.network.packet.PacketSyncUnlockedEnchantments;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class PlayerHandler {
    @CapabilityInject(value=ICustomData.class)
    public static final Capability<ICustomData> CUSTOM_DATA = null;

    public static void init() {
        CapabilityManager.INSTANCE.register(ICustomData.class, (Capability.IStorage)new Storage(), Default.class);
        MinecraftForge.EVENT_BUS.register((Object)new PlayerHandler());
    }

    public static List<Enchantment> getUnlockedEnchantments(EntityPlayer player) {
        if (player.hasCapability(CUSTOM_DATA, EnumFacing.DOWN)) {
            return ((ICustomData)player.getCapability(CUSTOM_DATA, EnumFacing.DOWN)).getUnlockedEnchantments();
        }
        return null;
    }

    public static boolean knowsEnchantment(EntityPlayer player, Enchantment enchantment) {
        List<Enchantment> enchants = PlayerHandler.getUnlockedEnchantments(player);
        return enchants != null && enchants.contains(enchants);
    }

    public static void unlockEnchantment(EntityPlayer player, Enchantment enchant) {
        if (player.hasCapability(CUSTOM_DATA, EnumFacing.DOWN)) {
            ((ICustomData)player.getCapability(CUSTOM_DATA, EnumFacing.DOWN)).unlockEnchantment(enchant);
            PlayerHandler.syncEnchantmentData(player);
        }
    }

    public static void syncEnchantmentData(EntityPlayer player) {
        if (!player.func_130014_f_().field_72995_K) {
            EnchantingPlus.network.sendTo((IMessage)new PacketSyncUnlockedEnchantments(PlayerHandler.getUnlockedEnchantments(player)), (EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("eplus", "playerData"), (ICapabilityProvider)new Provider());
        }
    }

    public static class Provider
    implements ICapabilitySerializable<NBTTagCompound> {
        ICustomData instance = (ICustomData)CUSTOM_DATA.getDefaultInstance();

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CUSTOM_DATA;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(this.hasCapability(capability, facing) ? CUSTOM_DATA.cast((Object)this.instance) : null);
        }

        public NBTTagCompound serializeNBT() {
            return (NBTTagCompound)CUSTOM_DATA.getStorage().writeNBT(CUSTOM_DATA, (Object)this.instance, null);
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            CUSTOM_DATA.getStorage().readNBT(CUSTOM_DATA, (Object)this.instance, null, (NBTBase)nbt);
        }
    }

    public static class Storage
    implements Capability.IStorage<ICustomData> {
        public NBTBase writeNBT(Capability<ICustomData> capability, ICustomData instance, EnumFacing side) {
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagList list = new NBTTagList();
            for (Enchantment enchant : instance.getUnlockedEnchantments()) {
                list.func_74742_a((NBTBase)new NBTTagString(enchant.getRegistryName().toString()));
            }
            tag.func_74782_a("unlocked", (NBTBase)list);
            return tag;
        }

        public void readNBT(Capability<ICustomData> capability, ICustomData instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound tag = (NBTTagCompound)nbt;
            NBTTagList list = tag.func_150295_c("unlocked", 8);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                String id = list.func_150307_f(i);
                Enchantment enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(id));
                if (enchant != null) {
                    instance.unlockEnchantment(enchant);
                    continue;
                }
                EnchantingPlus.printDebugMessage("The enchantment " + id + " does not exist. It will not be loaded.");
            }
        }
    }

    public static class Default
    implements ICustomData {
        private final List<Enchantment> unlockedEnchants = new ArrayList<Enchantment>();

        @Override
        public List<Enchantment> getUnlockedEnchantments() {
            return this.unlockedEnchants;
        }

        @Override
        public boolean hasEnchantment(Enchantment enchant) {
            return this.unlockedEnchants.contains(enchant);
        }

        @Override
        public void unlockEnchantment(Enchantment enchant) {
            if (!this.hasEnchantment(enchant)) {
                this.unlockedEnchants.add(enchant);
            }
        }

        @Override
        public void lockEnchantment(Enchantment enchant) {
            this.unlockedEnchants.remove(enchant);
        }
    }

    public static interface ICustomData {
        public List<Enchantment> getUnlockedEnchantments();

        public boolean hasEnchantment(Enchantment var1);

        public void unlockEnchantment(Enchantment var1);

        public void lockEnchantment(Enchantment var1);
    }
}

