/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.eplus.inventory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.darkhax.bookshelf.inventory.SlotArmor;
import net.darkhax.bookshelf.lib.util.EnchantmentUtils;
import net.darkhax.bookshelf.lib.util.EntityUtils;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.darkhax.eplus.handler.ConfigurationHandler;
import net.darkhax.eplus.handler.ContentHandler;
import net.darkhax.eplus.handler.PlayerHandler;
import net.darkhax.eplus.inventory.SlotEnchant;
import net.darkhax.eplus.inventory.SlotEnchantTable;
import net.darkhax.eplus.libs.Constants;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class ContainerAdvancedTable
extends Container {
    private final World world;
    private final BlockPos pos;
    private final EntityPlayer player;
    public final IInventory tableInventory = new SlotEnchantTable(this, "Enchant", true, 1);
    private Map<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();

    public ContainerAdvancedTable(InventoryPlayer inventory, World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
        this.player = inventory.field_70458_d;
        int guiOffest = 26;
        this.func_75146_a(new SlotEnchant(this, this.tableInventory, 0, 37, 17));
        for (int invRow = 0; invRow < 3; ++invRow) {
            for (int slotCount = 0; slotCount < 9; ++slotCount) {
                this.func_75146_a(new Slot((IInventory)inventory, slotCount + invRow * 9 + 9, 17 + slotCount * 18 + 26, 91 + invRow * 18));
            }
        }
        for (int slotCount = 0; slotCount < 9; ++slotCount) {
            this.func_75146_a(new Slot((IInventory)inventory, slotCount, 17 + slotCount * 18 + 26, 149));
        }
        for (int slotIndex = 0; slotIndex < 4; ++slotIndex) {
            this.func_75146_a((Slot)new SlotArmor((Entity)inventory.field_70458_d, EntityUtils.getEquipmentSlot((int)slotIndex), (IInventory)inventory, 39 - slotIndex, 7, 24 + slotIndex * 19));
        }
    }

    public boolean func_75145_c(EntityPlayer entityPlayer) {
        return entityPlayer.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5) <= 64.0 && !entityPlayer.field_70128_L;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        for (int i = 0; i < this.tableInventory.func_70302_i_(); ++i) {
            ItemStack stack = this.tableInventory.func_70301_a(i);
            if (!ItemStackUtils.isValidStack((ItemStack)stack) || player.field_71071_by.func_70441_a(stack) || player.field_70170_p.field_72995_K) continue;
            player.func_70099_a(stack, 0.2f);
        }
    }

    public void func_75130_a(IInventory par1IInventory) {
        super.func_75130_a(par1IInventory);
        IBlockState state = this.world.func_180495_p(this.pos);
        this.world.func_184138_a(this.pos, state, state, 8);
        this.readItemStack();
    }

    private void readItemStack() {
        ItemStack itemStack = this.tableInventory.func_70301_a(0);
        LinkedHashMap<Enchantment, Integer> temp = new LinkedHashMap<Enchantment, Integer>();
        LinkedHashMap<Enchantment, Integer> temp2 = new LinkedHashMap<Enchantment, Integer>();
        if (!ItemStackUtils.isValidStack((ItemStack)itemStack) || ContentHandler.isItemBlacklisted(itemStack.func_77973_b())) {
            this.enchantments = temp;
            return;
        }
        if (EnchantmentUtils.isItemEnchantable((ItemStack)itemStack)) {
            this.addAllEnchatments(itemStack, temp);
        } else if (itemStack.func_77948_v()) {
            temp.putAll(EnchantmentHelper.func_82781_a((ItemStack)itemStack));
            for (Enchantment potentialEnchant : Enchantment.field_185264_b) {
                if (potentialEnchant == null) continue;
                for (Enchantment existingEnchant : ((HashMap)temp).keySet()) {
                    if (existingEnchant == null || !EnchantmentUtils.areEnchantmentsCompatible((Enchantment)existingEnchant, (Enchantment)potentialEnchant)) continue;
                    this.addEnchantment(itemStack, temp2, potentialEnchant);
                }
            }
            temp.putAll(temp2);
        }
        if (this.enchantments != temp) {
            this.enchantments = temp;
        }
    }

    public void repair(EntityPlayer player, int cost) {
        ItemStack itemStack = this.tableInventory.func_70301_a(0);
        if (itemStack == null) {
            return;
        }
        if (!itemStack.func_77948_v() || cost == 0) {
            return;
        }
        if (this.canPurchase(player, cost)) {
            itemStack.func_77964_b(0);
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_82242_a(-cost);
            }
        }
        this.func_75130_a(this.tableInventory);
    }

    public ItemStack func_82846_b(EntityPlayer entityPlayer, int slotIndex) {
        ItemStack itemStack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            Slot firstSlot;
            ItemStack slotStack = slot.func_75211_c();
            ItemStack tempStack = slotStack.func_77946_l();
            itemStack = slotStack.func_77946_l();
            tempStack.field_77994_a = 1;
            if (slotIndex != 0 && !(firstSlot = (Slot)this.field_75151_b.get(0)).func_75216_d() && firstSlot.func_75214_a(tempStack) && this.func_75135_a(tempStack, 0, 1, false)) {
                --slotStack.field_77994_a;
                itemStack = slotStack.func_77946_l();
            }
            if (slotStack.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (itemStack.field_77994_a == slotStack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(entityPlayer, slotStack);
        }
        return itemStack;
    }

    public void updateItemStack(EntityPlayer player, HashMap<Enchantment, Integer> map, int clientCost) {
        Integer level;
        ItemStack itemstack = this.tableInventory.func_70301_a(0);
        ArrayList<Enchantment> toRemove = new ArrayList<Enchantment>();
        int serverCost = this.getEnchantmentCost(map);
        if (itemstack == null) {
            return;
        }
        if (clientCost != serverCost) {
            Constants.LOG.warn(player.getDisplayNameString() + " tried to enchant " + itemstack.func_82833_r() + " but the costs were not in sync!");
            return;
        }
        for (Enchantment enchantment : this.enchantments.keySet()) {
            level = this.enchantments.get(enchantment);
            if (level == 0 || map.containsKey(enchantment)) continue;
            map.put(enchantment, level);
        }
        for (Enchantment enchantment : map.keySet()) {
            level = map.get(enchantment);
            if (level != 0) continue;
            toRemove.add(enchantment);
        }
        for (Enchantment enchantment : toRemove) {
            map.remove(enchantment);
        }
        if (this.canPurchase(player, serverCost)) {
            ArrayList<EnchantmentData> enchantmentDataList = new ArrayList<EnchantmentData>();
            for (Enchantment enchantment : map.keySet()) {
                enchantmentDataList.add(new EnchantmentData(enchantment, map.get(enchantment).intValue()));
            }
            if (!player.field_71075_bZ.field_75098_d) {
                if (serverCost < 0) {
                    player.func_71023_q(-serverCost);
                } else {
                    player.func_82242_a(-EnchantmentUtils.getLevelsFromExperience((int)serverCost));
                }
            }
            this.tableInventory.func_70299_a(0, this.applyChanges(enchantmentDataList, itemstack, player, clientCost));
        }
        this.func_75130_a(this.tableInventory);
    }

    private int getEnchantmentCost(Map<Enchantment, Integer> map) {
        int cost = 0;
        for (Enchantment enchantment : map.keySet()) {
            Integer level = map.get(enchantment);
            Integer startingLevel = this.enchantments.get(enchantment);
            if (level > startingLevel) {
                cost += this.enchantmentCost(enchantment, level, startingLevel);
                continue;
            }
            if (level >= startingLevel) continue;
            cost += this.getRebate(enchantment, level, startingLevel);
        }
        return cost;
    }

    public static int calculateEnchantmentCost(Enchantment enchant, int level, ItemStack stack) {
        int existingLevel = EnchantmentHelper.func_77506_a((Enchantment)enchant, (ItemStack)stack);
        int enchantability = enchant.func_77321_a(level);
        if (existingLevel > 0 && existingLevel != level) {
            enchantability -= enchant.func_77321_a(existingLevel);
        }
        return (int)((float)enchantability + (float)Math.min(0, 15 - stack.func_77973_b().getItemEnchantability(stack)) * ConfigurationHandler.costFactor);
    }

    private boolean isEnchantmentValid(Enchantment enchantment, EntityPlayer player) {
        return enchantment != null && (!ConfigurationHandler.useQuestMode || PlayerHandler.knowsEnchantment(player, enchantment) || player.field_71075_bZ.field_75098_d);
    }

    private ItemStack applyChanges(List<EnchantmentData> enchantmentData, ItemStack itemStack, EntityPlayer player, int cost) {
        NBTTagList nbttaglist = new NBTTagList();
        for (EnchantmentData data : enchantmentData) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74777_a("id", (short)Enchantment.func_185258_b((Enchantment)data.field_76302_b));
            nbttagcompound.func_74768_a("lvl", data.field_76303_c);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        if (itemStack.func_77973_b() == Items.field_151122_aG) {
            itemStack.func_150996_a((Item)Items.field_151134_bR);
        }
        if (itemStack.func_77973_b() == Items.field_151134_bR) {
            if (nbttaglist.func_74745_c() > 0) {
                itemStack.func_77983_a("StoredEnchantments", (NBTBase)nbttaglist);
            } else if (itemStack.func_77942_o()) {
                itemStack.func_77978_p().func_82580_o("StoredEnchantments");
                itemStack.func_77982_d(new NBTTagCompound());
                itemStack = new ItemStack(Items.field_151122_aG);
            }
        } else if (nbttaglist.func_74745_c() > 0) {
            itemStack.func_77983_a("ench", (NBTBase)nbttaglist);
        } else if (itemStack.func_77942_o()) {
            itemStack.func_77978_p().func_82580_o("ench");
        }
        return itemStack;
    }

    public boolean canPurchase(EntityPlayer player, int cost) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        int levelCost = EnchantmentUtils.getLevelsFromExperience((int)cost);
        if (ConfigurationHandler.needsBookShelves && (float)levelCost > this.getEnchantingPower()) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.eplus.morebooks " + levelCost, new Object[0]));
            return false;
        }
        if (player.field_71068_ca < levelCost) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.eplus.morelevels " + levelCost, new Object[0]));
            return false;
        }
        return true;
    }

    public int enchantmentCost(Enchantment enchantment, int enchantmentLevel, Integer level) {
        ItemStack itemStack = this.tableInventory.func_70301_a(0);
        if (itemStack == null || enchantmentLevel > enchantment.func_77325_b()) {
            return 0;
        }
        return EnchantmentUtils.getExperienceFromLevel((int)ContainerAdvancedTable.calculateEnchantmentCost(enchantment, enchantmentLevel + level, itemStack));
    }

    public Map<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    public int getRebate(Enchantment enchantment, int enchantmentLevel, Integer existingLevel) {
        int newCost;
        ItemStack stack = this.tableInventory.func_70301_a(0);
        if (!ItemStackUtils.isValidStack((ItemStack)stack) && enchantmentLevel > enchantment.func_77325_b()) {
            return 0;
        }
        int oldCost = (int)((float)((enchantment.func_77317_b(existingLevel.intValue()) - stack.func_77973_b().getItemEnchantability(stack)) / 2) * ConfigurationHandler.costFactor);
        int returnAmount = (oldCost - (newCost = (int)((float)((enchantment.func_77317_b(enchantmentLevel) - stack.func_77973_b().getItemEnchantability(stack)) / 2) * ConfigurationHandler.costFactor))) / 2;
        return -EnchantmentUtils.getExperienceFromLevel((int)(returnAmount > 0 ? returnAmount : 0));
    }

    public int getRepairCost() {
        ItemStack stack = this.tableInventory.func_70301_a(0);
        int cost = 0;
        if (!(ItemStackUtils.isValidStack((ItemStack)stack) && stack.func_77948_v() && stack.func_77951_h())) {
            return cost;
        }
        Map map = EnchantmentHelper.func_82781_a((ItemStack)stack);
        for (Enchantment enchantment : map.keySet()) {
            Integer level = (Integer)map.get(enchantment);
            cost += this.enchantmentCost(enchantment, level, 0);
        }
        float repairPercent = (float)stack.func_77952_i() / (float)stack.func_77958_k();
        return Math.max(1, (int)((float)Math.abs(cost) * repairPercent));
    }

    private void addAllEnchatments(ItemStack itemStack, HashMap<Enchantment, Integer> validEnchantments) {
        for (Enchantment enchantment : Enchantment.field_185264_b) {
            this.addEnchantment(itemStack, validEnchantments, enchantment);
        }
    }

    private void addEnchantment(ItemStack itemStack, HashMap<Enchantment, Integer> validEnchantments, Enchantment enchantment) {
        if (this.isEnchantmentValid(enchantment, this.player) && !ContentHandler.isEnchantmentBlacklisted(enchantment) && (itemStack.func_77973_b() == Items.field_151122_aG || itemStack.func_77973_b() == Items.field_151134_bR || enchantment.canApplyAtEnchantingTable(itemStack))) {
            validEnchantments.put(enchantment, 0);
        }
    }

    public float getEnchantingPower() {
        int x = this.pos.func_177958_n();
        int y = this.pos.func_177956_o();
        int z = this.pos.func_177952_p();
        float cost = ConfigurationHandler.bonusShelves;
        for (int zOffset = -1; zOffset <= 1; ++zOffset) {
            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                if (zOffset == 0 && xOffset == 0 || !this.world.func_175623_d(new BlockPos(x + xOffset, y, z + zOffset)) || !this.world.func_175623_d(new BlockPos(x + xOffset, y + 1, z + zOffset))) continue;
                cost += ForgeHooks.getEnchantPower((World)this.world, (BlockPos)new BlockPos(x + xOffset * 2, y, z + zOffset * 2));
                cost += ForgeHooks.getEnchantPower((World)this.world, (BlockPos)new BlockPos(x + xOffset * 2, y + 1, z + zOffset * 2));
                if (xOffset == 0 || zOffset == 0) continue;
                cost += ForgeHooks.getEnchantPower((World)this.world, (BlockPos)new BlockPos(x + xOffset * 2, y, z + zOffset));
                cost += ForgeHooks.getEnchantPower((World)this.world, (BlockPos)new BlockPos(x + xOffset * 2, y + 1, z + zOffset));
                cost += ForgeHooks.getEnchantPower((World)this.world, (BlockPos)new BlockPos(x + xOffset, y, z + zOffset * 2));
                cost += ForgeHooks.getEnchantPower((World)this.world, (BlockPos)new BlockPos(x + xOffset, y + 1, z + zOffset * 2));
            }
        }
        return cost * 2.0f;
    }
}

