/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.eplus.item;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.darkhax.bookshelf.lib.util.RenderUtils;
import net.darkhax.eplus.EnchantingPlus;
import net.darkhax.eplus.handler.ContentHandler;
import net.darkhax.eplus.handler.PlayerHandler;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemScroll
extends Item {
    public ItemScroll() {
        this.func_77655_b("eplus.scroll");
        this.func_77625_d(16);
        this.func_77637_a(EnchantingPlus.tabEplus);
    }

    public static ItemStack createScroll(Enchantment enchantment) {
        ItemStack stack = new ItemStack(ContentHandler.itemScroll);
        ItemStackUtils.prepareDataTag((ItemStack)stack);
        stack.func_77978_p().func_74778_a("ScrollEnchantment", enchantment.getRegistryName().toString());
        return stack;
    }

    public static Enchantment readScroll(ItemStack stack) {
        return (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(stack.func_77978_p().func_74779_i("ScrollEnchantment")));
    }

    public static boolean isValidScroll(ItemStack stack) {
        ItemStackUtils.prepareDataTag((ItemStack)stack);
        return ItemStackUtils.isValidStack((ItemStack)stack) && stack.func_77973_b() instanceof ItemScroll && stack.func_77978_p().func_74764_b("ScrollEnchantment") && ForgeRegistries.ENCHANTMENTS.containsKey(new ResourceLocation(stack.func_77978_p().func_74779_i("ScrollEnchantment")));
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        playerIn.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (!worldIn.field_72995_K && entityLiving instanceof EntityPlayer && ItemScroll.isValidScroll(stack)) {
            --stack.field_77994_a;
            PlayerHandler.unlockEnchantment((EntityPlayer)entityLiving, ItemScroll.readScroll(stack));
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        if (count % 4 == 0) {
            float percent = 1.0f - (float)count / (float)this.func_77626_a(stack);
            RenderUtils.spawnPercentageParticleRing((World)player.field_70170_p, (EnumParticleTypes)EnumParticleTypes.ENCHANTMENT_TABLE, (float)percent, (double)player.field_70165_t, (double)(player.field_70163_u + (double)player.field_70131_O), (double)player.field_70161_v, (double)0.0, (double)0.0, (double)0.0, (double)0.15);
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 60;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> itemList) {
        for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS.getValues()) {
            if (ContentHandler.isEnchantmentBlacklisted(enchantment)) continue;
            itemList.add(ItemScroll.createScroll(enchantment));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer reader, List tip, boolean isDebug) {
        if (ItemScroll.isValidScroll(stack)) {
            Enchantment enchant = ItemScroll.readScroll(stack);
            tip.add(ChatFormatting.AQUA + I18n.func_74838_a((String)"tooltip.eplus.enchantment") + ": " + ChatFormatting.RESET + I18n.func_74838_a((String)enchant.func_77320_a()));
            if (PlayerHandler.knowsEnchantment(reader, enchant)) {
                tip.add(ChatFormatting.RED + I18n.func_74838_a((String)"tooltip.eplus.learned"));
            }
        } else {
            tip.add(I18n.func_74838_a((String)"tooltip.eplus.invalid"));
        }
    }
}

