/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.asm;

import net.darkhax.bookshelf.asm.ASMUtils;
import net.darkhax.bookshelf.asm.mapping.Mapping;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class BookshelfTransformerManager
implements IClassTransformer {
    public static final Mapping METHOD_RENDER_ITEM = new Mapping("func_180454_a", "renderItem", "net/minecraft/client/renderer/RenderItem", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/renderer/block/model/IBakedModel;)V");
    public static final Mapping METHOD_BOOKSHELF_RENDER_ITEM = new Mapping("renderItem", "net/darkhax/bookshelf/handler/BookshelfHooks", "(Lnet/minecraft/client/renderer/RenderItem;Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/renderer/block/model/IBakedModel;)Z");

    public byte[] transform(String name, String transformedName, byte[] classBytes) {
        if (transformedName.equals("net.minecraft.client.renderer.RenderItem")) {
            ClassNode clazz = ASMUtils.createClassFromByteArray(classBytes);
            MethodNode node = METHOD_RENDER_ITEM.getMethodNode(clazz);
            this.insertRenderHook(node);
            return ASMUtils.createByteArrayFromClass(clazz, 3);
        }
        return classBytes;
    }

    private void insertRenderHook(MethodNode method) {
        InsnList i = new InsnList();
        LabelNode start = new LabelNode();
        i.add((AbstractInsnNode)start);
        i.add((AbstractInsnNode)new VarInsnNode(25, 0));
        i.add((AbstractInsnNode)new VarInsnNode(25, 1));
        i.add((AbstractInsnNode)new VarInsnNode(25, 2));
        i.add((AbstractInsnNode)METHOD_BOOKSHELF_RENDER_ITEM.getMethodInsn(184, false));
        LabelNode check = new LabelNode();
        i.add((AbstractInsnNode)check);
        LabelNode vanilla = new LabelNode();
        LabelNode exit = new LabelNode();
        i.add((AbstractInsnNode)new JumpInsnNode(153, vanilla));
        i.add((AbstractInsnNode)exit);
        i.add((AbstractInsnNode)new InsnNode(177));
        i.add((AbstractInsnNode)vanilla);
        i.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        method.instructions.insertBefore(method.instructions.getFirst(), i);
    }
}

