/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.client.event;

import java.awt.Color;
import net.darkhax.bookshelf.lib.util.RenderUtils;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderItemEvent
extends Event {
    private final RenderItem renderer;
    private final ItemStack stack;
    private final IBakedModel model;

    public RenderItemEvent(RenderItem renderer, ItemStack stack, IBakedModel model) {
        this.renderer = renderer;
        this.stack = stack;
        this.model = model;
    }

    public RenderItem getRenderer() {
        return this.renderer;
    }

    public ItemStack getItemStack() {
        return this.stack;
    }

    public IBakedModel getModel() {
        return this.model;
    }

    @Cancelable
    public static class Glint
    extends RenderItemEvent {
        private Color color = new Color(-8372020);
        private boolean requiresReset = true;
        public ResourceLocation texture = RenderUtils.RES_ITEM_GLINT;

        public Glint(RenderItem renderer, ItemStack stack, IBakedModel model) {
            super(renderer, stack, model);
        }

        public void addColor(float red, float green, float blue) {
            if (this.requiresReset) {
                this.requiresReset = false;
                this.color = new Color(0, 0, 0);
            }
            this.color = new Color((float)this.getColor().getRed() + red, (float)this.getColor().getGreen() + green, (float)this.getColor().getBlue() + blue);
        }

        public Color getColor() {
            return this.color;
        }
    }

    public static class Post
    extends RenderItemEvent {
        public Post(RenderItem renderer, ItemStack stack, IBakedModel model) {
            super(renderer, stack, model);
        }
    }

    public static class Pre
    extends RenderItemEvent {
        public Pre(RenderItem renderer, ItemStack stack, IBakedModel model) {
            super(renderer, stack, model);
        }
    }

    @Cancelable
    public static class Allow
    extends RenderItemEvent {
        public Allow(RenderItem renderer, ItemStack stack, IBakedModel model) {
            super(renderer, stack, model);
        }
    }
}

