/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.handler;

import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.darkhax.bookshelf.lib.Constants;
import net.darkhax.bookshelf.lib.util.RenderUtils;
import net.darkhax.bookshelf.lib.util.TextUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;

public class SupporterHandler {
    private static final ResourceLocation MISSING_CAPE = new ResourceLocation("bookshelf", "textures/entity/player/missing_cape.png");
    private static final ResourceLocation MISSING_ELYTRA = new ResourceLocation("bookshelf", "textures/entity/player/missing_elytra.png");
    private static final List<SupporterData> DATA = new ArrayList<SupporterData>();
    private static final String SUPPORTER_URL = "https://raw.githubusercontent.com/Darkhax-Minecraft/Bookshelf/master/supporters.json";

    public static void readSupporterData() {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(SUPPORTER_URL).openConnection();
            JsonReader reader = new JsonReader((Reader)new InputStreamReader((InputStream)connection.getContent()));
            reader.beginObject();
            while (reader.hasNext()) {
                reader.nextName();
                UUID playerID = null;
                String type = null;
                boolean confirmed = false;
                boolean wantsHead = true;
                boolean wantsWawla = false;
                String elytraTexture = null;
                String capeTexture = null;
                reader.beginObject();
                while (reader.hasNext()) {
                    String name = reader.nextName();
                    if (name.equals("playerID")) {
                        playerID = UUID.fromString(reader.nextString());
                        continue;
                    }
                    if (name.equals("type")) {
                        type = reader.nextString();
                        continue;
                    }
                    if (name.equals("confirmed")) {
                        confirmed = reader.nextBoolean();
                        continue;
                    }
                    if (name.equals("wantHead")) {
                        wantsHead = reader.nextBoolean();
                        continue;
                    }
                    if (name.equals("wantWawla")) {
                        wantsWawla = reader.nextBoolean();
                        continue;
                    }
                    if (name.equals("elytraTexture")) {
                        elytraTexture = reader.nextString();
                        continue;
                    }
                    if (name.equals("capeTexture")) {
                        capeTexture = reader.nextString();
                        continue;
                    }
                    reader.skipValue();
                }
                DATA.add(new SupporterData(playerID, type, confirmed, wantsHead, wantsWawla, elytraTexture, capeTexture));
                reader.endObject();
            }
            reader.endObject();
            reader.close();
        }
        catch (MalformedURLException e) {
            Constants.LOG.error("Could not access supporter data. " + e.getMessage());
        }
        catch (IOException e) {
            Constants.LOG.error("Could not access supporter data. " + e.getMessage());
        }
    }

    public static boolean isSupporter(EntityPlayer player) {
        for (SupporterData supporter : DATA) {
            if (!supporter.getPlayerID().equals(player.func_110124_au())) continue;
            return true;
        }
        return false;
    }

    public static SupporterData getSupporterData(EntityPlayer player) {
        for (SupporterData supporter : DATA) {
            if (!supporter.getPlayerID().equals(player.func_110124_au())) continue;
            return supporter;
        }
        return null;
    }

    public static SupporterData[] getSupporters() {
        return DATA.toArray(new SupporterData[DATA.size()]);
    }

    public static class SupporterData {
        private final UUID PLAYER_ID;
        private final String TYPE;
        private final boolean CONFIRMED;
        private final boolean WANTS_HEAD;
        private final boolean WANTS_WAWLA;
        private final String ELYTRA_TEXTURE;
        private final String CAPE_TEXTURE;

        protected SupporterData(UUID playerID, String type, boolean confirmed, boolean wantsHead, boolean wantsWawla, String elytraTexture, String capeTexture) {
            this.PLAYER_ID = playerID;
            this.TYPE = type;
            this.CONFIRMED = confirmed;
            this.WANTS_HEAD = wantsHead;
            this.WANTS_WAWLA = wantsWawla;
            this.ELYTRA_TEXTURE = elytraTexture;
            this.CAPE_TEXTURE = capeTexture;
        }

        public UUID getPlayerID() {
            return this.PLAYER_ID;
        }

        public boolean isConfirmed() {
            return this.CONFIRMED;
        }

        public boolean wantsHead() {
            return this.WANTS_HEAD;
        }

        public boolean wantsWawla() {
            return this.WANTS_WAWLA;
        }

        public String getCapeTextureURL() {
            return this.CAPE_TEXTURE;
        }

        public String getElytraTextureURL() {
            return this.ELYTRA_TEXTURE;
        }

        public ResourceLocation getCapeTexture() {
            return this.CAPE_TEXTURE != null && !this.CAPE_TEXTURE.isEmpty() ? RenderUtils.downloadResourceLocation(this.CAPE_TEXTURE, new ResourceLocation("bookshelf", "cape/" + this.PLAYER_ID.toString()), MISSING_CAPE, null) : null;
        }

        public ResourceLocation getElytraTexture() {
            return this.ELYTRA_TEXTURE != null && !this.ELYTRA_TEXTURE.isEmpty() ? RenderUtils.downloadResourceLocation(this.ELYTRA_TEXTURE, new ResourceLocation("bookshelf", "elytra/" + this.getPlayerID().toString()), MISSING_ELYTRA, null) : null;
        }

        public String getType() {
            return this.TYPE;
        }

        public String getLocalizedType() {
            return I18n.func_74838_a((String)("supporters." + this.TYPE));
        }

        public TextUtils.ChatFormat getFormat() {
            return this.TYPE.equals("developer") ? TextUtils.ChatFormat.GREEN : (this.TYPE.equals("patreon") ? TextUtils.ChatFormat.GOLD : (this.TYPE.equals("contributor") ? TextUtils.ChatFormat.AQUA : (this.TYPE.equalsIgnoreCase("translator") ? TextUtils.ChatFormat.RED : TextUtils.ChatFormat.RESET)));
        }
    }
}

