/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.inventory;

import java.util.ArrayList;
import java.util.List;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class InventoryItem
extends Item
implements IInventory {
    private final ItemStack invItem;
    private final int size;
    private final ItemStack[] inventory;
    private final String name;

    public InventoryItem(ItemStack invItem, int size, String name) {
        this.invItem = invItem;
        this.size = size;
        this.inventory = new ItemStack[this.size];
        this.name = name;
        ItemStackUtils.prepareDataTag(invItem);
        this.readFromNBT();
    }

    public void readFromNBT() {
        NBTTagList items = this.invItem.func_77978_p().func_150295_c("ItemInventory", 10);
        for (int index = 0; index < items.func_74745_c(); ++index) {
            NBTTagCompound itemData = items.func_150305_b(index);
            int slot = itemData.func_74762_e("Slot");
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)itemData);
        }
    }

    public void writeToNBT() {
        NBTTagList items = new NBTTagList();
        for (int index = 0; index < this.func_70302_i_(); ++index) {
            ItemStack stack = this.func_70301_a(index);
            if (!ItemStackUtils.isValidStack(stack)) continue;
            NBTTagCompound itemData = new NBTTagCompound();
            itemData.func_74768_a("Slot", index);
            stack.func_77955_b(itemData);
            items.func_74742_a((NBTBase)itemData);
        }
        this.invItem.func_77978_p().func_74782_a("ItemInventory", (NBTBase)items);
    }

    public static List<ItemStack> getContents(ItemStack stack) {
        ItemStackUtils.prepareDataTag(stack);
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        NBTTagList items = stack.func_77978_p().func_150295_c("ItemInventory", 10);
        for (int index = 0; index < items.func_74745_c(); ++index) {
            list.add(ItemStack.func_77949_a((NBTTagCompound)items.func_150305_b(index)));
        }
        return list;
    }

    public String func_70005_c_() {
        return this.name;
    }

    public boolean func_145818_k_() {
        return this.name.length() > 0;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.name, new Object[0]);
    }

    public int func_70302_i_() {
        return this.size;
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = this.func_70301_a(index);
        if (ItemStackUtils.isValidStack(stack)) {
            if (stack.field_77994_a > count) {
                stack = stack.func_77979_a(count);
                this.func_70296_d();
            } else {
                this.func_70299_a(index, null);
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        this.func_70299_a(index, null);
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        for (int index = 0; index < this.func_70302_i_(); ++index) {
            if (!ItemStackUtils.isValidStack(this.func_70301_a(index)) || this.func_70301_a((int)index).field_77994_a != 0) continue;
            this.inventory[index] = null;
        }
        this.writeToNBT();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() != this.invItem.func_77973_b();
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }
}

