/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public final class CraftingUtils {
    public static List<ShapedRecipes> getShapedRecipes(ItemStack stack) {
        return CraftingUtils.getRecipesForStack(stack, recipe -> recipe instanceof ShapedRecipes);
    }

    public static List<ShapedOreRecipe> getShapedOreRecipe(ItemStack stack) {
        return CraftingUtils.getRecipesForStack(stack, recipe -> recipe instanceof ShapedOreRecipe);
    }

    public static List<ShapelessRecipes> getShapelessRecipes(ItemStack stack) {
        return CraftingUtils.getRecipesForStack(stack, recipe -> recipe instanceof ShapelessRecipes);
    }

    public static List<ShapelessOreRecipe> getShapelessOreRecipe(ItemStack stack) {
        return CraftingUtils.getRecipesForStack(stack, recipe -> recipe instanceof ShapelessOreRecipe);
    }

    public static List<IRecipe> getAnyRecipe(ItemStack stack) {
        return CraftingUtils.getRecipesForStack(stack, recipe -> true);
    }

    public static <T extends IRecipe> List<T> getRecipesForStack(ItemStack stack, Predicate<IRecipe> condition) {
        ArrayList<IRecipe> foundRecipes = new ArrayList<IRecipe>();
        for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
            ItemStack result;
            if (!condition.test(recipe) || !ItemStackUtils.areStacksEqual(result = recipe.func_77571_b(), stack, result.func_77942_o())) continue;
            foundRecipes.add(recipe);
        }
        return foundRecipes;
    }

    public static void createConversionRecipes(ItemStack input, ItemStack output) {
        for (int amount = 1; amount < 10; ++amount) {
            Object[] inputs = new ItemStack[amount];
            Arrays.fill(inputs, input);
            GameRegistry.addShapelessRecipe((ItemStack)ItemStackUtils.copyStackWithSize(output, amount), (Object[])inputs);
        }
    }
}

