/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib.util;

import java.util.Comparator;
import net.darkhax.bookshelf.lib.Constants;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public final class NBTUtils {
    public static final Comparator<NBTTagCompound> NBT_COMPARATOR = (firstTag, secondTag) -> firstTag != null ? (firstTag.equals(secondTag) ? 0 : 1) : (secondTag != null ? -1 : 0);

    public static void setGenericNBTValue(NBTTagCompound dataTag, String tagName, Object value) {
        if (value instanceof String) {
            dataTag.func_74778_a(tagName, (String)value);
        } else if (value instanceof Integer) {
            dataTag.func_74768_a(tagName, ((Integer)value).intValue());
        } else if (value instanceof Float) {
            dataTag.func_74776_a(tagName, ((Float)value).floatValue());
        } else if (value instanceof Boolean) {
            dataTag.func_74757_a(tagName, ((Boolean)value).booleanValue());
        } else if (value instanceof Double) {
            dataTag.func_74780_a(tagName, ((Double)value).doubleValue());
        } else if (value instanceof Long) {
            dataTag.func_74772_a(tagName, ((Long)value).longValue());
        } else if (value instanceof Short) {
            dataTag.func_74777_a(tagName, ((Short)value).shortValue());
        } else if (value instanceof Byte) {
            dataTag.func_74774_a(tagName, ((Byte)value).byteValue());
        } else if (value instanceof ItemStack) {
            dataTag.func_74782_a(tagName, (NBTBase)((ItemStack)value).func_77955_b(new NBTTagCompound()));
        } else if (value instanceof Entity) {
            NBTTagCompound newTag = new NBTTagCompound();
            ((Entity)value).func_189511_e(newTag);
            dataTag.func_74782_a(tagName, (NBTBase)newTag);
        } else {
            throw new RuntimeException("The data type of " + value.getClass().getName() + " is currently not supported." + Constants.NEW_LINE + "Raw Data: " + value.toString());
        }
    }

    public static NBTTagCompound writeInventoryToNBT(NBTTagCompound tag, InventoryBasic inventory) {
        if (inventory.func_145818_k_()) {
            tag.func_74778_a("CustomName", inventory.func_70005_c_());
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (int slotCount = 0; slotCount < inventory.func_70302_i_(); ++slotCount) {
            ItemStack stackInSlot = inventory.func_70301_a(slotCount);
            if (stackInSlot == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)slotCount);
            stackInSlot.func_77955_b(itemTag);
            nbttaglist.func_74742_a((NBTBase)itemTag);
        }
        tag.func_74782_a("Items", (NBTBase)nbttaglist);
        return tag;
    }

    public static InventoryBasic readInventoryFromNBT(NBTTagCompound tag, InventoryBasic inventory) {
        if (tag.func_150297_b("CustomName", 8)) {
            inventory.func_110133_a(tag.func_74779_i("CustomName"));
        }
        NBTTagList items = tag.func_150295_c("Items", 10);
        for (int storedCount = 0; storedCount < items.func_74745_c(); ++storedCount) {
            NBTTagCompound itemTag = items.func_150305_b(storedCount);
            int slotCount = itemTag.func_74771_c("Slot") & 0xFF;
            if (slotCount < 0 || slotCount >= inventory.func_70302_i_()) continue;
            inventory.func_70299_a(slotCount, ItemStack.func_77949_a((NBTTagCompound)itemTag));
        }
        return inventory;
    }

    public static ItemStack[] getStoredItems(NBTTagCompound tag, int invSize) {
        ItemStack[] inventory = null;
        if (tag.func_74764_b("Items")) {
            NBTTagList list = tag.func_150295_c("Items", 10);
            inventory = new ItemStack[invSize];
            for (int i = 0; i < list.func_74745_c(); ++i) {
                if (i > list.func_74745_c()) continue;
                NBTTagCompound currentTag = list.func_150305_b(i);
                inventory[currentTag.func_74771_c((String)"Slot")] = ItemStack.func_77949_a((NBTTagCompound)currentTag);
            }
        }
        return inventory;
    }

    public static NBTTagCompound getDeepTagCompound(NBTTagCompound tag, String[] tags) {
        NBTTagCompound deepTag = tag;
        if (tag != null) {
            for (String tagName : tags) {
                if (!deepTag.func_74764_b(tagName)) continue;
                deepTag = deepTag.func_74775_l(tagName);
            }
        }
        return deepTag;
    }
}

