/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib.util;

import com.google.common.collect.ImmutableMap;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.darkhax.bookshelf.client.particle.OpenParticleDigging;
import net.darkhax.bookshelf.lib.Constants;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderUtils {
    public static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");

    public static void registerPlayerLayer(LayerRenderer<EntityLivingBase> layer) {
        RenderUtils.getSteveRenderer().func_177094_a(layer);
        RenderUtils.getAlexRenderer().func_177094_a(layer);
    }

    public static RenderPlayer getSteveRenderer() {
        return RenderUtils.getPlayerRenderer("default");
    }

    public static RenderPlayer getAlexRenderer() {
        return RenderUtils.getPlayerRenderer("slim");
    }

    public static RenderPlayer getPlayerRenderer(String type) {
        return (RenderPlayer)Minecraft.func_71410_x().func_175598_ae().field_178636_l.get(type);
    }

    public static boolean setPlayerTexture(MinecraftProfileTexture.Type type, AbstractClientPlayer player, ResourceLocation texture) {
        if (player.func_152122_n() && texture != null) {
            player.func_175155_b().field_187107_a.put(type, texture);
            return true;
        }
        return false;
    }

    public static boolean spawnDigParticles(ParticleManager manager, IBlockState state, World world, BlockPos pos, EnumFacing side) {
        if (state != null && state.func_185901_i() != EnumBlockRenderType.INVISIBLE) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            float offset = 0.1f;
            AxisAlignedBB bounds = state.func_185900_c((IBlockAccess)world, pos);
            double xOffset = (double)x + Constants.RANDOM.nextDouble() * (bounds.field_72336_d - bounds.field_72340_a - (double)0.2f) + (double)0.1f + bounds.field_72340_a;
            double yOffset = (double)y + Constants.RANDOM.nextDouble() * (bounds.field_72337_e - bounds.field_72338_b - (double)0.2f) + (double)0.1f + bounds.field_72338_b;
            double zOffset = (double)z + Constants.RANDOM.nextDouble() * (bounds.field_72334_f - bounds.field_72339_c - (double)0.2f) + (double)0.1f + bounds.field_72339_c;
            if (side == EnumFacing.DOWN) {
                yOffset = (double)y + bounds.field_72338_b - (double)0.1f;
            } else if (side == EnumFacing.UP) {
                yOffset = (double)y + bounds.field_72337_e + (double)0.1f;
            } else if (side == EnumFacing.NORTH) {
                zOffset = (double)z + bounds.field_72339_c - (double)0.1f;
            } else if (side == EnumFacing.SOUTH) {
                zOffset = (double)z + bounds.field_72334_f + (double)0.1f;
            } else if (side == EnumFacing.WEST) {
                xOffset = (double)x + bounds.field_72340_a - (double)0.1f;
            } else if (side == EnumFacing.EAST) {
                xOffset = (double)x + bounds.field_72336_d + (double)0.1f;
            }
            manager.func_78873_a(new OpenParticleDigging(world, xOffset, yOffset, zOffset, 0.0, 0.0, 0.0, state).func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f));
        }
        return false;
    }

    public static boolean spawnBreakParticles(ParticleManager manager, IBlockState state, World world, BlockPos pos) {
        if (state.func_177230_c() != null) {
            int multiplier = 4;
            for (int xOffset = 0; xOffset < 4; ++xOffset) {
                for (int yOffset = 0; yOffset < 4; ++yOffset) {
                    for (int zOffset = 0; zOffset < 4; ++zOffset) {
                        double xPos = (double)pos.func_177958_n() + ((double)xOffset + 0.5) / 4.0;
                        double yPos = (double)pos.func_177956_o() + ((double)yOffset + 0.5) / 4.0;
                        double zPos = (double)pos.func_177952_p() + ((double)zOffset + 0.5) / 4.0;
                        manager.func_78873_a((Particle)new OpenParticleDigging(world, xPos, yPos, zPos, xPos - (double)pos.func_177958_n() - 0.5, yPos - (double)pos.func_177956_o() - 0.5, zPos - (double)pos.func_177952_p() - 0.5, state).func_174846_a(pos));
                    }
                }
            }
            return true;
        }
        return false;
    }

    public static void spawnParticleRing(World world, EnumParticleTypes particle, double x, double y, double z, double velocityX, double velocityY, double velocityZ, double step) {
        for (double degree = 0.0; degree < Math.PI * 2; degree += step) {
            world.func_175688_a(particle, x + Math.cos(degree), y, z + Math.sin(degree), velocityX, velocityY, velocityZ, new int[0]);
        }
    }

    public static void spawnPercentageParticleRing(World world, EnumParticleTypes particle, float percentage, double x, double y, double z, double velocityX, double velocityY, double velocityZ, double step) {
        for (double degree = 0.0; degree < Math.PI * 2 * (double)percentage; degree += step) {
            world.func_175688_a(particle, x + Math.cos(degree), y, z + Math.sin(degree), velocityX, velocityY, velocityZ, new int[0]);
        }
    }

    public static ResourceLocation downloadResourceLocation(String url, ResourceLocation outputResource, ResourceLocation defaultResource, IImageBuffer buffer) {
        RenderUtils.downloadResource(url, outputResource, defaultResource, buffer);
        return outputResource;
    }

    public static ThreadDownloadImageData downloadResource(String url, ResourceLocation outputResource, ResourceLocation defaultResource, IImageBuffer buffer) {
        TextureManager manager = Minecraft.func_71410_x().func_110434_K();
        ThreadDownloadImageData imageData = (ThreadDownloadImageData)manager.func_110581_b(outputResource);
        if (imageData == null) {
            imageData = new ThreadDownloadImageData(null, url, defaultResource, buffer);
            manager.func_110579_a(outputResource, (ITextureObject)imageData);
        }
        return imageData;
    }

    public static Frustum getCamera(Entity entity, float partialTicks) {
        double cameraX = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks;
        double cameraY = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks;
        double cameraZ = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks;
        Frustum camera = new Frustum();
        camera.func_78547_a(cameraX, cameraY, cameraZ);
        return camera;
    }

    public static void translateAgainstPlayer(BlockPos pos, boolean offset) {
        float x = (float)((double)pos.func_177958_n() - TileEntityRendererDispatcher.field_147554_b);
        float y = (float)((double)pos.func_177956_o() - TileEntityRendererDispatcher.field_147555_c);
        float z = (float)((double)pos.func_177952_p() - TileEntityRendererDispatcher.field_147552_d);
        if (offset) {
            GlStateManager.func_179137_b((double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5));
        } else {
            GlStateManager.func_179109_b((float)x, (float)y, (float)z);
        }
    }

    public static TextureAtlasSprite getParticleTexture(ItemStack stack) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack).func_177554_e();
    }

    public static TextureAtlasSprite getSprite(ItemStack stack) {
        Minecraft mc = Minecraft.func_71410_x();
        Block block = ItemStackUtils.getBlockFromStack(stack);
        if (block == null) {
            ItemModelMesher mesher = mc.func_175599_af().func_175037_a();
            return ItemStackUtils.isValidStack(stack) ? mesher.func_178087_a(stack.func_77973_b(), stack.func_77952_i()) : mesher.func_178089_a(null).func_177554_e();
        }
        return mc.func_175602_ab().func_175023_a().func_178122_a(block.func_176203_a(stack.func_77952_i()));
    }

    public static IBakedModel getBakedModel(ModelResourceLocation name) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174953_a(name);
    }

    public static IBakedModel getBakedModel(ItemStack stack) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
    }

    public static void renderFluid(FluidStack fluid, BlockPos pos, double x, double y, double z, double width, double height, double length) {
        double x1 = (1.0 - width) / 2.0;
        double y1 = (1.0 - height) / 2.0;
        double z1 = (1.0 - length) / 2.0;
        RenderUtils.renderFluid(fluid, pos, x, y, z, x1, y1, z1, 1.0 - x1, 1.0 - y1, 1.0 - z1);
    }

    public static void renderFluid(FluidStack fluid, BlockPos pos, double x, double y, double z, double x1, double y1, double z1, double x2, double y2, double z2) {
        int color = fluid.getFluid().getColor(fluid);
        RenderUtils.renderFluid(fluid, pos, x, y, z, x1, y1, z1, x2, y2, z2, color);
    }

    public static void renderFluid(FluidStack fluid, BlockPos pos, double x, double y, double z, double x1, double y1, double z1, double x2, double y2, double z2, int color) {
        Minecraft mc = Minecraft.func_71410_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        int brightness = mc.field_71441_e.func_175626_b(pos, fluid.getFluid().getLuminosity());
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        RenderUtils.setupRenderState(x, y, z);
        TextureAtlasSprite still = mc.func_147117_R().getTextureExtry(fluid.getFluid().getStill(fluid).toString());
        TextureAtlasSprite flowing = mc.func_147117_R().getTextureExtry(fluid.getFluid().getFlowing(fluid).toString());
        RenderUtils.addTexturedQuad(buffer, still, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.DOWN, color, brightness);
        RenderUtils.addTexturedQuad(buffer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.NORTH, color, brightness);
        RenderUtils.addTexturedQuad(buffer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.EAST, color, brightness);
        RenderUtils.addTexturedQuad(buffer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.SOUTH, color, brightness);
        RenderUtils.addTexturedQuad(buffer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.WEST, color, brightness);
        RenderUtils.addTexturedQuad(buffer, still, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.UP, color, brightness);
        tessellator.func_78381_a();
        RenderUtils.cleanupRenderState();
    }

    public static void addTexturedQuad(VertexBuffer buffer, TextureAtlasSprite sprite, double x, double y, double z, double width, double height, double length, EnumFacing face, int color, int brightness) {
        if (sprite == null) {
            Constants.LOG.warn("Attempted to draw a textures quad with no texture! X:%f Y:%f Z:%f");
            return;
        }
        int firstLightValue = brightness >> 16 & 0xFFFF;
        int secondLightValue = brightness & 0xFFFF;
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        RenderUtils.addTextureQuad(buffer, sprite, x, y, z, width, height, length, face, red, green, blue, alpha, firstLightValue, secondLightValue);
    }

    public static void addTextureQuad(VertexBuffer buffer, TextureAtlasSprite sprite, double x, double y, double z, double width, double height, double length, EnumFacing face, int red, int green, int blue, int alpha, int light1, int light2) {
        double maxV;
        double minV;
        double maxU;
        double minU;
        double vz1;
        double vy1;
        double u1;
        double size = 16.0;
        double x2 = x + width;
        double y2 = y + height;
        double z2 = z + length;
        double u = x % 1.0;
        for (u1 = u + width; u1 > 1.0; u1 -= 1.0) {
        }
        double vy = y % 1.0;
        for (vy1 = vy + height; vy1 > 1.0; vy1 -= 1.0) {
        }
        double vz = z % 1.0;
        for (vz1 = vz + length; vz1 > 1.0; vz1 -= 1.0) {
        }
        switch (face) {
            case DOWN: 
            case UP: {
                minU = sprite.func_94214_a(u * 16.0);
                maxU = sprite.func_94214_a(u1 * 16.0);
                minV = sprite.func_94207_b(vz * 16.0);
                maxV = sprite.func_94207_b(vz1 * 16.0);
                break;
            }
            case NORTH: 
            case SOUTH: {
                minU = sprite.func_94214_a(u1 * 16.0);
                maxU = sprite.func_94214_a(u * 16.0);
                minV = sprite.func_94207_b(vy * 16.0);
                maxV = sprite.func_94207_b(vy1 * 16.0);
                break;
            }
            case WEST: 
            case EAST: {
                minU = sprite.func_94214_a(vz1 * 16.0);
                maxU = sprite.func_94214_a(vz * 16.0);
                minV = sprite.func_94207_b(vy * 16.0);
                maxV = sprite.func_94207_b(vy1 * 16.0);
                break;
            }
            default: {
                minU = sprite.func_94209_e();
                maxU = sprite.func_94212_f();
                minV = sprite.func_94206_g();
                maxV = sprite.func_94210_h();
            }
        }
        switch (face) {
            case DOWN: {
                buffer.func_181662_b(x, y, z).func_181669_b(red, green, blue, alpha).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x2, y, z).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x2, y, z2).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x, y, z2).func_181669_b(red, green, blue, alpha).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case UP: {
                buffer.func_181662_b(x, y2, z).func_181669_b(red, green, blue, alpha).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x, y2, z2).func_181669_b(red, green, blue, alpha).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x2, y2, z2).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x2, y2, z).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case NORTH: {
                buffer.func_181662_b(x, y, z).func_181669_b(red, green, blue, alpha).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x, y2, z).func_181669_b(red, green, blue, alpha).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x2, y2, z).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x2, y, z).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case SOUTH: {
                buffer.func_181662_b(x, y, z2).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x2, y, z2).func_181669_b(red, green, blue, alpha).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x2, y2, z2).func_181669_b(red, green, blue, alpha).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x, y2, z2).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case WEST: {
                buffer.func_181662_b(x, y, z).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x, y, z2).func_181669_b(red, green, blue, alpha).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x, y2, z2).func_181669_b(red, green, blue, alpha).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x, y2, z).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case EAST: {
                buffer.func_181662_b(x2, y, z).func_181669_b(red, green, blue, alpha).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x2, y2, z).func_181669_b(red, green, blue, alpha).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x2, y2, z2).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b(x2, y, z2).func_181669_b(red, green, blue, alpha).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
            }
        }
    }

    public static void setupRenderState(double x, double y, double z) {
        GlStateManager.func_179094_E();
        RenderHelper.func_74518_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (Minecraft.func_71379_u()) {
            GL11.glShadeModel((int)7425);
        } else {
            GL11.glShadeModel((int)7424);
        }
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
    }

    public static void cleanupRenderState() {
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        RenderHelper.func_74519_b();
    }

    public static void renderGlintEffect(RenderItem renderer, ItemStack stack, IBakedModel model, ResourceLocation texture, int color) {
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179143_c((int)514);
        GlStateManager.func_179140_f();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        renderer.field_175057_n.func_110577_a(texture);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f / 8.0f;
        GlStateManager.func_179109_b((float)f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        renderer.func_175035_a(model, color);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f1 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f / 8.0f;
        GlStateManager.func_179109_b((float)(-f1), (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        renderer.func_175035_a(model, color);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179145_e();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        renderer.field_175057_n.func_110577_a(TextureMap.field_110575_b);
    }

    public static List<BakedQuad> getMissingquads(IBlockState state, EnumFacing side, long rand) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a().func_188616_a(state, side, rand);
    }

    public static TextureAtlasSprite getSprite(IBlockState state) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getBasicTransforms(IPerspectiveAwareModel model) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ItemCameraTransforms.TransformType type : ItemCameraTransforms.TransformType.values()) {
            TRSRTransformation transformation = new TRSRTransformation((Matrix4f)model.handlePerspective(type).getRight());
            if (transformation.equals((Object)TRSRTransformation.identity())) continue;
            builder.put((Object)type, (Object)TRSRTransformation.blockCenterToCorner((TRSRTransformation)transformation));
        }
        return builder.build();
    }
}

