/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity;

import com.bobmowzie.mowziesmobs.server.entity.EntitySolarBeam;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderSolarBeam
extends Render<EntitySolarBeam> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("mowziesmobs", "textures/effects/solar_beam.png");
    private static final double TEXTURE_WIDTH = 256.0;
    private static final double TEXTURE_HEIGHT = 32.0;
    private static final double START_RADIUS = 1.3;
    private static final double BEAM_RADIUS = 1.0;
    private boolean clearerView = false;
    public static final VertexFormat POSITION_TEX_LMAP = new VertexFormat().func_181721_a(DefaultVertexFormats.field_181713_m).func_181721_a(DefaultVertexFormats.field_181715_o).func_181721_a(DefaultVertexFormats.field_181716_p);

    public RenderSolarBeam(RenderManager mgr) {
        super(mgr);
    }

    protected ResourceLocation getEntityTexture(EntitySolarBeam entity) {
        return TEXTURE;
    }

    public void doRender(EntitySolarBeam solarBeam, double x, double y, double z, float yaw, float delta) {
        this.clearerView = solarBeam.caster instanceof EntityPlayer && Minecraft.func_71410_x().field_71439_g == solarBeam.caster && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0;
        double length = Math.sqrt(Math.pow(solarBeam.collidePosX - solarBeam.field_70165_t, 2.0) + Math.pow(solarBeam.collidePosY - solarBeam.field_70163_u, 2.0) + Math.pow(solarBeam.collidePosZ - solarBeam.field_70161_v, 2.0));
        int frame = MathHelper.func_76128_c((double)(((float)(solarBeam.appear.getTimer() - 1) + delta) * 2.0f));
        if (frame < 0) {
            frame = 6;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        this.setupGL();
        this.func_180548_c(solarBeam);
        GlStateManager.func_179132_a((boolean)false);
        this.renderStart(frame);
        this.renderBeam(length, 57.29577951308232 * (double)solarBeam.getYaw(), 57.29577951308232 * (double)solarBeam.getPitch(), frame);
        GlStateManager.func_179137_b((double)(solarBeam.collidePosX - solarBeam.field_70165_t), (double)(solarBeam.collidePosY - solarBeam.field_70163_u), (double)(solarBeam.collidePosZ - solarBeam.field_70161_v));
        this.renderEnd(frame, solarBeam.blockSide);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179137_b((double)(solarBeam.field_70165_t - solarBeam.collidePosX), (double)(solarBeam.field_70163_u - solarBeam.collidePosY), (double)(solarBeam.field_70161_v - solarBeam.collidePosZ));
        GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)true);
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O != 0) {
            this.renderStart(frame);
        }
        this.renderBeam(length, 57.29577951308232 * (double)solarBeam.getYaw(), 57.29577951308232 * (double)solarBeam.getPitch(), frame);
        GlStateManager.func_179137_b((double)(solarBeam.collidePosX - solarBeam.field_70165_t), (double)(solarBeam.collidePosY - solarBeam.field_70163_u), (double)(solarBeam.collidePosZ - solarBeam.field_70161_v));
        this.renderEnd(frame, null);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        this.revertGL();
        GlStateManager.func_179121_F();
    }

    private void renderStart(int frame) {
        if (this.clearerView) {
            return;
        }
        GlStateManager.func_179114_b((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)this.field_76990_c.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        double minU = 0.0 + 0.0625 * (double)frame;
        double minV = 0.0;
        double maxU = minU + 0.0625;
        double maxV = minV + 0.5;
        Tessellator t = Tessellator.func_178181_a();
        VertexBuffer buf = t.func_178180_c();
        buf.func_181668_a(7, POSITION_TEX_LMAP);
        buf.func_181662_b(-1.3, -1.3, 0.0).func_187315_a(minU, minV).func_187314_a(0, 240).func_181675_d();
        buf.func_181662_b(-1.3, 1.3, 0.0).func_187315_a(minU, maxV).func_187314_a(0, 240).func_181675_d();
        buf.func_181662_b(1.3, 1.3, 0.0).func_187315_a(maxU, maxV).func_187314_a(0, 240).func_181675_d();
        buf.func_181662_b(1.3, -1.3, 0.0).func_187315_a(maxU, minV).func_187314_a(0, 240).func_181675_d();
        t.func_78381_a();
        GlStateManager.func_179114_b((float)this.field_76990_c.field_78732_j, (float)-1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)-1.0f, (float)0.0f);
    }

    private void renderEnd(int frame, EnumFacing side) {
        GlStateManager.func_179114_b((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)this.field_76990_c.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        double minU = 0.0 + 0.0625 * (double)frame;
        double minV = 0.0;
        double maxU = minU + 0.0625;
        double maxV = minV + 0.5;
        Tessellator t = Tessellator.func_178181_a();
        VertexBuffer buf = t.func_178180_c();
        buf.func_181668_a(7, POSITION_TEX_LMAP);
        buf.func_181662_b(-1.3, -1.3, 0.0).func_187315_a(minU, minV).func_187314_a(0, 240).func_181675_d();
        buf.func_181662_b(-1.3, 1.3, 0.0).func_187315_a(minU, maxV).func_187314_a(0, 240).func_181675_d();
        buf.func_181662_b(1.3, 1.3, 0.0).func_187315_a(maxU, maxV).func_187314_a(0, 240).func_181675_d();
        buf.func_181662_b(1.3, -1.3, 0.0).func_187315_a(maxU, minV).func_187314_a(0, 240).func_181675_d();
        t.func_78381_a();
        GlStateManager.func_179114_b((float)this.field_76990_c.field_78732_j, (float)-1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)-1.0f, (float)0.0f);
        if (side == null) {
            return;
        }
        buf.func_181668_a(7, POSITION_TEX_LMAP);
        buf.func_181662_b(-1.3, -1.3, 0.0).func_187315_a(minU, minV).func_187314_a(0, 240).func_181675_d();
        buf.func_181662_b(-1.3, 1.3, 0.0).func_187315_a(minU, maxV).func_187314_a(0, 240).func_181675_d();
        buf.func_181662_b(1.3, 1.3, 0.0).func_187315_a(maxU, maxV).func_187314_a(0, 240).func_181675_d();
        buf.func_181662_b(1.3, -1.3, 0.0).func_187315_a(maxU, minV).func_187314_a(0, 240).func_181675_d();
        GlStateManager.func_179094_E();
        switch (side) {
            case EAST: {
                GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.01f);
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.01f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.01f);
                break;
            }
            case NORTH: {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.01f);
                break;
            }
            case DOWN: {
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.01f);
                break;
            }
            case UP: {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.01f);
            }
        }
        t.func_78381_a();
        GlStateManager.func_179121_F();
    }

    private void renderBeam(double length, double yaw, double pitch, int frame) {
        double minU = 0.0;
        double minV = 0.5 + 0.03125 * (double)frame;
        double maxU = minU + 0.078125;
        double maxV = minV + 0.03125;
        Tessellator t = Tessellator.func_178181_a();
        VertexBuffer buf = t.func_178180_c();
        buf.func_181668_a(7, POSITION_TEX_LMAP);
        buf.func_181662_b(-1.0, 0.0, 0.0).func_187315_a(minU, minV).func_187314_a(0, 240).func_181675_d();
        buf.func_181662_b(-1.0, length, 0.0).func_187315_a(minU, maxV).func_187314_a(0, 240).func_181675_d();
        buf.func_181662_b(1.0, length, 0.0).func_187315_a(maxU, maxV).func_187314_a(0, 240).func_181675_d();
        buf.func_181662_b(1.0, 0.0, 0.0).func_187315_a(maxU, minV).func_187314_a(0, 240).func_181675_d();
        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)((float)yaw), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)pitch), (float)0.0f, (float)0.0f, (float)1.0f);
        if (this.clearerView) {
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            GlStateManager.func_179114_b((float)this.field_76990_c.field_78732_j, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        t.func_78381_a();
        if (this.clearerView) {
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            GlStateManager.func_179114_b((float)(-this.field_76990_c.field_78732_j), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (!this.clearerView) {
            buf.func_181668_a(7, POSITION_TEX_LMAP);
            buf.func_181662_b(-1.0, 0.0, 0.0).func_187315_a(minU, minV).func_187314_a(0, 240).func_181675_d();
            buf.func_181662_b(-1.0, length, 0.0).func_187315_a(minU, maxV).func_187314_a(0, 240).func_181675_d();
            buf.func_181662_b(1.0, length, 0.0).func_187315_a(maxU, maxV).func_187314_a(0, 240).func_181675_d();
            buf.func_181662_b(1.0, 0.0, 0.0).func_187315_a(maxU, minV).func_187314_a(0, 240).func_181675_d();
            GlStateManager.func_179114_b((float)(-this.field_76990_c.field_78732_j), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            t.func_78381_a();
            GlStateManager.func_179114_b((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)this.field_76990_c.field_78732_j, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GlStateManager.func_179114_b((float)((float)(-pitch)), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)((float)(-yaw)), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    private void setupGL() {
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
    }

    private void revertGL() {
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
    }
}

