/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.foliaath;

import com.bobmowzie.mowziesmobs.client.model.tools.ControlledAnimation;
import com.bobmowzie.mowziesmobs.client.model.tools.IntermittentAnimation;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationAttackAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationDieAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationTakeDamage;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.foliaath.EntityBabyFoliaath;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityFoliaath
extends MowzieEntity {
    public static final Animation DIE_ANIMATION = Animation.create((int)50);
    public static final Animation HURT_ANIMATION = Animation.create((int)10);
    public static final Animation ATTACK_ANIMATION = Animation.create((int)14);
    private static final DataParameter<Boolean> CAN_DESPAWN = EntityDataManager.func_187226_a(EntityFoliaath.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ACTIVATE_TARGET = EntityDataManager.func_187226_a(EntityFoliaath.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final int ACTIVATE_DURATION = 30;
    public IntermittentAnimation<EntityFoliaath> openMouth;
    public ControlledAnimation activate;
    public ControlledAnimation deathFlail;
    public ControlledAnimation stopDance;
    public int lastTimeDecrease;
    int resettingTargetTimer;
    private double prevOpenMouth;
    private double prevActivate;
    private int activateTarget;

    public EntityFoliaath(World world) {
        super(world);
        this.openMouth = new IntermittentAnimation<EntityFoliaath>(this, 15, 30, 50, !this.field_70170_p.field_72995_K);
        this.activate = new ControlledAnimation(30);
        this.deathFlail = new ControlledAnimation(5);
        this.stopDance = new ControlledAnimation(10);
        this.lastTimeDecrease = 0;
        this.resettingTargetTimer = 0;
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, new AnimationAttackAI<EntityFoliaath>(this, ATTACK_ANIMATION, MMSounds.ENTITY_FOLIAATH_BITE_1, null, 2.0f, 4.5f, 1.0f, 3));
        this.field_70714_bg.func_75776_a(1, new AnimationTakeDamage<EntityFoliaath>(this));
        this.field_70714_bg.func_75776_a(1, new AnimationDieAI<EntityFoliaath>(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true, false, e -> EntityPlayer.class.isAssignableFrom(e.getClass()) || EntityCreature.class.isAssignableFrom(e.getClass())));
        this.func_70105_a(0.5f, 2.5f);
        this.field_70728_aV = 10;
        this.addIntermittentAnimation(this.openMouth);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(CAN_DESPAWN, (Object)true);
        this.func_184212_Q().func_187214_a(ACTIVATE_TARGET, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
    }

    @Override
    public int getAttack() {
        return 10;
    }

    public SoundEvent func_184601_bQ() {
        return MMSounds.ENTITY_FOLIAATH_HURT;
    }

    public SoundEvent func_184615_bR() {
        return MMSounds.ENTITY_FOLIAATH_DIE;
    }

    @Override
    public void func_70071_h_() {
        int openMouthTime;
        super.func_70071_h_();
        this.field_70165_t = this.field_70169_q;
        this.field_70161_v = this.field_70166_s;
        if (this.getAnimation() == NO_ANIMATION && !this.activate.canIncreaseTimer()) {
            this.openMouth.update();
        } else {
            this.openMouth.stop();
        }
        if (this.activate.getAnimationFraction() >= 0.8f) {
            if (!this.active) {
                this.active = true;
            }
        } else if (this.activate.getAnimationFraction() < 0.8f && this.active) {
            this.active = false;
        }
        if (this.frame % 13 == 3 && this.getAnimation() != DIE_ANIMATION) {
            if (this.openMouth.getTimeRunning() >= 10) {
                this.func_184185_a(MMSounds.ENTITY_FOLIAATH_PANT_1, 1.0f, 1.0f);
            } else if (this.activate.getTimer() >= 25) {
                this.func_184185_a(MMSounds.ENTITY_FOLIAATH_PANT_2, 1.0f, 1.0f);
            }
        }
        if (this.prevOpenMouth - (double)(openMouthTime = this.openMouth.getTimeRunning()) < 0.0) {
            if (openMouthTime == 1) {
                this.func_184185_a(MMSounds.ENTITY_FOLIAATH_RUSTLE, 1.0f, 1.0f);
            } else if (openMouthTime == 13) {
                this.func_184185_a(MMSounds.ENTITY_FOLIAATH_GRUNT, 1.0f, 1.0f);
            }
        }
        this.prevOpenMouth = openMouthTime;
        int activateTime = this.activate.getTimer();
        if (!this.field_70170_p.field_72995_K) {
            SoundEvent sound = null;
            if (this.prevActivate - (double)activateTime < 0.0) {
                switch (activateTime) {
                    case 1: {
                        sound = MMSounds.ENTITY_FOLIAATH_RUSTLE;
                        break;
                    }
                    case 5: {
                        sound = MMSounds.ENTITY_FOLIAATH_MERGE;
                    }
                }
            } else if (this.prevActivate - (double)activateTime > 0.0) {
                switch (activateTime) {
                    case 24: {
                        sound = MMSounds.ENTITY_FOLIAATH_RETREAT;
                        break;
                    }
                    case 28: {
                        sound = MMSounds.ENTITY_FOLIAATH_RUSTLE;
                    }
                }
            }
            if (sound != null) {
                this.func_184185_a(sound, 1.0f, 1.0f);
            }
        }
        this.prevActivate = activateTime;
        this.field_70761_aq = 0.0f;
        this.field_70177_z = 0.0f;
        if (this.func_70638_az() instanceof EntityFoliaath || this.func_70638_az() instanceof EntityBabyFoliaath) {
            this.func_70624_b(null);
        }
        if (this.resettingTargetTimer > 0 && !this.field_70170_p.field_72995_K) {
            this.field_70759_as = this.field_70758_at;
        }
        if (this.func_70638_az() != null) {
            this.field_70759_as = this.targetAngle;
            if ((double)this.targetDistance <= 4.5 && this.func_70638_az().field_70163_u - this.field_70163_u >= -1.0 && this.func_70638_az().field_70163_u - this.field_70163_u <= 2.0 && this.getAnimation() == NO_ANIMATION && this.active) {
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, ATTACK_ANIMATION);
            }
            if (this.targetDistance <= 11.0f) {
                this.setActivateTarget(30);
                this.lastTimeDecrease = 0;
            } else if (this.lastTimeDecrease <= 30 && this.getAnimation() == NO_ANIMATION) {
                this.setActivateTarget(0);
                ++this.lastTimeDecrease;
            }
        } else if (!this.field_70170_p.field_72995_K && this.lastTimeDecrease <= 30 && this.getAnimation() == NO_ANIMATION && this.resettingTargetTimer == 0) {
            this.setActivateTarget(0);
            ++this.lastTimeDecrease;
        }
        if (this.getAnimation() == DIE_ANIMATION) {
            if (this.getAnimationTick() <= 12) {
                this.deathFlail.increaseTimer();
            } else {
                this.deathFlail.decreaseTimer();
            }
            this.stopDance.increaseTimer();
            this.setActivateTarget(30);
        }
        if (this.resettingTargetTimer > 0) {
            --this.resettingTargetTimer;
        }
        if (this.func_70638_az() != null && this.frame % 20 == 0 && this.getAnimation() == NO_ANIMATION) {
            this.func_70624_b(null);
            this.resettingTargetTimer = 20;
        }
        if (this.activateTarget == activateTime) {
            this.activateTarget = this.getActivateTarget();
        } else if (activateTime < this.activateTarget && this.activate.canIncreaseTimer() || activateTime > this.activateTarget && this.activate.canDecreaseTimer()) {
            this.activate.increaseTimer(activateTime < this.activateTarget ? 1 : -2);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float amount) {
        return this.active && super.func_70097_a(damageSource, amount);
    }

    @Override
    public Animation getDeathAnimation() {
        return DIE_ANIMATION;
    }

    @Override
    public Animation getHurtAnimation() {
        return HURT_ANIMATION;
    }

    public void func_70108_f(Entity entity) {
        double deltaZ;
        double deltaX;
        double majorAxis;
        if (!entity.func_184188_bt().contains(this) && entity.func_184187_bx() != this && (majorAxis = MathHelper.func_76132_a((double)(deltaX = entity.field_70165_t - this.field_70165_t), (double)(deltaZ = entity.field_70161_v - this.field_70161_v))) >= 0.009999999) {
            majorAxis = MathHelper.func_76133_a((double)majorAxis);
            deltaX /= majorAxis;
            deltaZ /= majorAxis;
            double reciprocal = 1.0 / majorAxis;
            if (reciprocal > 1.0) {
                reciprocal = 1.0;
            }
            deltaX *= reciprocal;
            deltaZ *= reciprocal;
            deltaX *= 0.05;
            deltaZ *= 0.05;
            this.func_70024_g(deltaX *= (double)(1.0f - this.field_70144_Y), 0.0, deltaZ *= (double)(1.0f - this.field_70144_Y));
            entity.func_70024_g(deltaX, 0.0, deltaZ);
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70601_bi() {
        if (this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ())) {
            BlockPos ground = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
            if (ground.func_177956_o() < 64) {
                return false;
            }
            IBlockState block = this.field_70170_p.func_180495_p(ground);
            if (block.func_177230_c() == Blocks.field_150349_c || block.func_177230_c().isLeaves(block, (IBlockAccess)this.field_70170_p, ground)) {
                return true;
            }
        }
        return false;
    }

    public void func_70074_a(EntityLivingBase entity) {
        this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 300, 1, true, true));
    }

    protected Item func_146068_u() {
        return this.field_70146_Z.nextBoolean() ? ItemHandler.INSTANCE.foliaathSeed : null;
    }

    public boolean func_70692_ba() {
        return (Boolean)this.func_184212_Q().func_187225_a(CAN_DESPAWN);
    }

    public void setCanDespawn(boolean canDespawn) {
        this.func_184212_Q().func_187227_b(CAN_DESPAWN, (Object)canDespawn);
    }

    public int getActivateTarget() {
        return (Integer)this.func_184212_Q().func_187225_a(ACTIVATE_TARGET);
    }

    public void setActivateTarget(int activateTarget) {
        this.func_184212_Q().func_187227_b(ACTIVATE_TARGET, (Object)activateTarget);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("canDespawn", this.func_70692_ba());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setCanDespawn(compound.func_74767_n("canDespawn"));
    }

    protected void func_180429_a(BlockPos pos, Block block) {
    }

    public Animation[] getAnimations() {
        return new Animation[]{DIE_ANIMATION, HURT_ANIMATION, ATTACK_ANIMATION};
    }
}

