/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity;

import com.bobmowzie.mowziesmobs.client.model.entity.ModelBarako;
import com.bobmowzie.mowziesmobs.client.render.entity.RenderSunstrike;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarako;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderBarako
extends RenderLiving<EntityBarako> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("mowziesmobs", "textures/entity/barako.png");
    private static final double BURST_RADIUS = 3.5;
    private static final int BURST_FRAME_COUNT = 10;
    private static final int BURST_START_FRAME = 12;

    public RenderBarako(RenderManager mgr) {
        super(mgr, (ModelBase)new ModelBarako(), 1.0f);
    }

    protected float getDeathMaxRotation(EntityBarako entity) {
        return 0.0f;
    }

    public ResourceLocation getEntityTexture(EntityBarako entity) {
        return TEXTURE;
    }

    public void doRender(EntityBarako barako, double x, double y, double z, float yaw, float delta) {
        if (barako.getAnimation() == EntityBarako.ATTACK_ANIMATION && barako.getAnimationTick() > 12 && barako.getAnimationTick() < 21) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)(y + 1.1), (double)z);
            this.setupGL();
            this.func_110776_a(RenderSunstrike.TEXTURE);
            GlStateManager.func_179114_b((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)this.field_76990_c.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179097_i();
            this.drawBurst((float)(barako.getAnimationTick() - 12) + delta);
            GlStateManager.func_179126_j();
            this.revertGL();
            GlStateManager.func_179121_F();
        }
        super.func_76986_a((EntityLiving)barako, x, y, z, yaw, delta);
    }

    private void drawBurst(float tick) {
        int frame;
        int dissapateFrame = 6;
        float firstSpeed = 2.0f;
        float secondSpeed = 1.0f;
        int n = frame = (int)(tick * firstSpeed) <= dissapateFrame ? (int)(tick * firstSpeed) : (int)((float)dissapateFrame + (tick - (float)dissapateFrame / firstSpeed) * secondSpeed);
        if (frame > 10) {
            frame = 10;
        }
        double minU = 0.0625 * (double)frame;
        double maxU = minU + 0.0625;
        double minV = 0.5;
        double maxV = minV + 0.5;
        double offset = 0.219 * (double)(frame % 2);
        Tessellator t = Tessellator.func_178181_a();
        VertexBuffer buf = t.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181711_k);
        float opacity = tick < 8.0f ? 0.8f : 0.4f;
        buf.func_181662_b(-3.5 + offset, -3.5 + offset, 0.0).func_187315_a(minU, minV).func_187314_a(0, 240).func_181666_a(1.0f, 1.0f, 1.0f, opacity).func_181675_d();
        buf.func_181662_b(-3.5 + offset, 3.5 + offset, 0.0).func_187315_a(minU, maxV).func_187314_a(0, 240).func_181666_a(1.0f, 1.0f, 1.0f, opacity).func_181675_d();
        buf.func_181662_b(3.5 + offset, 3.5 + offset, 0.0).func_187315_a(maxU, maxV).func_187314_a(0, 240).func_181666_a(1.0f, 1.0f, 1.0f, opacity).func_181675_d();
        buf.func_181662_b(3.5 + offset, -3.5 + offset, 0.0).func_187315_a(maxU, minV).func_187314_a(0, 240).func_181666_a(1.0f, 1.0f, 1.0f, opacity).func_181675_d();
        GlStateManager.func_179097_i();
        t.func_78381_a();
        GlStateManager.func_179126_j();
    }

    private void setupGL() {
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
    }

    private void revertGL() {
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
    }
}

