/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.client.particle.MMParticle;
import com.bobmowzie.mowziesmobs.client.particle.ParticleFactory;
import com.bobmowzie.mowziesmobs.server.entity.LeaderSunstrikeImmune;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarako;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketEntityTeleport;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntitySunstrike
extends Entity
implements IEntityAdditionalSpawnData {
    public static final int STRIKE_EXPLOSION = 35;
    private static final int STRIKE_LENGTH = 43;
    private static final int STRIKE_LINGER = 1243;
    private int prevStrikeTime;
    private int strikeTime;
    private EntityLivingBase caster;
    private static final DataParameter<Integer> VARIANT_LEAST = EntityDataManager.func_187226_a(EntitySunstrike.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> VARIANT_MOST = EntityDataManager.func_187226_a(EntitySunstrike.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntitySunstrike(World world) {
        super(world);
        this.func_70105_a(0.1f, 0.1f);
        this.field_70158_ak = true;
    }

    public EntitySunstrike(World world, EntityLivingBase caster, int x, int y, int z) {
        this(world);
        this.caster = caster;
        this.func_70107_b((float)x + 0.5f, (float)y + 1.0625f, (float)z + 0.5f);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(VARIANT_LEAST, (Object)0);
        this.func_184212_Q().func_187214_a(VARIANT_MOST, (Object)0);
    }

    public float getStrikeTime(float delta) {
        return this.getActualStrikeTime(delta) / 43.0f;
    }

    public float getStrikeDrawTime(float delta) {
        return this.getActualStrikeTime(delta) / 35.0f;
    }

    public float getStrikeDamageTime(float delta) {
        return (this.getActualStrikeTime(delta) - 35.0f) / 8.0f;
    }

    public boolean isStrikeDrawing(float delta) {
        return this.getActualStrikeTime(delta) < 35.0f;
    }

    public boolean isLingering(float delta) {
        return this.getActualStrikeTime(delta) > 40.0f;
    }

    public boolean isStriking(float delta) {
        return this.getActualStrikeTime(delta) < 43.0f;
    }

    private float getActualStrikeTime(float delta) {
        return (float)this.prevStrikeTime + (float)(this.strikeTime - this.prevStrikeTime) * delta;
    }

    private void setStrikeTime(int strikeTime) {
        this.prevStrikeTime = this.strikeTime = strikeTime;
    }

    public boolean isStriking() {
        return this.isStriking(1.0f);
    }

    public long getVariant() {
        return (long)((Integer)this.func_184212_Q().func_187225_a(VARIANT_MOST)).intValue() << 32 | (long)((Integer)this.func_184212_Q().func_187225_a(VARIANT_LEAST)).intValue() & 0xFFFFFFFFL;
    }

    private void setVariant(long variant) {
        this.func_184212_Q().func_187227_b(VARIANT_MOST, (Object)((int)(variant >> 32)));
        this.func_184212_Q().func_187227_b(VARIANT_LEAST, (Object)((int)variant));
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70112_a(double distance) {
        return distance < 1024.0;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevStrikeTime = this.strikeTime;
        if (this.field_70170_p.field_72995_K) {
            if (this.strikeTime == 0) {
                MowziesMobs.PROXY.playSunstrikeSound(this);
            } else if (this.strikeTime < 25) {
                float time = this.getStrikeTime(1.0f);
                int timeBonus = (int)(time * 5.0f);
                int orbCount = this.field_70146_Z.nextInt(4 + timeBonus) + timeBonus + 1;
                while (orbCount-- > 0) {
                    float theta = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                    float min = 0.2f;
                    float max = 1.9f;
                    float r = this.field_70146_Z.nextFloat() * 1.6999999f + 0.2f;
                    float ox = r * MathHelper.func_76134_b((float)theta);
                    float oz = r * MathHelper.func_76126_a((float)theta);
                    float minY = 0.1f;
                    float oy = this.field_70146_Z.nextFloat() * (time * 6.0f - 0.1f) + 0.1f;
                    MMParticle.ORB.spawn(this.field_70170_p, this.field_70165_t + (double)ox, this.field_70163_u + (double)oy, this.field_70161_v + (double)oz, (ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(this.field_70165_t, this.field_70161_v));
                }
            } else if (this.strikeTime > 35) {
                this.smolder();
            } else if (this.strikeTime == 35) {
                this.spawnExplosionParticles(10);
            }
        } else {
            this.moveDownToGround();
            if (this.strikeTime >= 1243 || !this.field_70170_p.func_175710_j(this.func_180425_c())) {
                this.func_70106_y();
            } else if (this.strikeTime == 35) {
                this.damageEntityLivingBaseNearby(3.0);
            }
        }
        ++this.strikeTime;
    }

    public void moveDownToGround() {
        RayTraceResult rayTrace = this.rayTrace(this);
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK && rayTrace.field_178784_b == EnumFacing.UP) {
            IBlockState hitBlock = this.field_70170_p.func_180495_p(rayTrace.func_178782_a());
            if (this.strikeTime > 43 && hitBlock != this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b())) {
                this.func_70106_y();
            }
            if (hitBlock instanceof BlockSlab && hitBlock.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.BOTTOM) {
                this.func_70107_b(this.field_70165_t, (float)rayTrace.func_178782_a().func_177956_o() + 1.0625f - 0.5f, this.field_70161_v);
            } else {
                this.func_70107_b(this.field_70165_t, (float)rayTrace.func_178782_a().func_177956_o() + 1.0625f, this.field_70161_v);
            }
            for (EntityPlayer entityPlayer : ((WorldServer)this.field_70170_p).func_73039_n().getTrackingPlayers((Entity)this)) {
                ((EntityPlayerMP)entityPlayer).field_71135_a.func_147359_a((Packet)new SPacketEntityTeleport((Entity)this));
            }
        }
    }

    public void damageEntityLivingBaseNearby(double radius) {
        AxisAlignedBB region = new AxisAlignedBB(this.field_70165_t - radius, this.field_70163_u - 0.5, this.field_70161_v - radius, this.field_70165_t + radius, Double.POSITIVE_INFINITY, this.field_70161_v + radius);
        List entities = this.field_70170_p.func_72839_b((Entity)this, region);
        double radiusSq = radius * radius;
        for (Entity entity : entities) {
            if (!(entity instanceof EntityLivingBase) || !(this.func_70068_e(entity) < radiusSq) || this.caster instanceof EntityBarako && entity instanceof LeaderSunstrikeImmune || this.caster instanceof EntityPlayer && entity == this.caster) continue;
            entity.func_70097_a(DamageSource.field_76370_b, 4.5f);
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.caster), 4.5f);
            entity.func_70015_d(5);
        }
    }

    private void smolder() {
        if (this.field_70146_Z.nextFloat() < 0.1f) {
            int amount = this.field_70146_Z.nextInt(2) + 1;
            while (amount-- > 0) {
                float theta = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                float r = this.field_70146_Z.nextFloat() * 0.7f;
                float x = r * MathHelper.func_76134_b((float)theta);
                float z = r * MathHelper.func_76126_a((float)theta);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (double)x, this.field_70163_u + 0.1, this.field_70161_v + (double)z, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    private void spawnExplosionParticles(int amount) {
        int i;
        for (i = 0; i < amount; ++i) {
            float velocity = 0.1f;
            float yaw = (float)i * ((float)Math.PI * 2 / (float)amount);
            float vy = this.field_70146_Z.nextFloat() * 0.08f;
            float vx = 0.1f * MathHelper.func_76134_b((float)yaw);
            float vz = 0.1f * MathHelper.func_76126_a((float)yaw);
            this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t, this.field_70163_u + 0.1, this.field_70161_v, (double)vx, (double)vy, (double)vz, new int[0]);
        }
        for (i = 0; i < amount / 2; ++i) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.LAVA, this.field_70165_t, this.field_70163_u + 0.1, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public void onSummon() {
        this.setVariant(this.field_70146_Z.nextLong());
    }

    private RayTraceResult rayTrace(EntitySunstrike entity) {
        Vec3d startPos = new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        Vec3d endPos = new Vec3d(entity.field_70165_t, 0.0, entity.field_70161_v);
        return entity.field_70170_p.func_147447_a(startPos, endPos, false, true, true);
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("strikeTime", this.strikeTime);
        compound.func_74772_a("variant", this.getVariant());
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.setStrikeTime(compound.func_74762_e("strikeTime"));
        this.setVariant(compound.func_74763_f("variant"));
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.strikeTime);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.setStrikeTime(buffer.readInt());
    }
}

