/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.barakoa;

import com.bobmowzie.mowziesmobs.client.model.tools.ControlledAnimation;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationActivateAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationAttackAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationBlockAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationDieAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationProjectileAttackAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationTakeDamage;
import com.bobmowzie.mowziesmobs.server.ai.animation.EntityAIAvoidEntity;
import com.bobmowzie.mowziesmobs.server.entity.EntityDart;
import com.bobmowzie.mowziesmobs.server.entity.EntitySunstrike;
import com.bobmowzie.mowziesmobs.server.entity.LeaderSunstrikeImmune;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarako;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.MaskType;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.Random;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public abstract class EntityBarakoa
extends MowzieEntity
implements IRangedAttackMob,
LeaderSunstrikeImmune {
    public static final Animation DIE_ANIMATION = Animation.create((int)70);
    public static final Animation HURT_ANIMATION = Animation.create((int)10);
    public static final Animation ATTACK_ANIMATION = Animation.create((int)19);
    public static final Animation PROJECTILE_ATTACK_ANIMATION = Animation.create((int)20);
    public static final Animation IDLE_ANIMATION = Animation.create((int)35);
    public static final Animation ACTIVATE_ANIMATION = Animation.create((int)25);
    public static final Animation BLOCK_ANIMATION = Animation.create((int)10);
    private static final DataParameter<Boolean> DANCING = EntityDataManager.func_187226_a(EntityBarakoa.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> MASK = EntityDataManager.func_187226_a(EntityBarakoa.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> WEAPON = EntityDataManager.func_187226_a(EntityBarakoa.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> ACTIVE = EntityDataManager.func_187226_a(EntityBarakoa.class, (DataSerializer)DataSerializers.field_187198_h);
    public ControlledAnimation doWalk = new ControlledAnimation(3);
    public ControlledAnimation dancing = new ControlledAnimation(7);
    private boolean circleDirection = true;
    protected int circleTick = 0;
    protected boolean attacking = false;
    private int timeSinceAttack = 0;
    private int cryDelay = -1;
    private int danceTimer = 0;
    private int ticksWithoutTarget;
    public int timeUntilDeath = -1;

    public EntityBarakoa(World world) {
        super(world);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, new AnimationActivateAI<EntityBarakoa>(this, ACTIVATE_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationDieAI<EntityBarakoa>(this));
        this.field_70714_bg.func_75776_a(1, new EntityAIAvoidEntity<EntitySunstrike>(this, EntitySunstrike.class, EntitySunstrike::isStriking, 3.0f, 0.7f));
        this.field_70714_bg.func_75776_a(2, new AnimationBlockAI<EntityBarakoa>(this, BLOCK_ANIMATION));
        this.field_70714_bg.func_75776_a(2, new AnimationAttackAI<EntityBarakoa>(this, ATTACK_ANIMATION, MMSounds.ENTITY_BARAKOA_SWING, null, 1.0f, 3.0f, 1.0f, 9));
        this.field_70714_bg.func_75776_a(2, new AnimationProjectileAttackAI<EntityBarakoa>(this, PROJECTILE_ATTACK_ANIMATION, 9, MMSounds.ENTITY_BARAKOA_BLOWDART));
        this.field_70714_bg.func_75776_a(3, new AnimationTakeDamage<EntityBarakoa>(this));
        this.field_70714_bg.func_75776_a(4, new AnimationAI<EntityBarakoa>(this, IDLE_ANIMATION));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.5, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.4));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.setMask(MaskType.from(MathHelper.func_76136_a((Random)this.field_70146_Z, (int)1, (int)4)));
        this.field_70138_W = 1.0f;
        this.circleTick += this.field_70146_Z.nextInt(200);
        this.frame += this.field_70146_Z.nextInt(50);
        this.field_70728_aV = 8;
        this.active = true;
    }

    @Override
    public int getAttack() {
        return this.getMask() == MaskType.FURY ? 6 : 4;
    }

    @Override
    public Animation getDeathAnimation() {
        return DIE_ANIMATION;
    }

    @Override
    public Animation getHurtAnimation() {
        return HURT_ANIMATION;
    }

    protected SoundEvent func_184639_G() {
        if (!this.active || this.danceTimer != 0 || this.getEntitiesNearby(EntityBarakoa.class, 8.0, 3.0, 8.0, 8.0).isEmpty() && this.getEntitiesNearby(EntityBarako.class, 8.0, 3.0, 8.0, 8.0).isEmpty() && this.getEntitiesNearby(EntityPlayer.class, 8.0, 3.0, 8.0, 8.0).isEmpty()) {
            return null;
        }
        if (this.func_70638_az() == null) {
            int i = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)0, (int)11);
            if (i < MMSounds.ENTITY_BARAKOA_TALK.length) {
                this.func_184185_a(MMSounds.ENTITY_BARAKOA_TALK[i], 1.0f, 1.5f);
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, IDLE_ANIMATION);
            }
        } else {
            int i = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)0, (int)7);
            if (i < MMSounds.ENTITY_BARAKOA_ANGRY.length) {
                this.func_184185_a(MMSounds.ENTITY_BARAKOA_ANGRY[i], 1.0f, 1.6f);
            }
        }
        return null;
    }

    protected SoundEvent func_184601_bQ() {
        return this.active ? MMSounds.ENTITY_BARAKOA_HURT : null;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
    }

    public boolean func_70652_k(Entity entity) {
        return super.func_70652_k(entity);
    }

    protected void updateAttackAI() {
        if (this.timeSinceAttack < 80) {
            ++this.timeSinceAttack;
        }
        if (this.func_70638_az() != null) {
            if (this.targetDistance > 7.0f) {
                this.func_70661_as().func_75492_a(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, 0.6);
            } else if (!this.attacking) {
                this.updateCircling();
            }
            if (this.field_70146_Z.nextInt(80) == 0 && this.timeSinceAttack == 80) {
                this.attacking = true;
                if (this.getAnimation() == NO_ANIMATION && this.getWeapon() == 0) {
                    this.func_70661_as().func_75497_a((Entity)this.func_70638_az(), 0.5);
                }
            }
            if (this.attacking && this.getAnimation() == NO_ANIMATION) {
                if (this.targetDistance <= 3.0f && this.getWeapon() == 0) {
                    this.attacking = false;
                    this.timeSinceAttack = 0;
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, ATTACK_ANIMATION);
                }
                if (this.getWeapon() == 1) {
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, PROJECTILE_ATTACK_ANIMATION);
                }
            }
        } else {
            this.attacking = false;
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData data) {
        if (this.canHoldVaryingWeapons()) {
            this.setWeapon(this.field_70146_Z.nextInt(3) == 0 ? 1 : 0);
        }
        return super.func_180482_a(difficulty, data);
    }

    protected boolean canHoldVaryingWeapons() {
        return true;
    }

    protected void updateCircling() {
        if (this.field_70146_Z.nextInt(200) == 0) {
            boolean bl = this.circleDirection = !this.circleDirection;
        }
        this.circleTick = this.circleDirection ? ++this.circleTick : --this.circleTick;
        if (!this.attacking && this.targetDistance < 5.0f) {
            this.circleEntity((Entity)this.func_70638_az(), 7.0f, 0.3f, true, this.circleTick, 0.0f, 1.75f);
        } else {
            this.circleEntity((Entity)this.func_70638_az(), 7.0f, 0.3f, true, this.circleTick, 0.0f, 1.0f);
        }
        this.attacking = false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.active && !this.getActive()) {
            this.setActive(true);
        }
        this.active = this.getActive();
        if (!this.active) {
            this.func_70661_as().func_75499_g();
            this.field_70761_aq = this.field_70177_z = this.field_70126_B;
            if (this.field_70122_E && this.getAnimation() == NO_ANIMATION) {
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, ACTIVATE_ANIMATION);
                this.func_184185_a(MMSounds.ENTITY_BARAKOA_EMERGE, 1.0f, 1.0f);
            }
            return;
        }
        this.updateAttackAI();
        if (this.getAnimation() != NO_ANIMATION) {
            this.func_70661_as().func_75499_g();
        }
        if (this.getDancing()) {
            this.setDancing(false);
            ++this.danceTimer;
        }
        if (this.getAnimation() == NO_ANIMATION || this.getAnimation() == IDLE_ANIMATION) {
            this.doWalk.increaseTimer();
        } else {
            this.doWalk.decreaseTimer();
        }
        if (this.danceTimer != 0 && this.danceTimer != 30) {
            ++this.danceTimer;
            this.dancing.increaseTimer();
        } else {
            this.danceTimer = 0;
            this.dancing.decreaseTimer();
        }
        if (!this.field_70170_p.field_72995_K && this.getAnimation() == NO_ANIMATION && this.danceTimer == 0 && this.field_70146_Z.nextInt(800) == 0) {
            this.setDancing(true);
            this.func_184185_a(MMSounds.ENTITY_BARAKOA_BATTLECRY_2, 1.2f, 1.3f);
        }
        if (this.getAnimation() != NO_ANIMATION) {
            this.danceTimer = 0;
        }
        if (this.cryDelay > -1) {
            --this.cryDelay;
        }
        if (this.cryDelay == 0) {
            this.func_184185_a(MMSounds.ENTITY_BARAKOA_BATTLECRY, 1.5f, 1.5f);
        }
        if (this.func_70638_az() != null && this.ticksWithoutTarget > 3) {
            this.cryDelay = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-15, (int)30);
        }
        if (this.getAnimation() == ATTACK_ANIMATION && this.getAnimationTick() == 5) {
            this.func_184185_a(MMSounds.ENTITY_BARAKOA_SHOUT, 1.0f, 1.1f);
        }
        if (this.getAnimation() == PROJECTILE_ATTACK_ANIMATION && this.getAnimationTick() == 1) {
            this.func_184185_a(MMSounds.ENTITY_BARAKOA_INHALE, 0.7f, 1.2f);
        }
        this.ticksWithoutTarget = this.func_70638_az() == null ? ++this.ticksWithoutTarget : 0;
        if (this.timeUntilDeath > 0) {
            --this.timeUntilDeath;
        } else if (this.timeUntilDeath == 0) {
            this.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), this.func_110143_aJ());
        }
    }

    @Override
    protected void onAnimationFinish(Animation animation) {
        if (animation == ACTIVATE_ANIMATION) {
            this.setActive(true);
            this.active = true;
        }
    }

    protected SoundEvent func_184615_bR() {
        return MMSounds.ENTITY_BARAKOA_DIE;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DANCING, (Object)false);
        this.func_184212_Q().func_187214_a(MASK, (Object)0);
        this.func_184212_Q().func_187214_a(WEAPON, (Object)0);
        this.func_184212_Q().func_187214_a(ACTIVE, (Object)true);
    }

    public boolean getDancing() {
        return (Boolean)this.func_184212_Q().func_187225_a(DANCING);
    }

    public void setDancing(boolean dancing) {
        this.func_184212_Q().func_187227_b(DANCING, (Object)dancing);
    }

    public MaskType getMask() {
        return MaskType.from((Integer)this.func_184212_Q().func_187225_a(MASK));
    }

    public void setMask(MaskType type) {
        this.func_184212_Q().func_187227_b(MASK, (Object)type.ordinal());
        this.func_70105_a(type.entityWidth, type.entityHeight);
    }

    public int getWeapon() {
        return (Integer)this.func_184212_Q().func_187225_a(WEAPON);
    }

    public void setWeapon(int type) {
        this.func_184212_Q().func_187227_b(WEAPON, (Object)type);
    }

    public boolean getActive() {
        return (Boolean)this.func_184212_Q().func_187225_a(ACTIVE);
    }

    public void setActive(boolean active) {
        this.func_184212_Q().func_187227_b(ACTIVE, (Object)active);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("mask", this.getMask().ordinal());
        compound.func_74768_a("weapon", this.getWeapon());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setMask(MaskType.from(compound.func_74762_e("mask")));
        this.setWeapon(compound.func_74762_e("weapon"));
    }

    public void func_82196_d(EntityLivingBase target, float p_82196_2_) {
        EntityDart dart = new EntityDart(this.field_70170_p, (EntityLivingBase)this);
        double dx = target.field_70165_t - this.field_70165_t;
        double dy = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - ((EntityArrow)dart).field_70163_u;
        double dz = target.field_70161_v - this.field_70161_v;
        double dist = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        dart.func_70186_c(dx, dy + dist * 0.2, dz, 1.6f, 1.0f);
        int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)this.func_184586_b(EnumHand.MAIN_HAND));
        int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)this.func_184586_b(EnumHand.MAIN_HAND));
        dart.func_70239_b((double)(p_82196_2_ * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.func_175659_aa().func_151525_a() * 0.11f));
        if (i > 0) {
            dart.func_70239_b(dart.func_70242_d() + (double)i * 0.5 + 0.5);
        }
        if (j > 0) {
            dart.func_70240_a(j);
        }
        this.field_70170_p.func_72838_d((Entity)dart);
        this.attacking = false;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        Entity entity = source.func_76346_g();
        if (this.getMask().canBlock && entity instanceof EntityLivingBase && (this.getAnimation() == NO_ANIMATION || this.getAnimation() == HURT_ANIMATION || this.getAnimation() == BLOCK_ANIMATION)) {
            this.blockingEntity = (EntityLivingBase)entity;
            this.func_184185_a(SoundEvents.field_187927_ha, 0.3f, 1.5f);
            AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, BLOCK_ANIMATION);
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    public void func_70645_a(DamageSource source) {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot") && this.field_70146_Z.nextInt(12) == 0) {
            this.func_145779_a((Item)ItemHandler.INSTANCE.barakoaMasks.get((Object)this.getMask()), 1);
        }
        super.func_70645_a(source);
    }

    public boolean func_70067_L() {
        return this.active;
    }

    public void func_180430_e(float distance, float damageMultipler) {
        if (this.active) {
            super.func_180430_e(distance, damageMultipler);
        }
    }

    public Animation[] getAnimations() {
        return new Animation[]{DIE_ANIMATION, HURT_ANIMATION, ATTACK_ANIMATION, PROJECTILE_ATTACK_ANIMATION, BLOCK_ANIMATION, IDLE_ANIMATION, ACTIVATE_ANIMATION};
    }

    public boolean isBarakoDevoted() {
        return true;
    }

    public int randomizeWeapon() {
        return this.field_70146_Z.nextInt(3) == 0 ? 1 : 0;
    }
}

