/*
 * Decompiled with CFR 0.152.
 */
package com.dmonsters.blocks;

import com.dmonsters.main.MainMod;
import com.dmonsters.main.ModBlocks;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MeshFence
extends Block {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    protected static final AxisAlignedBB[] BOUNDING_BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.375, 0.625, 1.0, 0.625), new AxisAlignedBB(0.0, 0.0, 0.375, 0.625, 1.0, 1.0), new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.625, 1.0, 0.625), new AxisAlignedBB(0.0, 0.0, 0.0, 0.625, 1.0, 1.0), new AxisAlignedBB(0.375, 0.0, 0.375, 1.0, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625), new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 1.0), new AxisAlignedBB(0.375, 0.0, 0.0, 1.0, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.625), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};
    public static final AxisAlignedBB PILLAR_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.5, 0.625);
    public static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.375, 0.0, 0.625, 0.625, 1.5, 1.0);
    public static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.375, 0.375, 1.5, 0.625);
    public static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.5, 0.375);
    public static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.625, 0.0, 0.375, 1.0, 1.5, 0.625);

    public MeshFence() {
        super(Material.field_151576_e);
        this.func_149663_c("dmonsters.meshFence");
        this.setRegistryName("meshFence");
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock((Block)this), (ResourceLocation)this.getRegistryName());
        this.func_149647_a(MainMod.MOD_CREATIVETAB);
        this.func_149711_c(5.0f);
        this.func_149752_b(5.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (!worldIn.field_72995_K) {
            Boolean distReason = false;
            BlockPos neighborPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1);
            if (worldIn.func_180495_p(neighborPos).func_177230_c() == ModBlocks.meshFence || worldIn.func_180495_p(neighborPos).func_177230_c() == ModBlocks.meshFencePole) {
                if (this.checkIfCanBuildInDirection(0, 0, -1, 8, pos, (IBlockAccess)worldIn)) {
                    return this.func_176223_P();
                }
                distReason = true;
            }
            if (worldIn.func_180495_p(neighborPos = new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p())).func_177230_c() == ModBlocks.meshFence || worldIn.func_180495_p(neighborPos).func_177230_c() == ModBlocks.meshFencePole) {
                if (this.checkIfCanBuildInDirection(1, 0, 0, 8, pos, (IBlockAccess)worldIn)) {
                    return this.func_176223_P();
                }
                distReason = true;
            }
            if (worldIn.func_180495_p(neighborPos = new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p())).func_177230_c() == ModBlocks.meshFence || worldIn.func_180495_p(neighborPos).func_177230_c() == ModBlocks.meshFencePole) {
                if (this.checkIfCanBuildInDirection(-1, 0, 0, 8, pos, (IBlockAccess)worldIn)) {
                    return this.func_176223_P();
                }
                distReason = true;
            }
            if (worldIn.func_180495_p(neighborPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1)).func_177230_c() == ModBlocks.meshFence || worldIn.func_180495_p(neighborPos).func_177230_c() == ModBlocks.meshFencePole) {
                if (this.checkIfCanBuildInDirection(0, 0, 1, 8, pos, (IBlockAccess)worldIn)) {
                    return this.func_176223_P();
                }
                distReason = true;
            }
            if (!distReason.booleanValue()) {
                this.showConsoleText("msg.dmonsters.meshFence.error", placer);
            } else {
                this.showConsoleText("msg.dmonsters.meshFence.tooFarFromPole", placer);
            }
            return Blocks.field_150350_a.func_176223_P();
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        if (this.checkIfCanBuildInDirection(0, 0, -1, 8, pos, (IBlockAccess)worldIn)) {
            return;
        }
        if (this.checkIfCanBuildInDirection(1, 0, 0, 8, pos, (IBlockAccess)worldIn)) {
            return;
        }
        if (this.checkIfCanBuildInDirection(-1, 0, 0, 8, pos, (IBlockAccess)worldIn)) {
            return;
        }
        if (this.checkIfCanBuildInDirection(0, 0, 1, 8, pos, (IBlockAccess)worldIn)) {
            return;
        }
        worldIn.func_175655_b(pos, true);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn) {
        state = state.func_185899_b((IBlockAccess)worldIn, pos);
        MeshFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)PILLAR_AABB);
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            MeshFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            MeshFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            MeshFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            MeshFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_AABB);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = this.func_176221_a(state, source, pos);
        return BOUNDING_BOXES[MeshFence.getBoundingBoxIdx(state)];
    }

    private static int getBoundingBoxIdx(IBlockState state) {
        int i = 0;
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            i |= 1 << EnumFacing.NORTH.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            i |= 1 << EnumFacing.EAST.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            i |= 1 << EnumFacing.SOUTH.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            i |= 1 << EnumFacing.WEST.func_176736_b();
        }
        return i;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean south = false;
        BlockPos neighborPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1);
        boolean north = worldIn.func_180495_p(neighborPos).func_177230_c() == ModBlocks.meshFence || worldIn.func_180495_p(neighborPos).func_177230_c() == ModBlocks.meshFencePole;
        neighborPos = new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p());
        boolean east = worldIn.func_180495_p(neighborPos).func_177230_c() == ModBlocks.meshFence || worldIn.func_180495_p(neighborPos).func_177230_c() == ModBlocks.meshFencePole;
        neighborPos = new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p());
        boolean west = worldIn.func_180495_p(neighborPos).func_177230_c() == ModBlocks.meshFence || worldIn.func_180495_p(neighborPos).func_177230_c() == ModBlocks.meshFencePole;
        neighborPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1);
        south = worldIn.func_180495_p(neighborPos).func_177230_c() == ModBlocks.meshFence || worldIn.func_180495_p(neighborPos).func_177230_c() == ModBlocks.meshFencePole;
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(north)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(east)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(west)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(south));
    }

    private boolean checkIfCanBuildInDirection(int x, int y, int z, int dist, BlockPos pos, IBlockAccess worldIn) {
        BlockPos neighborPos = pos;
        for (int i = 0; i < dist; ++i) {
            if (worldIn.func_180495_p(neighborPos = new BlockPos(neighborPos.func_177958_n() + x, neighborPos.func_177956_o() + y, neighborPos.func_177952_p() + z)).func_177230_c() == ModBlocks.meshFencePole) {
                return true;
            }
            if (worldIn.func_180495_p(neighborPos).func_177230_c() == ModBlocks.meshFence) continue;
            return false;
        }
        return false;
    }

    private void showConsoleText(String path, EntityLivingBase entity) {
        Style red = new Style().func_150238_a(TextFormatting.DARK_RED);
        TextComponentTranslation test = new TextComponentTranslation(path, new Object[0]);
        test.func_150255_a(red);
        entity.func_145747_a((ITextComponent)test);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, WEST, SOUTH});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }
}

