/*
 * Decompiled with CFR 0.152.
 */
package com.dmonsters.entity;

import com.dmonsters.ai.EntityAIClimberAttack;
import com.dmonsters.main.ModSounds;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityClimber
extends EntityMob {
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntityClimber.class, (DataSerializer)DataSerializers.field_187191_a);
    public static final ResourceLocation LOOT = new ResourceLocation("dmonsters", "climber");

    public EntityClimber(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 1.95f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIClimberAttack(this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new AISpiderTarget<EntityPlayer>(this, EntityPlayer.class));
        this.field_70715_bh.func_75776_a(3, new AISpiderTarget<EntityIronGolem>(this, EntityIronGolem.class));
    }

    public double func_70042_X() {
        return this.field_70131_O * 0.5f;
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(24.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.1);
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.CLIMBER_DEATH;
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.CLIMBER_AMBIENT;
    }

    protected SoundEvent func_184601_bQ() {
        return ModSounds.CLIMBER_HURT;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    public void func_70636_d() {
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K) {
            BlockPos blockpos;
            float f = this.func_70013_c(1.0f);
            BlockPos blockPos = blockpos = this.func_184187_bx() instanceof EntityBoat ? new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u), this.field_70161_v).func_177984_a() : new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u), this.field_70161_v);
            if (f > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_175678_i(blockpos)) {
                this.func_70015_d(8);
            }
        }
        super.func_70636_d();
    }

    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            this.func_184185_a(ModSounds.CLIMBER_ATTACK, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public void func_70110_aj() {
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    public int func_70641_bl() {
        return 5;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return potioneffectIn.func_188419_a() == MobEffects.field_76436_u ? false : super.func_70687_e(potioneffectIn);
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        Potion potion;
        if ((livingdata = super.func_180482_a(difficulty, livingdata)) == null) {
            livingdata = new GroupData();
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && this.field_70170_p.field_73012_v.nextFloat() < 0.1f * difficulty.func_180170_c()) {
                ((GroupData)livingdata).setRandomEffect(this.field_70170_p.field_73012_v);
            }
        }
        if (livingdata instanceof GroupData && (potion = ((GroupData)livingdata).effect) != null) {
            this.func_70690_d(new PotionEffect(potion, Integer.MAX_VALUE));
        }
        return livingdata;
    }

    public static class GroupData
    implements IEntityLivingData {
        public Potion effect;

        public void setRandomEffect(Random rand) {
            int i = rand.nextInt(5);
            if (i <= 1) {
                this.effect = MobEffects.field_76424_c;
            } else if (i <= 2) {
                this.effect = MobEffects.field_76420_g;
            } else if (i <= 3) {
                this.effect = MobEffects.field_76428_l;
            } else if (i <= 4) {
                this.effect = MobEffects.field_76441_p;
            }
        }
    }

    static class AISpiderTarget<T extends EntityLivingBase>
    extends EntityAINearestAttackableTarget<T> {
        public AISpiderTarget(EntityClimber spider, Class<T> classTarget) {
            super((EntityCreature)spider, classTarget, true);
        }

        public boolean func_75250_a() {
            return super.func_75250_a();
        }
    }

    static class AISpiderAttack
    extends EntityAIAttackMelee {
        public AISpiderAttack(EntityClimber spider) {
            super((EntityCreature)spider, 1.0, true);
        }

        public boolean func_75253_b() {
            return super.func_75253_b();
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 4.0f + attackTarget.field_70130_N;
        }
    }
}

