/*
 * Decompiled with CFR 0.152.
 */
package com.dmonsters.network;

import com.dmonsters.main.ModSounds;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketClientFXUpdate
implements IMessage {
    private BlockPos blockPos;
    private Type FXtype;

    public PacketClientFXUpdate() {
    }

    public PacketClientFXUpdate(BlockPos pos, Type type) {
        this.blockPos = pos;
        this.FXtype = type;
    }

    public void fromBytes(ByteBuf buf) {
        this.blockPos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.FXtype = Type.fromInteger(buf.readInt());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.blockPos.func_177958_n());
        buf.writeInt(this.blockPos.func_177956_o());
        buf.writeInt(this.blockPos.func_177952_p());
        buf.writeInt(this.FXtype.ordinal());
    }

    public static class Handler
    implements IMessageHandler<PacketClientFXUpdate, IMessage> {
        public IMessage onMessage(PacketClientFXUpdate message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketClientFXUpdate message, MessageContext ctx) {
            switch (message.FXtype) {
                case SOULEYE: {
                    this.SoulEye(message, ctx);
                    break;
                }
                case DUMP: {
                    this.Dump(message, ctx);
                    break;
                }
                case WOMAN_HEART: {
                    this.WomanHeart(message, ctx);
                    break;
                }
            }
        }

        private void SoulEye(PacketClientFXUpdate message, MessageContext ctx) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            BlockPos pos = message.blockPos;
            world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), ModSounds.BLOCK_SOULEYE_KILL, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            Random rnd = new Random();
            for (int i = 0; i < 15; ++i) {
                double motionX = rnd.nextGaussian() * 0.001;
                double motionY = Math.abs(rnd.nextGaussian() * 0.08);
                double motionZ = rnd.nextGaussian() * 0.001;
                float randX = rnd.nextFloat();
                float randY = rnd.nextFloat();
                float randZ = rnd.nextFloat();
                world.func_175688_a(EnumParticleTypes.FLAME, (double)((float)pos.func_177958_n() + randX), (double)((float)pos.func_177956_o() + 0.5f + randY), (double)((float)pos.func_177952_p() + randZ), motionX, motionY, motionZ, new int[0]);
            }
        }

        private void Dump(PacketClientFXUpdate message, MessageContext ctx) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            BlockPos pos = message.blockPos;
            world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), ModSounds.DUMP_MAKE, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        }

        private void WomanHeart(PacketClientFXUpdate message, MessageContext ctx) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            BlockPos pos = message.blockPos;
            world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), ModSounds.MAIDEN_ATTACK, SoundCategory.BLOCKS, 0.25f, 1.0f, false);
            Random rnd = new Random();
            for (int i = 0; i < 8; ++i) {
                double motionX = rnd.nextGaussian() * 0.001;
                double motionY = Math.abs(rnd.nextGaussian() * 0.08);
                double motionZ = rnd.nextGaussian() * 0.001;
                float randX = rnd.nextFloat();
                float randY = rnd.nextFloat();
                float randZ = rnd.nextFloat();
                world.func_175688_a(EnumParticleTypes.SPELL_INSTANT, (double)((float)pos.func_177958_n() + randX), (double)((float)pos.func_177956_o() + 0.5f + randY), (double)((float)pos.func_177952_p() + randZ), motionX, motionY, motionZ, new int[0]);
            }
        }
    }

    public static enum Type {
        SOULEYE,
        DUMP,
        WOMAN_HEART;


        public static Type fromInteger(int x) {
            switch (x) {
                case 0: {
                    return SOULEYE;
                }
                case 1: {
                    return DUMP;
                }
                case 2: {
                    return WOMAN_HEART;
                }
            }
            return null;
        }
    }
}

