/*
 * Decompiled with CFR 0.152.
 */
package duelmonster.superminer;

import duelmonster.superminer.SM_Proxy;
import duelmonster.superminer.events.PlayerEvents;
import duelmonster.superminer.intergration.ModSupport;
import duelmonster.superminer.keys.KeyBindings;
import duelmonster.superminer.keys.KeyInputHandler;
import duelmonster.superminer.submods.Captivator;
import duelmonster.superminer.submods.Cropinator;
import duelmonster.superminer.submods.Excavator;
import duelmonster.superminer.submods.Illuminator;
import duelmonster.superminer.submods.Lumbinator;
import duelmonster.superminer.submods.Shaftanator;
import duelmonster.superminer.submods.Substitutor;
import duelmonster.superminer.submods.Veinator;
import java.io.File;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="superminer_core", name="SuperMiner", version="[1.10.2]-2.1.4.090", acceptedMinecraftVersions="[1.10.2]", dependencies="after:*", guiFactory="duelmonster.superminer.config.SMGuiFactory", updateJSON="http://www.duelmonster.talktalk.net/Minecraft/SuperMiner/forge_update.json")
public class SuperMiner_Core {
    public static final String MODID = "superminer_core";
    public static final String MODName = "SuperMiner";
    public static final String MODVERSION = "2.1.4.090";
    public static final String MCVERSION = "[1.10.2]";
    public static final String VERSION = "[1.10.2]-2.1.4.090";
    public static final String VC_URL = "http://www.duelmonster.talktalk.net/Minecraft/SuperMiner/mod_version.json";
    public static final String FVC_URL = "http://www.duelmonster.talktalk.net/Minecraft/SuperMiner/forge_update.json";
    public static Configuration configFile;
    @SidedProxy(clientSide="duelmonster.superminer.SM_Client", serverSide="duelmonster.superminer.SM_Proxy")
    public static SM_Proxy proxy;
    private static boolean bIsClientTicking;
    private static boolean bIsPlayerTicking;
    private static boolean bIsServerTicking;
    private static boolean bIsWorldTicking;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        configFile = new Configuration(new File(e.getModConfigurationDirectory() + "/SuperMiner.cfg"), MODVERSION);
        if (FMLCommonHandler.instance().getSide().isClient()) {
            MinecraftForge.EVENT_BUS.register((Object)new PlayerEvents());
            MinecraftForge.EVENT_BUS.register((Object)new KeyInputHandler());
            KeyBindings.init();
        }
        proxy.registerEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLInterModComms.sendRuntimeMessage((Object)MODID, (String)"VersionChecker", (String)"addVersionCheck", (String)VC_URL);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.loadConfigData();
        ModSupport.addModSupport();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals(MODID)) {
            configFile.save();
            this.loadConfigData();
        }
    }

    private void loadConfigData() {
        Captivator.syncConfig();
        Cropinator.syncConfig();
        Excavator.syncConfig();
        Illuminator.syncConfig();
        Lumbinator.syncConfig();
        Shaftanator.syncConfig();
        Substitutor.syncConfig();
        Veinator.syncConfig();
    }

    public static boolean isMCTicking() {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            return bIsClientTicking || bIsPlayerTicking || bIsServerTicking || bIsWorldTicking;
        }
        return bIsPlayerTicking || bIsWorldTicking;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void tickEvent(TickEvent.ClientTickEvent event) {
        if (TickEvent.Phase.START.equals((Object)event.phase)) {
            bIsClientTicking = true;
        } else if (TickEvent.Phase.END.equals((Object)event.phase)) {
            bIsClientTicking = false;
        }
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.PlayerTickEvent event) {
        if (TickEvent.Phase.START.equals((Object)event.phase)) {
            bIsPlayerTicking = true;
        } else if (TickEvent.Phase.END.equals((Object)event.phase)) {
            bIsPlayerTicking = false;
        }
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.ServerTickEvent event) {
        if (TickEvent.Phase.START.equals((Object)event.phase)) {
            bIsServerTicking = true;
        } else if (TickEvent.Phase.END.equals((Object)event.phase)) {
            bIsServerTicking = false;
        }
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.WorldTickEvent event) {
        if (TickEvent.Phase.START.equals((Object)event.phase)) {
            bIsWorldTicking = true;
        } else if (TickEvent.Phase.END.equals((Object)event.phase)) {
            bIsWorldTicking = false;
        }
    }

    static {
        bIsClientTicking = false;
        bIsPlayerTicking = false;
        bIsServerTicking = false;
        bIsWorldTicking = false;
    }
}

