/*
 * Decompiled with CFR 0.152.
 */
package duelmonster.superminer.events;

import duelmonster.superminer.objects.Globals;
import duelmonster.superminer.submods.Captivator;
import duelmonster.superminer.submods.Cropinator;
import duelmonster.superminer.submods.Excavator;
import duelmonster.superminer.submods.Illuminator;
import duelmonster.superminer.submods.Lumbinator;
import duelmonster.superminer.submods.Shaftanator;
import duelmonster.superminer.submods.Substitutor;
import duelmonster.superminer.submods.Veinator;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

public class PlayerEvents {
    public static String sLatestVersion = "";
    private static boolean bIsPlayerInWorld = false;

    public static boolean IsPlayerInWorld() {
        return bIsPlayerInWorld;
    }

    @SubscribeEvent
    public void onPlayerConnectedToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        this.doEventStuff();
    }

    @SubscribeEvent
    public void onPlayerDisconnectedFromServer(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        bIsPlayerInWorld = false;
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        this.doEventStuff();
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedOutEvent event) {
        bIsPlayerInWorld = false;
    }

    private void doEventStuff() {
        if (!bIsPlayerInWorld) {
            bIsPlayerInWorld = true;
            if (sLatestVersion.isEmpty()) {
                sLatestVersion = Globals.getLatestVerion("http://www.duelmonster.talktalk.net/Minecraft/SuperMiner/mod_version.json");
            }
            if (!sLatestVersion.isEmpty() && !sLatestVersion.equalsIgnoreCase("[1.10.2]-2.1.4.090")) {
                Globals.NotifyClient("\u00a77" + Globals.localize("superminer.version.update") + ": v\u00a7a" + sLatestVersion);
            }
            Captivator.bShouldSyncSettings = true;
            Cropinator.bShouldSyncSettings = true;
            Excavator.bShouldSyncSettings = true;
            Illuminator.bShouldSyncSettings = true;
            Lumbinator.bShouldSyncSettings = true;
            Shaftanator.bShouldSyncSettings = true;
            Substitutor.bShouldSyncSettings = true;
            Veinator.bShouldSyncSettings = true;
        }
    }
}

