/*
 * Decompiled with CFR 0.152.
 */
package duelmonster.superminer.objects;

import duelmonster.superminer.SuperMiner_Core;
import duelmonster.superminer.config.SettingsExcavator;
import duelmonster.superminer.config.SettingsShaftanator;
import duelmonster.superminer.network.packets.IlluminatorPacket;
import duelmonster.superminer.network.packets.SMPacket;
import duelmonster.superminer.objects.Globals;
import duelmonster.superminer.submods.Veinator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class ExcavationHelper {
    private final int SECTION_LIMIT = 4;
    World world;
    EntityPlayerMP player;
    SMPacket oPacket;
    BlockPos oInitialPos = null;
    boolean bLayerOnlyToggled = false;
    EnumFacing sideHit;
    int iBlocksFound = 0;
    int iUnconnectedCount = 0;
    LinkedList<BlockPos> oPositions = new LinkedList();
    int iSpiral = 1;
    boolean bIsExcavating = true;
    int iLowestY = 0;
    int iFeetPos = 0;
    int iLengthStart = 0;
    int iLengthEnd = 0;
    int iWidthStart = 0;
    int iWidthEnd = 0;

    private boolean bAutoIlluminate() {
        return SettingsExcavator.bAutoIlluminate || SettingsShaftanator.bAutoIlluminate;
    }

    private boolean bMineVeins() {
        return SettingsShaftanator.bMineVeins;
    }

    public boolean isExcavating() {
        return this.bIsExcavating;
    }

    public ExcavationHelper(World world, EntityPlayerMP player, SMPacket oPacket) {
        this.world = world;
        this.player = player;
        this.oPacket = oPacket;
        this.oInitialPos = new BlockPos((Vec3i)oPacket.oPos);
        this.bLayerOnlyToggled = oPacket.bLayerOnlyToggled;
        this.sideHit = oPacket.sideHit;
    }

    public boolean ExcavateSection() {
        if (!this.oPositions.isEmpty()) {
            if (!this.bIsExcavating) {
                this.bIsExcavating = true;
            }
            for (int indx = 0; indx <= 4; ++indx) {
                boolean bHarvested;
                if (this.oPositions.isEmpty()) continue;
                BlockPos workingPos = null;
                try {
                    workingPos = this.oPositions.removeFirst();
                }
                catch (NoSuchElementException e) {
                    this.bIsExcavating = false;
                    return false;
                }
                if (workingPos == null || this.world.func_175623_d(workingPos)) continue;
                IBlockState state = this.world.func_180495_p(workingPos);
                Block block = state.func_177230_c();
                if (this.bMineVeins() && Globals.isIdInList(block, Veinator.myGlobals.lBlockIDs)) {
                    SMPacket oVeinPacket = new SMPacket();
                    oVeinPacket.oPos = new BlockPos((Vec3i)workingPos);
                    oVeinPacket.sideHit = this.sideHit;
                    oVeinPacket.block = block;
                    oVeinPacket.metadata = block.func_176201_c(state);
                    oVeinPacket.nanoTime = System.nanoTime();
                    oVeinPacket.flag_rs = block == Blocks.field_150450_ax || block == Blocks.field_150439_ay;
                    oVeinPacket.playerID = this.player.func_145782_y();
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt.func_74773_a("MineVein", oVeinPacket.writePacketData().array());
                    FMLInterModComms.sendRuntimeMessage((Object)"superminer_shaftanator", (String)"superminer_veinator", (String)"MineVein", (NBTTagCompound)nbt);
                    continue;
                }
                while (SuperMiner_Core.isMCTicking()) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException oVeinPacket) {}
                }
                if (this.world.func_175623_d(workingPos) || !(bHarvested = this.player.field_71134_c.func_180237_b(workingPos)) || !this.bAutoIlluminate() || workingPos.func_177956_o() != this.iLowestY) continue;
                IlluminatorPacket iPacket = new IlluminatorPacket();
                iPacket.oPos = new BlockPos((Vec3i)(this.sideHit == EnumFacing.SOUTH ? workingPos.func_177968_d() : (this.sideHit == EnumFacing.NORTH ? workingPos.func_177978_c() : (this.sideHit == EnumFacing.EAST ? workingPos.func_177974_f() : (this.sideHit == EnumFacing.WEST ? workingPos.func_177976_e() : workingPos)))));
                iPacket.playerID = this.player.func_145782_y();
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74773_a("IlluminateShaftData", iPacket.writePacketData().array());
                FMLInterModComms.sendRuntimeMessage((Object)"superminer_shaftanator", (String)"superminer_illuminator", (String)"IlluminateShaft", (NBTTagCompound)nbt);
            }
        }
        if (this.oPositions.isEmpty()) {
            this.bIsExcavating = false;
        }
        return this.bIsExcavating;
    }

    public void getExcavationBlocks() {
        this.oPositions.offer(this.oInitialPos);
        this.iLowestY = this.oInitialPos.func_177956_o();
        this.iBlocksFound = 1;
        boolean bHasConnected = false;
        block0 : switch (this.sideHit) {
            case NORTH: {
                for (int excavateZ = this.oInitialPos.func_177952_p(); excavateZ <= this.oInitialPos.func_177952_p() + SettingsExcavator.iBlockRadius; ++excavateZ) {
                    bHasConnected = false;
                    if (!bHasConnected) {
                        int zOffset;
                        int n = zOffset = excavateZ != this.oInitialPos.func_177952_p() ? -1 : 0;
                        block9: while (zOffset <= 1) {
                            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                                for (int yOffset = !this.bLayerOnlyToggled ? -1 : 0; yOffset <= (!this.bLayerOnlyToggled ? 1 : 0); ++yOffset) {
                                    BlockPos oPos = new BlockPos(this.oInitialPos.func_177958_n() + xOffset, this.oInitialPos.func_177956_o() + yOffset, excavateZ + zOffset);
                                    if (!Globals.checkBlock(this.world.func_180495_p(oPos), this.oPacket, SettingsExcavator.bDetectVariants)) continue;
                                    bHasConnected = true;
                                    break block9;
                                }
                            }
                            ++zOffset;
                        }
                    }
                    if (!bHasConnected || !this.SpiralNorthSouth(excavateZ)) break block0;
                }
                break;
            }
            case SOUTH: {
                for (int excavateZ = this.oInitialPos.func_177952_p(); excavateZ >= this.oInitialPos.func_177952_p() - SettingsExcavator.iBlockRadius; --excavateZ) {
                    bHasConnected = false;
                    if (!bHasConnected) {
                        int zOffset;
                        int n = zOffset = excavateZ != this.oInitialPos.func_177952_p() ? -1 : 0;
                        block13: while (zOffset <= 1) {
                            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                                for (int yOffset = !this.bLayerOnlyToggled ? -1 : 0; yOffset <= (!this.bLayerOnlyToggled ? 1 : 0); ++yOffset) {
                                    BlockPos oPos = new BlockPos(this.oInitialPos.func_177958_n() + xOffset, this.oInitialPos.func_177956_o() + yOffset, excavateZ - zOffset);
                                    if (!Globals.checkBlock(this.world.func_180495_p(oPos), this.oPacket, SettingsExcavator.bDetectVariants)) continue;
                                    bHasConnected = true;
                                    break block13;
                                }
                            }
                            ++zOffset;
                        }
                    }
                    if (!bHasConnected || !this.SpiralNorthSouth(excavateZ)) break block0;
                }
                break;
            }
            case EAST: {
                for (int excavateX = this.oInitialPos.func_177958_n(); excavateX >= this.oInitialPos.func_177958_n() - SettingsExcavator.iBlockRadius; --excavateX) {
                    bHasConnected = false;
                    if (!bHasConnected) {
                        int xOffset;
                        int n = xOffset = excavateX != this.oInitialPos.func_177958_n() ? -1 : 0;
                        block17: while (xOffset <= 1) {
                            for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                                for (int yOffset = !this.bLayerOnlyToggled ? -1 : 0; yOffset <= (!this.bLayerOnlyToggled ? 1 : 0); ++yOffset) {
                                    BlockPos oPos = new BlockPos(excavateX - xOffset, this.oInitialPos.func_177956_o() + yOffset, this.oInitialPos.func_177952_p() + zOffset);
                                    if (!Globals.checkBlock(this.world.func_180495_p(oPos), this.oPacket, SettingsExcavator.bDetectVariants)) continue;
                                    bHasConnected = true;
                                    break block17;
                                }
                            }
                            ++xOffset;
                        }
                    }
                    if (!bHasConnected || !this.SpiralEastWest(excavateX)) break block0;
                }
                break;
            }
            case WEST: {
                for (int excavateX = this.oInitialPos.func_177958_n(); excavateX <= this.oInitialPos.func_177958_n() + SettingsExcavator.iBlockRadius; ++excavateX) {
                    bHasConnected = false;
                    if (!bHasConnected) {
                        int xOffset;
                        int n = xOffset = excavateX != this.oInitialPos.func_177958_n() ? -1 : 0;
                        block21: while (xOffset <= 1) {
                            for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                                for (int yOffset = !this.bLayerOnlyToggled ? -1 : 0; yOffset <= (!this.bLayerOnlyToggled ? 1 : 0); ++yOffset) {
                                    BlockPos oPos = new BlockPos(excavateX + xOffset, this.oInitialPos.func_177956_o() + yOffset, this.oInitialPos.func_177952_p() + zOffset);
                                    if (!Globals.checkBlock(this.world.func_180495_p(oPos), this.oPacket, SettingsExcavator.bDetectVariants)) continue;
                                    bHasConnected = true;
                                    break block21;
                                }
                            }
                            ++xOffset;
                        }
                    }
                    if (!bHasConnected || !this.SpiralEastWest(excavateX)) break block0;
                }
                break;
            }
            case UP: {
                for (int excavateY = this.oInitialPos.func_177956_o(); excavateY >= this.oInitialPos.func_177956_o() - (!this.bLayerOnlyToggled ? SettingsExcavator.iBlockRadius : 0); --excavateY) {
                    bHasConnected = false;
                    if (!bHasConnected) {
                        block25: for (int yOffset = excavateY != this.oInitialPos.func_177956_o() ? -1 : 0; yOffset <= (!this.bLayerOnlyToggled ? 1 : 0); ++yOffset) {
                            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                                    BlockPos oPos = new BlockPos(this.oInitialPos.func_177958_n() + xOffset, excavateY - yOffset, this.oInitialPos.func_177952_p() + zOffset);
                                    if (!Globals.checkBlock(this.world.func_180495_p(oPos), this.oPacket, SettingsExcavator.bDetectVariants)) continue;
                                    bHasConnected = true;
                                    break block25;
                                }
                            }
                        }
                    }
                    if (!bHasConnected || !this.SpiralUpDown(excavateY)) break block0;
                }
                break;
            }
            case DOWN: {
                for (int excavateY = this.oInitialPos.func_177956_o(); excavateY <= this.oInitialPos.func_177956_o() + (!this.bLayerOnlyToggled ? SettingsExcavator.iBlockRadius : 0); ++excavateY) {
                    bHasConnected = false;
                    if (!bHasConnected) {
                        block29: for (int yOffset = excavateY != this.oInitialPos.func_177956_o() ? -1 : 0; yOffset <= (!this.bLayerOnlyToggled ? 1 : 0); ++yOffset) {
                            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                                    BlockPos oPos = new BlockPos(this.oInitialPos.func_177958_n() + xOffset, excavateY - yOffset, this.oInitialPos.func_177952_p() + zOffset);
                                    if (!Globals.checkBlock(this.world.func_180495_p(oPos), this.oPacket, SettingsExcavator.bDetectVariants)) continue;
                                    bHasConnected = true;
                                    break block29;
                                }
                            }
                        }
                    }
                    if (!bHasConnected || !this.SpiralUpDown(excavateY)) break block0;
                }
                break;
            }
        }
    }

    private boolean SpiralNorthSouth(int excavateZ) {
        for (int iSpiral = 1; iSpiral <= SettingsExcavator.iBlockRadius / 2; ++iSpiral) {
            this.iUnconnectedCount = 0;
            for (int xOffset = -iSpiral; xOffset <= iSpiral; ++xOffset) {
                for (int yOffset = !this.bLayerOnlyToggled ? -iSpiral : 0; yOffset <= (!this.bLayerOnlyToggled ? iSpiral : 0); ++yOffset) {
                    for (int zOffset = 0; zOffset <= (excavateZ == this.oInitialPos.func_177952_p() ? 0 : 1); ++zOffset) {
                        BlockPos curPos = new BlockPos(this.oInitialPos.func_177958_n() + xOffset, this.oInitialPos.func_177956_o() + yOffset, excavateZ + (this.sideHit == EnumFacing.NORTH ? -zOffset : zOffset));
                        if (Globals.checkBlock(this.world.func_180495_p(curPos), this.oPacket, SettingsExcavator.bDetectVariants)) {
                            this.AddCoordsToList(curPos);
                        }
                        if (this.iBlocksFound < SettingsExcavator.iBlockLimit) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean SpiralEastWest(int excavateX) {
        for (int iSpiral = 1; iSpiral <= SettingsExcavator.iBlockRadius / 2; ++iSpiral) {
            this.iUnconnectedCount = 0;
            for (int zOffset = -iSpiral; zOffset <= iSpiral; ++zOffset) {
                for (int yOffset = !this.bLayerOnlyToggled ? -iSpiral : 0; yOffset <= (!this.bLayerOnlyToggled ? iSpiral : 0); ++yOffset) {
                    for (int xOffset = 0; xOffset <= (excavateX == this.oInitialPos.func_177958_n() ? 0 : 1); ++xOffset) {
                        BlockPos curPos = new BlockPos(excavateX + (this.sideHit == EnumFacing.EAST ? xOffset : -xOffset), this.oInitialPos.func_177956_o() + yOffset, this.oInitialPos.func_177952_p() + zOffset);
                        if (Globals.checkBlock(this.world.func_180495_p(curPos), this.oPacket, SettingsExcavator.bDetectVariants)) {
                            this.AddCoordsToList(curPos);
                        }
                        if (this.iBlocksFound < SettingsExcavator.iBlockLimit) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean SpiralUpDown(int excavateY) {
        for (int iSpiral = 1; iSpiral <= SettingsExcavator.iBlockRadius / 2; ++iSpiral) {
            this.iUnconnectedCount = 0;
            for (int xOffset = -iSpiral; xOffset <= iSpiral; ++xOffset) {
                for (int zOffset = -iSpiral; zOffset <= iSpiral; ++zOffset) {
                    for (int yOffset = 0; yOffset <= (excavateY == this.oInitialPos.func_177956_o() ? 0 : 1); ++yOffset) {
                        BlockPos curPos = new BlockPos(this.oInitialPos.func_177958_n() + xOffset, excavateY + (this.sideHit == EnumFacing.UP ? yOffset : -yOffset), this.oInitialPos.func_177952_p() + zOffset);
                        if (Globals.checkBlock(this.world.func_180495_p(curPos), this.oPacket, SettingsExcavator.bDetectVariants)) {
                            this.AddCoordsToList(curPos);
                        }
                        if (this.iBlocksFound < SettingsExcavator.iBlockLimit) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private void AddCoordsToList(BlockPos oPos) {
        boolean bValidBlock = false;
        if (!this.oPositions.contains(oPos)) {
            block0: for (int xOffsetCheck = -1; xOffsetCheck <= 1; ++xOffsetCheck) {
                for (int zOffsetCheck = -1; zOffsetCheck <= 1; ++zOffsetCheck) {
                    for (int yOffsetCheck = 1; yOffsetCheck >= -1; --yOffsetCheck) {
                        if (!this.oPositions.contains(new BlockPos(oPos.func_177958_n() + xOffsetCheck, oPos.func_177956_o() + yOffsetCheck, oPos.func_177952_p() + zOffsetCheck))) continue;
                        bValidBlock = true;
                        break block0;
                    }
                }
            }
            if (bValidBlock) {
                this.oPositions.offer(oPos);
                if (oPos.func_177956_o() < this.iLowestY) {
                    this.iLowestY = oPos.func_177956_o();
                }
                ++this.iBlocksFound;
            } else {
                ++this.iUnconnectedCount;
            }
        } else {
            ++this.iUnconnectedCount;
        }
    }

    private static boolean isAllowedToMine(EntityPlayer player, Block block) {
        IBlockState state = block.func_176194_O().func_177621_b();
        if (null == block || Blocks.field_150350_a == block || state.func_185904_a().func_76224_d() || Blocks.field_150357_h == block) {
            return false;
        }
        return player.func_184823_b(state);
    }

    public void getShaftBlocks() {
        this.oPositions.offer(this.oInitialPos);
        this.iLowestY = this.iFeetPos = (int)this.player.func_174813_aQ().field_72338_b;
        int iHeightStart = this.iFeetPos;
        int iHeightEnd = this.iFeetPos + (SettingsShaftanator.iShaftHeight - 1);
        double dDivision = (SettingsShaftanator.iShaftWidth & 1) != 0 ? 0.0 : 0.5;
        switch (this.oPacket.sideHit) {
            case NORTH: {
                this.iWidthStart = this.oPacket.oPos.func_177958_n() - SettingsShaftanator.iShaftWidth / 2;
                this.iWidthEnd = this.oPacket.oPos.func_177958_n() + (int)((double)(SettingsShaftanator.iShaftWidth / 2) - dDivision);
                this.iLengthStart = this.oPacket.oPos.func_177952_p();
                this.iLengthEnd = this.oPacket.oPos.func_177952_p() + SettingsShaftanator.iShaftLength;
                break;
            }
            case SOUTH: {
                this.iWidthStart = this.oPacket.oPos.func_177958_n() + (int)((double)(SettingsShaftanator.iShaftWidth / 2) - dDivision);
                this.iWidthEnd = this.oPacket.oPos.func_177958_n() - SettingsShaftanator.iShaftWidth / 2;
                this.iLengthStart = this.oPacket.oPos.func_177952_p();
                this.iLengthEnd = this.oPacket.oPos.func_177952_p() - SettingsShaftanator.iShaftLength;
                break;
            }
            case WEST: {
                this.iWidthStart = this.oPacket.oPos.func_177952_p() - SettingsShaftanator.iShaftWidth / 2;
                this.iWidthEnd = this.oPacket.oPos.func_177952_p() + (int)((double)(SettingsShaftanator.iShaftWidth / 2) - dDivision);
                this.iLengthStart = this.oPacket.oPos.func_177958_n();
                this.iLengthEnd = this.oPacket.oPos.func_177958_n() + SettingsShaftanator.iShaftLength;
                break;
            }
            case EAST: {
                this.iWidthStart = this.oPacket.oPos.func_177952_p() + (int)((double)(SettingsShaftanator.iShaftWidth / 2) - dDivision);
                this.iWidthEnd = this.oPacket.oPos.func_177952_p() - SettingsShaftanator.iShaftWidth / 2;
                this.iLengthStart = this.oPacket.oPos.func_177958_n();
                this.iLengthEnd = this.oPacket.oPos.func_177958_n() - SettingsShaftanator.iShaftLength;
                break;
            }
        }
        int iAirCount = 0;
        block6 : switch (this.oPacket.sideHit) {
            case NORTH: 
            case WEST: {
                for (int iLengthPos = this.iLengthStart; iLengthPos <= this.iLengthEnd; ++iLengthPos) {
                    iAirCount = 0;
                    for (int iWidthPos = this.iWidthStart; iWidthPos <= this.iWidthEnd; ++iWidthPos) {
                        for (int iHeightPos = iHeightStart; iHeightPos <= iHeightEnd; ++iHeightPos) {
                            BlockPos curPos = new BlockPos(this.oPacket.sideHit == EnumFacing.NORTH ? iWidthPos : iLengthPos, iHeightPos, this.oPacket.sideHit == EnumFacing.NORTH ? iLengthPos : iWidthPos);
                            if (ExcavationHelper.isAllowedToMine((EntityPlayer)this.player, this.world.func_180495_p(curPos).func_177230_c())) {
                                this.AddCoordsToList(curPos);
                            } else {
                                ++iAirCount;
                            }
                            if (iAirCount >= SettingsShaftanator.iShaftHeight * SettingsShaftanator.iShaftWidth) break block6;
                        }
                    }
                }
                break;
            }
            case SOUTH: 
            case EAST: {
                for (int iLengthPos = this.iLengthStart; iLengthPos >= this.iLengthEnd; --iLengthPos) {
                    iAirCount = 0;
                    for (int iWidthPos = this.iWidthStart; iWidthPos >= this.iWidthEnd; --iWidthPos) {
                        for (int iHeightPos = iHeightStart; iHeightPos <= iHeightEnd; ++iHeightPos) {
                            BlockPos curPos = new BlockPos(this.oPacket.sideHit == EnumFacing.SOUTH ? iWidthPos : iLengthPos, iHeightPos, this.oPacket.sideHit == EnumFacing.SOUTH ? iLengthPos : iWidthPos);
                            if (ExcavationHelper.isAllowedToMine((EntityPlayer)this.player, this.world.func_180495_p(curPos).func_177230_c())) {
                                this.AddCoordsToList(curPos);
                            } else {
                                ++iAirCount;
                            }
                            if (iAirCount >= SettingsShaftanator.iShaftHeight * SettingsShaftanator.iShaftWidth) break block6;
                        }
                    }
                }
                break;
            }
        }
    }

    public void FinalizeExcavation() {
        List<Entity> list;
        if (SettingsExcavator.bGatherDrops && null != (list = Globals.getNearbyEntities(this.world, this.player.func_174813_aQ().func_72314_b((double)(SettingsExcavator.iBlockRadius + 2), (double)(SettingsExcavator.iBlockRadius + 2), (double)(SettingsExcavator.iBlockRadius + 2)))) && !list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.field_70128_L) continue;
                entity.func_70107_b((double)this.oInitialPos.func_177958_n(), (double)this.oInitialPos.func_177956_o(), (double)this.oInitialPos.func_177952_p());
            }
        }
    }

    public void FinalizeShaft() {
        List<Entity> list;
        if (SettingsShaftanator.bGatherDrops && null != (list = Globals.getNearbyEntities(this.world, this.player.func_174813_aQ().func_72314_b((double)(this.oPacket.sideHit == EnumFacing.NORTH || this.oPacket.sideHit == EnumFacing.SOUTH ? SettingsShaftanator.iShaftWidth + 2 : SettingsShaftanator.iShaftLength + 4), (double)(SettingsShaftanator.iShaftHeight + 2), (double)(this.oPacket.sideHit == EnumFacing.NORTH || this.oPacket.sideHit == EnumFacing.SOUTH ? SettingsShaftanator.iShaftLength + 4 : SettingsShaftanator.iShaftWidth + 2)))) && !list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.field_70128_L) continue;
                entity.func_70107_b((double)this.oInitialPos.func_177958_n(), (double)this.oInitialPos.func_177956_o(), (double)this.oInitialPos.func_177952_p());
            }
        }
    }
}

