/*
 * Decompiled with CFR 0.152.
 */
package duelmonster.superminer.objects;

import com.google.gson.Gson;
import duelmonster.superminer.network.packets.SMPacket;
import duelmonster.superminer.objects.VersionContainer;
import duelmonster.superminer.submods.Excavator;
import duelmonster.superminer.submods.Shaftanator;
import duelmonster.superminer.submods.Veinator;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.minecraft.block.Block;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.BlockStone;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.registry.RegistryNamespacedDefaultedByKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.io.IOUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class Globals {
    private static Gson gson = new Gson();
    public static final String ChannelName = "SuperMiner";
    public static final int FLAG_CHANGE_NUM = 10;
    public static final long attackHistoryDelayNanoTime = 3000000000L;
    public static final long packetWaitMilliSec = 200L;
    public static final int MIN_HUNGER = 1;
    public static final int SIDE_NONE = -1;
    public static final int SIDE_Bottom = 0;
    public static final int SIDE_Top = 1;
    public static final int SIDE_North = 2;
    public static final int SIDE_South = 3;
    public static final int SIDE_West = 4;
    public static final int SIDE_East = 5;
    public long packetEnableTime = System.currentTimeMillis() + 200L;
    public List<Object> lToolIDs = new ArrayList<Object>();
    public List<Object> lBlockIDs = new ArrayList<Object>();
    public List<Object> lLeafIDs = new ArrayList<Object>();
    public int iBlockRadius = -1;
    public int iBlockLimit = 256;
    public int iBlocksFound = 0;
    public BlockPos initalBlockPos;
    public BlockingQueue<SMPacket> attackHistory = new LinkedBlockingQueue<SMPacket>();

    public static String tooHungry() {
        return "\u00a7c" + Globals.localize("superminer.hungry");
    }

    public static String getLatestVerion(String sURL) {
        try {
            return ((VersionContainer)gson.fromJson(IOUtils.toString((URL)new URL(sURL)), VersionContainer.class)).getModVersion();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void clearHistory() {
        this.iBlocksFound = 0;
        this.initalBlockPos = null;
        this.attackHistory.clear();
    }

    public void addAttackBlock(EntityPlayer player, IBlockState state, BlockPos oPos, boolean bClearHistory, boolean bCheckBlockIDs, boolean bCheckToolIDs, boolean bLayerOnly) {
        this.addAttackBlock(player, state, oPos, EnumFacing.UP, bClearHistory, bCheckBlockIDs, bCheckToolIDs, bLayerOnly);
    }

    public void addAttackBlock(EntityPlayer player, IBlockState state, BlockPos oPos, EnumFacing sideHit, boolean bClearHistory, boolean bCheckBlockIDs, boolean bCheckToolIDs, boolean bLayerOnly) {
        if (player == null) {
            return;
        }
        if (bClearHistory) {
            this.clearHistory();
        }
        Item equipedItemId = null == player.func_184614_ca() ? null : player.func_184614_ca().func_77973_b();
        Block block = state.func_177230_c();
        boolean bCanAttack = !bCheckBlockIDs || !bCheckToolIDs || bCheckBlockIDs && Globals.isIdInList(block, this.lBlockIDs) && bCheckToolIDs && Globals.isIdInList(equipedItemId, this.lToolIDs);
        for (SMPacket oPacket : this.attackHistory) {
            if (!bCanAttack || !oPos.equals((Object)oPacket.oPos)) continue;
            oPacket.nanoTime = System.nanoTime();
            oPacket.prevBlock = oPacket.block;
            oPacket.block = block;
            oPacket.bLayerOnlyToggled = bLayerOnly;
            bCanAttack = false;
        }
        if (bCanAttack) {
            SMPacket oPacket = new SMPacket();
            oPacket.oPos = oPos;
            oPacket.sideHit = sideHit;
            oPacket.block = block;
            oPacket.metadata = block.func_176201_c(state);
            oPacket.nanoTime = System.nanoTime();
            oPacket.flag_rs = block == Blocks.field_150450_ax || block == Blocks.field_150439_ay;
            oPacket.bLayerOnlyToggled = bLayerOnly;
            try {
                this.attackHistory.put(oPacket);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static boolean isIdInList(Object oID, List<Object> list) {
        return list != null && list.indexOf(oID) >= 0;
    }

    public static List<Object> IDListToArray(String[] saIDs, boolean bIsBlock) {
        return Globals.IDListToArray(Arrays.asList(saIDs), bIsBlock);
    }

    public static List<Object> IDListToArray(List<String> saIDs, boolean bIsBlock) {
        RegistryNamespacedDefaultedByKey rn = bIsBlock ? Block.field_149771_c : Item.field_150901_e;
        ArrayList<Object> lReturn = new ArrayList<Object>();
        for (String sID : saIDs) {
            Object oEntity = null;
            sID = sID.trim();
            try {
                int id = Integer.parseInt(sID.trim());
                oEntity = rn.func_148754_a(id);
            }
            catch (NumberFormatException e) {
                oEntity = rn.func_82594_a((Object)new ResourceLocation(sID));
            }
            if (null == oEntity || Blocks.field_150350_a == oEntity) continue;
            lReturn.add(oEntity);
        }
        return lReturn;
    }

    public static List<Entity> getNearbyEntities(World world, AxisAlignedBB area) {
        if (!(Excavator.isExcavating().booleanValue() || Shaftanator.isExcavating().booleanValue() || Veinator.isMiningVein())) {
            try {
                List list = world.func_72872_a(Entity.class, area);
                if (null == list || list.isEmpty()) {
                    return null;
                }
                ArrayList<Entity> ret = new ArrayList<Entity>();
                for (Object o : list) {
                    Entity e = (Entity)o;
                    if (e.field_70128_L || !(e instanceof EntityItem) && !(e instanceof EntityXPOrb)) continue;
                    ret.add(e);
                }
                return ret.isEmpty() ? null : ret;
            }
            catch (ConcurrentModificationException e) {
                return null;
            }
        }
        return null;
    }

    public void checkConnection(World world, BlockPos oPos, SMPacket p, boolean bDestroyUnder) {
        this.checkConnection(world, oPos, p, bDestroyUnder, true);
    }

    public void checkConnection(World world, BlockPos oPos, SMPacket p, boolean bDestroyUnder, boolean bCheckMetadata) {
        int yStart;
        int iPosStartEnd = 1;
        int n = yStart = !bDestroyUnder && p.oPos.func_177956_o() == oPos.func_177956_o() ? 0 : 1;
        if (null == this.initalBlockPos) {
            this.initalBlockPos = new BlockPos((Vec3i)oPos);
        }
        for (int xOffset = -iPosStartEnd; xOffset <= iPosStartEnd; ++xOffset) {
            for (int yOffset = -yStart; yOffset <= iPosStartEnd; ++yOffset) {
                for (int zOffset = -iPosStartEnd; zOffset <= iPosStartEnd; ++zOffset) {
                    if (xOffset == 0 && yOffset == 0 && zOffset == 0) continue;
                    BlockPos blockPos = oPos.func_177982_a(xOffset, yOffset, zOffset);
                    if (this.iBlockRadius > 0 && !Globals.isWithinRange(this.initalBlockPos, blockPos, this.iBlockRadius) || !Globals.checkBlock(world.func_180495_p(blockPos), p)) continue;
                    p.positions.offer(blockPos);
                    ++this.iBlocksFound;
                    if (this.iBlocksFound < this.iBlockLimit) continue;
                    return;
                }
            }
        }
    }

    public static boolean checkBlock(IBlockState state, SMPacket p) {
        return Globals.checkBlock(state, p, false);
    }

    public static boolean checkBlock(IBlockState state, SMPacket p, boolean bDetectVariants) {
        Block block = state.func_177230_c();
        int iMetadata = block.func_176201_c(state);
        if (block == null || Blocks.field_150350_a == block || Blocks.field_150357_h == block) {
            return false;
        }
        if (p != null) {
            if (bDetectVariants && block instanceof BlockStone && iMetadata != p.metadata) {
                return false;
            }
            if (block == p.block && (block instanceof BlockRotatedPillar || iMetadata > -1 && block instanceof BlockQuartz && (iMetadata == 2 || iMetadata == 3 || iMetadata == 4))) {
                return true;
            }
            if (p.flag_rs && (block == Blocks.field_150450_ax || block == Blocks.field_150439_ay)) {
                return true;
            }
            return block == p.block;
        }
        return false;
    }

    public static void stackItems(World world, EntityPlayer entityplayer, SMPacket p) {
        Globals.stackItems(world, entityplayer, new AxisAlignedBB((double)p.oPos.func_177958_n(), (double)p.oPos.func_177956_o(), (double)p.oPos.func_177952_p(), (double)p.oPos.func_177958_n() + 1.0, (double)p.oPos.func_177956_o() + 1.0, (double)p.oPos.func_177952_p() + 1.0));
    }

    public static void stackItems(World world, EntityPlayer entityplayer, AxisAlignedBB box) {
        List list = world.func_72839_b((Entity)entityplayer, box);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Entity entity1 = (Entity)list.get(i);
            if (!(entity1 instanceof EntityItem) || entity1.field_70128_L) continue;
            EntityItem e1 = (EntityItem)entity1;
            ItemStack e1Item = e1.func_92059_d();
            int itemDurability1 = e1Item.func_77958_k();
            for (int j = i + 1; j < list.size(); ++j) {
                Entity entity2 = (Entity)list.get(j);
                if (!(entity2 instanceof EntityItem) || entity2.field_70128_L) continue;
                EntityItem e2 = (EntityItem)entity2;
                ItemStack e2Item = e2.func_92059_d();
                int itemDurability2 = e2Item.func_77958_k();
                if (e1Item.func_77973_b() != e2Item.func_77973_b() || itemDurability1 != itemDurability2) continue;
                e1Item.field_77994_a += e2Item.field_77994_a;
                entity2.func_70106_y();
            }
            e1.func_92058_a(e1Item);
        }
    }

    public static void NotifyClient(String sMsg) {
        FMLClientHandler.instance().getClient().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentString("\u00a75[SuperMiner] \u00a7f" + sMsg));
    }

    public static void NotifyClient(boolean bIsOn, String sModName) {
        FMLClientHandler.instance().getClient().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentString("\u00a75[SuperMiner] \u00a76" + sModName + " " + (bIsOn ? "\u00a7aON" : "\u00a7cOFF")));
    }

    public static boolean isAttacking(Minecraft mc) {
        return mc.field_71474_y.field_74312_F.func_151470_d();
    }

    public static boolean isUsingItem(Minecraft mc) {
        return mc.field_71474_y.field_74313_G.func_151470_d();
    }

    public static int getKeyIndexEx(String name) {
        int index = Mouse.getButtonIndex((String)name);
        if (index == -1) {
            return Keyboard.getKeyIndex((String)name);
        }
        return index - 100;
    }

    public static boolean isKeyDownEx(String name) {
        return Globals.isKeyDownEx(Globals.getKeyIndexEx(name));
    }

    public static boolean isKeyDownEx(int index) {
        if (index < 0) {
            return Mouse.isButtonDown((int)(index + 100));
        }
        return Keyboard.isKeyDown((int)index);
    }

    public static void playSound(World world, SoundEvent sound, BlockPos oPos) {
        world.func_184148_a((EntityPlayer)null, (double)((float)oPos.func_177958_n() + 0.5f), (double)((float)oPos.func_177956_o() + 0.5f), (double)((float)oPos.func_177952_p() + 0.5f), sound, SoundCategory.BLOCKS, 2.0f, 1.0f);
    }

    public static String localize(String key) {
        if (I18n.func_94522_b((String)key)) {
            return I18n.func_74838_a((String)key);
        }
        return I18n.func_150826_b((String)key);
    }

    public static boolean isWithinRange(BlockPos sourcePos, BlockPos targetPos, int range) {
        int distanceZ;
        int distanceY;
        int distanceX = sourcePos.func_177958_n() - targetPos.func_177958_n();
        return distanceX * distanceX + (distanceY = sourcePos.func_177956_o() - targetPos.func_177956_o()) * distanceY + (distanceZ = sourcePos.func_177952_p() - targetPos.func_177952_p()) * distanceZ <= range * range;
    }

    public static void sendPacket(Packet<?> packetIn) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            FMLClientHandler.instance().getClientToServerNetworkManager().func_179290_a(packetIn);
        }
    }

    public static void sendPacket(Packet<?> packetIn, EntityPlayerMP player) {
        if (FMLCommonHandler.instance().getSide().isServer()) {
            player.field_71135_a.func_147359_a(packetIn);
        }
    }
}

