/*
 * Decompiled with CFR 0.152.
 */
package duelmonster.superminer.objects;

import duelmonster.superminer.objects.FieldNotFoundException;
import duelmonster.superminer.objects.NotSoRandom;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;

public class SubstitutionHelper {
    private static final Minecraft mc = FMLClientHandler.instance().getClient();
    private static ItemStack prevHeldItem = null;
    private static Random prevWorldRandom = null;
    private static final String[] randomNames = new String[]{"rand", "field_73012_v", "v"};

    public static float getDigSpeed(ItemStack itemstack, IBlockState state) {
        return itemstack == null ? 1.0f : itemstack.func_77973_b().func_150893_a(itemstack, state);
    }

    public static float getBlockHardness(World world, BlockPos oPos) {
        IBlockState state = world.func_180495_p(oPos);
        if (state.func_177230_c() == null) {
            return 0.0f;
        }
        return state.func_185887_b(world, oPos);
    }

    public static float getBlockStrength(ItemStack itemstack, World world, BlockPos oPos) {
        IBlockState state = world.func_180495_p(oPos);
        SubstitutionHelper.ChangeHeldItem(itemstack);
        float strength = state.func_185903_a((EntityPlayer)SubstitutionHelper.mc.field_71439_g, world, oPos);
        SubstitutionHelper.RestoreHeldItem();
        return strength;
    }

    public static int getAdjustedBlockStrength(double blockStrength) {
        return blockStrength <= 0.0 ? Integer.MIN_VALUE : -MathHelper.func_76143_f((double)(1.0 / blockStrength));
    }

    public static float getEfficiency(float digSpeed, ItemStack itemstack) {
        if (digSpeed <= 1.5f) {
            return digSpeed;
        }
        SubstitutionHelper.ChangeHeldItem(itemstack);
        float efficiencyLevel = EnchantmentHelper.func_185293_e((EntityLivingBase)SubstitutionHelper.mc.field_71439_g);
        SubstitutionHelper.RestoreHeldItem();
        if (efficiencyLevel == 0.0f) {
            return digSpeed;
        }
        return digSpeed + efficiencyLevel * efficiencyLevel + 1.0f;
    }

    public static int getHarvestLevel(World world, ItemStack itemstack, BlockPos oPos) {
        IBlockState state = world.func_180495_p(oPos);
        Block block = state.func_177230_c();
        SubstitutionHelper.ChangeHeldItem(null);
        boolean noTool = SubstitutionHelper.mc.field_71439_g.func_184823_b(state);
        SubstitutionHelper.RestoreHeldItem();
        if (noTool) {
            return 0;
        }
        SubstitutionHelper.ChangeHeldItem(itemstack);
        boolean canHarvest = block.canHarvestBlock((IBlockAccess)SubstitutionHelper.mc.field_71441_e, oPos, (EntityPlayer)SubstitutionHelper.mc.field_71439_g);
        SubstitutionHelper.RestoreHeldItem();
        return canHarvest ? 1 : -1;
    }

    public static boolean isBlockSilkTouchable(World world, BlockPos oPos) {
        IBlockState state = world.func_180495_p(oPos);
        Block block = state.func_177230_c();
        if (block == null) {
            return false;
        }
        int metadata = block.func_176201_c(state);
        boolean silkHarvest = block.canSilkHarvest(world, oPos, state, (EntityPlayer)SubstitutionHelper.mc.field_71439_g);
        if (!silkHarvest) {
            return false;
        }
        NotSoRandom zeroRandom = new NotSoRandom(true);
        NotSoRandom maxRandom = new NotSoRandom(false);
        ItemStack stackedBlock = SubstitutionHelper.createBlockStack(block, metadata);
        List<ItemStack> stackedBlockList = Collections.singletonList(stackedBlock);
        SubstitutionHelper.ChangeWorldRandom(world, maxRandom);
        List maxRandomDrops = block.getDrops((IBlockAccess)world, oPos, state, 0);
        SubstitutionHelper.ChangeWorldRandom(world, zeroRandom);
        List zeroRandomDrops = block.getDrops((IBlockAccess)world, oPos, state, 0);
        SubstitutionHelper.RestoreWorldRandom(world);
        return !SubstitutionHelper.areItemStackListsIdentical(stackedBlockList, maxRandomDrops) || !SubstitutionHelper.areItemStackListsIdentical(stackedBlockList, zeroRandomDrops);
    }

    public static boolean isBlockFortunable(World world, BlockPos oPos) {
        IBlockState state = world.func_180495_p(oPos);
        Block block = state.func_177230_c();
        if (block == null) {
            return false;
        }
        NotSoRandom zeroRandom = new NotSoRandom(true);
        NotSoRandom maxRandom = new NotSoRandom(false);
        SubstitutionHelper.ChangeWorldRandom(world, maxRandom);
        List defaultMaxDrops = block.getDrops((IBlockAccess)world, oPos, state, 0);
        List fortuneMaxDrops = block.getDrops((IBlockAccess)world, oPos, state, 3);
        SubstitutionHelper.ChangeWorldRandom(world, zeroRandom);
        List defaultZeroDrops = block.getDrops((IBlockAccess)world, oPos, state, 0);
        List fortuneZeroDrops = block.getDrops((IBlockAccess)world, oPos, state, 3);
        SubstitutionHelper.RestoreWorldRandom(world);
        return !SubstitutionHelper.areItemStackListsIdentical(defaultMaxDrops, fortuneMaxDrops) || !SubstitutionHelper.areItemStackListsIdentical(defaultZeroDrops, fortuneZeroDrops);
    }

    private static void ChangeHeldItem(ItemStack itemstack) {
        int iSlot = SubstitutionHelper.mc.field_71439_g.field_71071_by.field_70461_c;
        prevHeldItem = SubstitutionHelper.mc.field_71439_g.field_71071_by.field_70462_a[iSlot];
        SubstitutionHelper.mc.field_71439_g.field_71071_by.field_70462_a[iSlot] = itemstack;
        if (prevHeldItem != null) {
            SubstitutionHelper.mc.field_71439_g.func_110140_aT().func_111148_a(prevHeldItem.func_111283_C(null));
        }
        if (itemstack != null) {
            SubstitutionHelper.mc.field_71439_g.func_110140_aT().func_111147_b(itemstack.func_111283_C(null));
        }
    }

    private static void RestoreHeldItem() {
        int iSlot = SubstitutionHelper.mc.field_71439_g.field_71071_by.field_70461_c;
        ItemStack itemstack = SubstitutionHelper.mc.field_71439_g.field_71071_by.field_70462_a[iSlot];
        SubstitutionHelper.mc.field_71439_g.field_71071_by.field_70462_a[iSlot] = prevHeldItem;
        if (itemstack != null) {
            SubstitutionHelper.mc.field_71439_g.func_110140_aT().func_111148_a(itemstack.func_111283_C(null));
        }
        if (prevHeldItem != null) {
            SubstitutionHelper.mc.field_71439_g.func_110140_aT().func_111147_b(prevHeldItem.func_111283_C(null));
        }
    }

    private static void ChangeWorldRandom(World world, Random random) {
        if (prevWorldRandom == null) {
            prevWorldRandom = world.field_73012_v;
            for (String name : randomNames) {
                try {
                    Field field = World.class.getDeclaredField(name);
                    field.setAccessible(true);
                    try {
                        Field modifiersField = Field.class.getDeclaredField("modifiers");
                        modifiersField.setAccessible(true);
                        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                        field.set(world, random);
                        modifiersField.setInt(field, field.getModifiers() | 0x10);
                        return;
                    }
                    catch (Exception e) {
                        throw new FieldNotFoundException("Error setting field", e);
                    }
                }
                catch (NoSuchFieldException nsfe) {
                }
            }
        }
    }

    private static void RestoreWorldRandom(World world) {
        for (String name : randomNames) {
            try {
                Field field = World.class.getDeclaredField(name);
                field.setAccessible(true);
                try {
                    Field modifiersField = Field.class.getDeclaredField("modifiers");
                    modifiersField.setAccessible(true);
                    modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                    field.set(world, prevWorldRandom);
                    modifiersField.setInt(field, field.getModifiers() | 0x10);
                    return;
                }
                catch (Exception e) {
                    throw new FieldNotFoundException("Error setting field", e);
                }
            }
            catch (NoSuchFieldException nsfe) {
            }
        }
        prevWorldRandom = null;
    }

    private static ItemStack createBlockStack(Block block, int metadata) {
        int itemMetadata = 0;
        Item item = Item.func_150898_a((Block)block);
        if (item != null && item.func_77614_k()) {
            itemMetadata = metadata;
        }
        return new ItemStack(item, 1, itemMetadata);
    }

    public static boolean areItemStackListsIdentical(Collection<? extends ItemStack> stackCollection_1, Collection<? extends ItemStack> stackCollection_2) {
        if (stackCollection_1.size() != stackCollection_2.size()) {
            return false;
        }
        ArrayList<? extends ItemStack> stackList_1 = new ArrayList<ItemStack>(stackCollection_1);
        ArrayList<? extends ItemStack> stackList_2 = new ArrayList<ItemStack>(stackCollection_2);
        Iterator stackIterator_1 = stackList_1.iterator();
        block0: while (stackIterator_1.hasNext()) {
            ItemStack stack_1 = (ItemStack)stackIterator_1.next();
            Iterator stackIterator_2 = stackList_2.iterator();
            while (stackIterator_2.hasNext()) {
                ItemStack stack_2 = (ItemStack)stackIterator_2.next();
                if (!ItemStack.func_77989_b((ItemStack)stack_1, (ItemStack)stack_2)) continue;
                if (stackList_1.size() > 0) {
                    stackIterator_1.remove();
                }
                if (stackList_2.size() <= 0) continue block0;
                stackIterator_2.remove();
                continue block0;
            }
            return false;
        }
        return true;
    }

    public static boolean isItemStackDamageable(ItemStack itemstack) {
        return itemstack != null && itemstack.func_77973_b().func_77645_m();
    }

    public static boolean isSameTool(ItemStack stack_1, ItemStack stack_2) {
        return stack_1 != null && stack_2 != null && stack_2.func_77973_b().getClass() == stack_1.func_77973_b().getClass();
    }

    public static boolean isSword(ItemStack itemstack) {
        return itemstack != null && (itemstack.func_77973_b() instanceof ItemSword || itemstack.func_77973_b().func_77658_a().toLowerCase().contains("sword"));
    }

    public static Set<Enchantment> getMultiToolEnchantments(ItemStack Tool_1, ItemStack Tool_2) {
        HashSet enchantments = new HashSet();
        HashSet<Enchantment> returnSet = new HashSet<Enchantment>();
        if (Tool_1 != null) {
            enchantments.addAll(EnchantmentHelper.func_82781_a((ItemStack)Tool_1).keySet());
        }
        if (Tool_2 != null) {
            enchantments.addAll(EnchantmentHelper.func_82781_a((ItemStack)Tool_2).keySet());
        }
        for (Enchantment enchant : enchantments) {
            if (enchant == Enchantments.field_185305_q || enchant == Enchantments.field_185306_r || enchant == Enchantments.field_185308_t || enchant == Enchantments.field_185307_s || enchant == Enchantments.field_185304_p || enchant == Enchantments.field_180313_o || enchant == Enchantments.field_77334_n || enchant.func_77320_a().startsWith("Enchantments.damage.")) continue;
            returnSet.add(enchant);
        }
        return returnSet;
    }

    public static double getVanillaStackDamage(ItemStack itemStack, EntityLivingBase entity) {
        SubstitutionHelper.ChangeHeldItem(itemStack);
        double attackDamage = SubstitutionHelper.mc.field_71439_g.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        double enchantModifier = EnchantmentHelper.func_152377_a((ItemStack)itemStack, (EnumCreatureAttribute)entity.func_70668_bt());
        if (attackDamage > 0.0 || enchantModifier > 0.0) {
            boolean isCritical;
            boolean bl = isCritical = SubstitutionHelper.mc.field_71439_g.field_70143_R > 0.0f && !SubstitutionHelper.mc.field_71439_g.field_70122_E && !SubstitutionHelper.mc.field_71439_g.func_70617_f_() && !SubstitutionHelper.mc.field_71439_g.func_70090_H() && !SubstitutionHelper.mc.field_71439_g.func_70644_a(MobEffects.field_76440_q) && SubstitutionHelper.mc.field_71439_g.func_184187_bx() == null;
            if (isCritical && attackDamage > 0.0) {
                attackDamage *= 1.5;
            }
            attackDamage += enchantModifier;
        }
        SubstitutionHelper.RestoreHeldItem();
        return attackDamage;
    }

    public static boolean transferStackFromTo(Container container, Minecraft mc, int slotFrom, int slotTo) {
        EntityPlayerSP player = mc.field_71439_g;
        mc.field_71442_b.func_187098_a(container.field_75152_c, slotFrom, 0, ClickType.PICKUP, (EntityPlayer)player);
        if (player.field_71071_by.func_70445_o() == null) {
            return false;
        }
        boolean bRtrn = true;
        int size = player.field_71071_by.func_70445_o().field_77994_a;
        mc.field_71442_b.func_187098_a(container.field_75152_c, slotTo, 0, ClickType.PICKUP, (EntityPlayer)player);
        if (player.field_71071_by.func_70445_o() != null) {
            bRtrn = player.field_71071_by.func_70445_o().field_77994_a != size;
            mc.field_71442_b.func_187098_a(container.field_75152_c, slotFrom, 0, ClickType.PICKUP, (EntityPlayer)player);
        }
        return bRtrn;
    }
}

