/*
 * Decompiled with CFR 0.152.
 */
package duelmonster.superminer.objects;

import duelmonster.superminer.config.SettingsLumbinator;
import duelmonster.superminer.network.packets.SMPacket;
import duelmonster.superminer.objects.Globals;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;

public class TreeHelper {
    public static final int MAX_TREE_WIDTH = 64;
    private EntityPlayer oPlayer;
    private Globals myGlobals;
    public int iTreeWidthPlusX = 0;
    public int iTreeWidthMinusX = 0;
    public int iTreeWidthPlusZ = 0;
    public int iTreeWidthMinusZ = 0;
    private BlockPos oFirstLeafPos = null;

    public TreeHelper(EntityPlayer player, Globals globals) {
        this.oPlayer = player;
        this.myGlobals = globals;
    }

    public void DetectTreeWidth(SMPacket currentPacket) {
        if (this.oFirstLeafPos != null) {
            int yLevel;
            for (int yLeaf = yLevel = this.oFirstLeafPos.func_177956_o(); yLeaf < this.oPlayer.field_70170_p.func_72800_K(); ++yLeaf) {
                String sUID = "";
                boolean bIsValidWood = false;
                boolean bIsValidLeaf = false;
                int iWidthPlusX = 0;
                int iWidthMinusX = 0;
                int iWidthPlusZ = 0;
                int iWidthMinusZ = 0;
                int iLastWoodPlus = 0;
                int iLastWoodMinus = 0;
                for (int xOffset = 0; xOffset < 64; ++xOffset) {
                    sUID = this.getUniqueIdentifier(new BlockPos(currentPacket.oPos.func_177958_n() + xOffset, yLevel, currentPacket.oPos.func_177952_p()));
                    bIsValidWood = currentPacket.sWoodName.equalsIgnoreCase(sUID);
                    bIsValidLeaf = currentPacket.sLeafName.equalsIgnoreCase(sUID);
                    if (bIsValidWood) {
                        iLastWoodPlus = xOffset;
                    }
                    if (bIsValidLeaf && xOffset - iLastWoodPlus > SettingsLumbinator.iLeafRange) break;
                    if (bIsValidWood || bIsValidLeaf) {
                        ++iWidthPlusX;
                    }
                    sUID = this.getUniqueIdentifier(new BlockPos(currentPacket.oPos.func_177958_n() - xOffset, yLevel, currentPacket.oPos.func_177952_p()));
                    bIsValidWood = currentPacket.sWoodName.equalsIgnoreCase(sUID);
                    bIsValidLeaf = currentPacket.sLeafName.equalsIgnoreCase(sUID);
                    if (bIsValidWood) {
                        iLastWoodMinus = xOffset;
                    }
                    if (bIsValidLeaf && xOffset - iLastWoodMinus > SettingsLumbinator.iLeafRange) break;
                    if (!bIsValidWood && !bIsValidLeaf) continue;
                    ++iWidthMinusX;
                }
                iLastWoodPlus = 0;
                iLastWoodMinus = 0;
                for (int zOffset = 0; zOffset < 64; ++zOffset) {
                    sUID = this.getUniqueIdentifier(new BlockPos(currentPacket.oPos.func_177958_n(), yLevel, currentPacket.oPos.func_177952_p() + zOffset));
                    bIsValidWood = currentPacket.sWoodName.equalsIgnoreCase(sUID);
                    bIsValidLeaf = currentPacket.sLeafName.equalsIgnoreCase(sUID);
                    if (bIsValidWood) {
                        iLastWoodPlus = zOffset;
                    }
                    if (bIsValidLeaf && zOffset - iLastWoodPlus > SettingsLumbinator.iLeafRange) break;
                    if (bIsValidWood || bIsValidLeaf) {
                        ++iWidthPlusZ;
                    }
                    sUID = this.getUniqueIdentifier(new BlockPos(currentPacket.oPos.func_177958_n(), yLevel, currentPacket.oPos.func_177952_p() - zOffset));
                    bIsValidWood = currentPacket.sWoodName.equalsIgnoreCase(sUID);
                    bIsValidLeaf = currentPacket.sLeafName.equalsIgnoreCase(sUID);
                    if (bIsValidWood) {
                        iLastWoodMinus = zOffset;
                    }
                    if (bIsValidLeaf && zOffset - iLastWoodMinus > SettingsLumbinator.iLeafRange) break;
                    if (!bIsValidWood && !bIsValidLeaf) continue;
                    ++iWidthMinusZ;
                }
                if (iWidthPlusX > this.iTreeWidthPlusX) {
                    this.iTreeWidthPlusX = iWidthPlusX;
                }
                if (iWidthMinusX > this.iTreeWidthMinusX) {
                    this.iTreeWidthMinusX = iWidthMinusX;
                }
                if (iWidthPlusZ > this.iTreeWidthPlusZ) {
                    this.iTreeWidthPlusZ = iWidthPlusZ;
                }
                if (iWidthMinusZ <= this.iTreeWidthMinusZ) continue;
                this.iTreeWidthMinusZ = iWidthMinusZ;
            }
        }
    }

    public String getLeafName(SMPacket currentPacket) {
        for (int yLeaf = currentPacket.oPos.func_177956_o() - 1; yLeaf < this.oPlayer.field_70170_p.func_72800_K(); ++yLeaf) {
            for (int xLeaf = -1; xLeaf < 1; ++xLeaf) {
                for (int zLeaf = -1; zLeaf < 1; ++zLeaf) {
                    BlockPos nextPos = new BlockPos(currentPacket.oPos.func_177958_n() + xLeaf, yLeaf, currentPacket.oPos.func_177952_p() + zLeaf);
                    IBlockState nextState = this.oPlayer.field_70170_p.func_180495_p(nextPos);
                    Block nextBlock = nextState.func_177230_c();
                    if (nextState.func_185904_a() != Material.field_151584_j || !Globals.isIdInList(nextBlock, this.myGlobals.lLeafIDs)) continue;
                    this.oFirstLeafPos = nextPos;
                    return this.getUniqueIdentifier(nextPos);
                }
            }
        }
        return "unknown";
    }

    public String getUniqueIdentifier(BlockPos oPos) {
        IBlockState state = this.oPlayer.field_70170_p.func_180495_p(oPos);
        return this.getUniqueIdentifier(state, state.func_177230_c().func_176201_c(state));
    }

    public String getUniqueIdentifier(IBlockState state, int iMetadata) {
        boolean bIsValidLeaves;
        Block block = state.func_177230_c();
        String sResult = "";
        sResult = block.func_149739_a() + "_";
        boolean bIsValidWood = state.func_185904_a() == Material.field_151575_d && Globals.isIdInList(block, this.myGlobals.lBlockIDs);
        boolean bl = bIsValidLeaves = state.func_185904_a() == Material.field_151584_j && Globals.isIdInList(block, this.myGlobals.lLeafIDs);
        if (bIsValidWood) {
            if (block instanceof BlockOldLog) {
                sResult = sResult + BlockPlanks.EnumType.func_176837_a((int)((iMetadata & 3) % 4)).func_176610_l();
            } else if (block instanceof BlockNewLog) {
                sResult = sResult + BlockPlanks.EnumType.func_176837_a((int)((iMetadata & 3) + 4)).func_176610_l();
            }
        } else if (bIsValidLeaves) {
            if (block instanceof BlockOldLeaf) {
                sResult = sResult + ((BlockOldLeaf)block).func_176233_b(iMetadata).func_176610_l();
            } else if (block instanceof BlockNewLeaf) {
                sResult = sResult + ((BlockNewLeaf)block).func_176233_b(iMetadata).func_176610_l();
            }
        }
        return sResult;
    }

    public boolean ensureIsConnectedToTree(SMPacket currentPacket, BlockPos nextPos) {
        for (int yConOffset = -1; yConOffset <= 1; ++yConOffset) {
            for (int xConOffset = -1; xConOffset <= 1; ++xConOffset) {
                for (int zConOffset = -1; zConOffset <= 1; ++zConOffset) {
                    BlockPos oConPos = new BlockPos(nextPos.func_177958_n() + xConOffset, nextPos.func_177956_o() + yConOffset, nextPos.func_177952_p() + zConOffset);
                    if (!currentPacket.positions.contains(oConPos)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean processPosition(SMPacket currentPacket, BlockPos nextPos, boolean bIsTree) {
        IBlockState nextState = this.oPlayer.field_70170_p.func_180495_p(nextPos);
        Block nextBlock = nextState.func_177230_c();
        if (nextBlock != null && nextBlock != Blocks.field_150350_a && this.ensureIsConnectedToTree(currentPacket, nextPos)) {
            boolean bIsValidWood = nextState.func_185904_a() == Material.field_151575_d && Globals.isIdInList(nextBlock, this.myGlobals.lBlockIDs);
            boolean bIsValidLeaves = nextState.func_185904_a() == Material.field_151584_j && Globals.isIdInList(nextBlock, this.myGlobals.lLeafIDs);
            String sNextName = this.getUniqueIdentifier(nextPos);
            if (bIsValidWood && currentPacket.sWoodName.equalsIgnoreCase(sNextName) || bIsValidLeaves && (currentPacket.sLeafName.isEmpty() || currentPacket.sLeafName.equalsIgnoreCase(sNextName))) {
                if (bIsValidLeaves && currentPacket.sLeafName.isEmpty()) {
                    currentPacket.sLeafName = sNextName;
                }
                if (bIsValidWood || bIsValidLeaves && SettingsLumbinator.bDestroyLeaves) {
                    currentPacket.positions.offer(nextPos);
                }
                if (bIsValidLeaves && !bIsTree) {
                    return true;
                }
            } else if (SettingsLumbinator.bDestroyLeaves && nextBlock instanceof BlockSnow) {
                currentPacket.positions.offer(nextPos);
            }
        }
        return bIsTree;
    }
}

