/*
 * Decompiled with CFR 0.152.
 */
package duelmonster.superminer.submods;

import duelmonster.superminer.SuperMiner_Core;
import duelmonster.superminer.config.SettingsCropinator;
import duelmonster.superminer.events.PlayerEvents;
import duelmonster.superminer.network.packets.AutoFurrowPacket;
import duelmonster.superminer.network.packets.PacketIDs;
import duelmonster.superminer.objects.Globals;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBeetroot;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="superminer_cropinator", name="Cropinator", version="[1.10.2]-2.1.4.090", acceptedMinecraftVersions="[1.10.2]")
public class Cropinator {
    public static final String MODID = "superminer_cropinator";
    public static final String MODName = "Cropinator";
    public static final String ChannelName = "superminer_cropinator".substring(0, "superminer_cropinator".length() < 20 ? "superminer_cropinator".length() : 20);
    private boolean bHungerNotified = false;
    public static boolean bShouldSyncSettings = true;
    private static List<Object> lHoeIDs = null;

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        FMLEventChannel eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(ChannelName);
        eventChannel.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void syncConfig() {
        SettingsCropinator.bEnabled = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.cropinator.enabled"), MODID, true, Globals.localize("superminer.cropinator.enabled.desc"));
        SettingsCropinator.bHarvestSeeds = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.cropinator.harvest_seeds"), MODID, false, Globals.localize("superminer.cropinator.harvest_seeds.desc"));
        SettingsCropinator.lHoeIDs = new ArrayList<String>(Arrays.asList(SuperMiner_Core.configFile.getStringList(Globals.localize("superminer.cropinator.hoe_ids"), MODID, SettingsCropinator.lHoeIDDefaults.toArray(new String[0]), Globals.localize("superminer.cropinator.hoe_ids.desc"))));
        lHoeIDs = Globals.IDListToArray(SettingsCropinator.lHoeIDs, false);
        ArrayList<String> order = new ArrayList<String>(9);
        order.add(Globals.localize("superminer.cropinator.enabled"));
        order.add(Globals.localize("superminer.cropinator.harvest_seeds"));
        order.add(Globals.localize("superminer.cropinator.hoe_ids"));
        SuperMiner_Core.configFile.setCategoryPropertyOrder(MODID, order);
        if (!bShouldSyncSettings) {
            bShouldSyncSettings = SuperMiner_Core.configFile.hasChanged();
        }
    }

    @Mod.EventHandler
    public void imcCallback(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (!message.isStringMessage() || !message.key.equalsIgnoreCase("addHoe") || SettingsCropinator.lHoeIDs.contains(message.getStringValue())) continue;
            SettingsCropinator.lHoeIDs.add(message.getStringValue());
            SuperMiner_Core.configFile.get(MODID, Globals.localize("superminer.cropinator.hoe_ids"), SettingsCropinator.lHoeIDDefaults.toArray(new String[0]), Globals.localize("superminer.cropinator.hoe_ids.desc")).set(SettingsCropinator.lHoeIDs.toArray(new String[0]));
            SuperMiner_Core.configFile.save();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void tickEvent(TickEvent.ClientTickEvent event) {
        EntityPlayerSP player;
        if (!(PlayerEvents.IsPlayerInWorld() && SettingsCropinator.bEnabled && TickEvent.Phase.END.equals((Object)event.phase))) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc.field_71439_g == null || mc.field_71441_e == null || mc.func_147113_T() || !mc.field_71415_G) {
            return;
        }
        if (bShouldSyncSettings) {
            Globals.sendPacket(new CPacketCustomPayload(ChannelName, SettingsCropinator.writePacketData()));
            bShouldSyncSettings = false;
        }
        if (null == (player = mc.field_71439_g) || player.field_70128_L || player.func_70608_bn()) {
            return;
        }
        WorldClient world = mc.field_71441_e;
        if (world != null) {
            IBlockState state = null;
            Block block = null;
            BlockPos oPos = null;
            if (player.func_110143_aJ() > 0.0f && mc.field_71476_x != null && mc.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK) {
                oPos = mc.field_71476_x.func_178782_a();
                state = world.func_180495_p(oPos);
                block = state.func_177230_c();
                if (!Globals.isAttacking(mc) && block != null && block == Blocks.field_150350_a) {
                    block = null;
                }
                if (block != null) {
                    if (!this.bHungerNotified && player.func_71024_bL().func_75116_a() <= 1) {
                        Globals.NotifyClient(Globals.tooHungry() + MODName);
                        this.bHungerNotified = true;
                        return;
                    }
                    if (player.func_71024_bL().func_75116_a() > 1 && player.func_184614_ca() != null && Globals.isIdInList(player.func_184614_ca().func_77973_b(), lHoeIDs)) {
                        if (Globals.isUsingItem(mc) && (block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150458_ak)) {
                            Globals.sendPacket(new CPacketCustomPayload(ChannelName, new AutoFurrowPacket(PacketIDs.Cropinator_HoePacket.value(), oPos).writePacketData()));
                        } else if (Globals.isUsingItem(mc) && block instanceof IPlantable) {
                            Globals.sendPacket(new CPacketCustomPayload(ChannelName, new AutoFurrowPacket(PacketIDs.Cropinator_CropPacket.value(), oPos).writePacketData()));
                        }
                    }
                } else {
                    this.bHungerNotified = false;
                }
            }
        }
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        PacketBuffer payLoad = new PacketBuffer(event.getPacket().payload());
        int iPacketID = payLoad.copy().readInt();
        if (iPacketID == PacketIDs.Settings_Cropinator.value()) {
            SettingsCropinator.readPacketData(payLoad);
        } else if (SettingsCropinator.bEnabled) {
            EntityPlayerMP player = ((NetHandlerPlayServer)event.getHandler()).field_147369_b;
            AutoFurrowPacket packet = new AutoFurrowPacket();
            packet.readPacketData(payLoad);
            if (iPacketID == PacketIDs.Cropinator_HoePacket.value()) {
                Cropinator.HoeTheFarm(packet, (EntityPlayer)player);
            } else if (iPacketID == PacketIDs.Cropinator_CropPacket.value()) {
                Cropinator.FarmTheCrops(packet, (EntityPlayer)player);
            }
        }
    }

    private static void HoeTheFarm(AutoFurrowPacket oPacket, EntityPlayer player) {
        BlockPos blockPos;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (null == server) {
            return;
        }
        WorldServer world = server.func_71218_a(player.field_71093_bK);
        if (world == null) {
            return;
        }
        Cropinator.getFarmLand((World)world, oPacket);
        ItemStack curItem = player.func_184614_ca();
        int iFarmableFound = oPacket.lstPositions.size();
        int iFarmed = 0;
        while (iFarmed <= iFarmableFound && (blockPos = oPacket.lstPositions.poll()) != null) {
            Block blockAbove = world.func_180495_p(blockPos.func_177984_a()).func_177230_c();
            if (blockPos.func_177956_o() == oPacket.oPos.func_177956_o() && (blockAbove == Blocks.field_150350_a || blockAbove instanceof IPlantable) && Cropinator.hasWaterSource((World)world, blockPos)) {
                world.func_180501_a(blockPos, Blocks.field_150458_ak.func_176223_P().func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(7)), 2);
                Globals.playSound((World)world, SoundEvents.field_187693_cj, blockPos);
                if (blockAbove instanceof IPlantable) {
                    int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)curItem);
                    blockAbove.func_176226_b((World)world, blockPos, world.func_180495_p(blockPos.func_177984_a()), fortune);
                    world.func_180501_a(blockPos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 2);
                }
                if (curItem != null && curItem.func_77984_f()) {
                    curItem.func_77972_a(1, (EntityLivingBase)player);
                }
                if (curItem.func_77958_k() <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                    player.field_71070_bA.func_75142_b();
                    break;
                }
            }
            if (++iFarmed <= iFarmableFound) continue;
            break;
        }
        oPacket.lstPositions.clear();
    }

    private static void getFarmLand(World world, AutoFurrowPacket oPacket) {
        int iRadius = 8;
        for (int xOffset = -iRadius; xOffset <= iRadius; ++xOffset) {
            for (int zOffset = -iRadius; zOffset <= iRadius; ++zOffset) {
                BlockPos blockPos = oPacket.oPos.func_177982_a(xOffset, 0, zOffset);
                Block oBlock = world.func_180495_p(blockPos).func_177230_c();
                if (oBlock == null || oBlock == Blocks.field_150350_a || oBlock != Blocks.field_150349_c && oBlock != Blocks.field_150346_d) continue;
                oPacket.lstPositions.offer(blockPos);
            }
        }
    }

    private static boolean hasWaterSource(World world, BlockPos oPos) {
        for (int xOffset = oPos.func_177958_n() - 4; xOffset <= oPos.func_177958_n() + 4; ++xOffset) {
            for (int yOffset = oPos.func_177956_o(); yOffset <= oPos.func_177956_o() + 1; ++yOffset) {
                for (int zOffset = oPos.func_177952_p() - 4; zOffset <= oPos.func_177952_p() + 4; ++zOffset) {
                    IBlockState state = world.func_180495_p(new BlockPos(xOffset, yOffset, zOffset));
                    if (state.func_185904_a() != Material.field_151586_h) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static void FarmTheCrops(AutoFurrowPacket oPacket, EntityPlayer player) {
        BlockPos blockPos;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (null == server) {
            return;
        }
        WorldServer world = server.func_71218_a(player.field_71093_bK);
        if (world == null) {
            return;
        }
        Cropinator.getCrops((World)world, oPacket);
        ItemStack curItem = player.func_184614_ca();
        int iFarmableFound = oPacket.lstPositions.size();
        int iFarmed = 0;
        while (iFarmed <= iFarmableFound && (blockPos = oPacket.lstPositions.poll()) != null) {
            boolean bHarvest = true;
            IBlockState state = world.func_180495_p(blockPos);
            IBlockState newState = null;
            Block blkCrop = state.func_177230_c();
            if (blkCrop instanceof BlockBeetroot && ((BlockBeetroot)blkCrop).func_185525_y(state)) {
                newState = blkCrop.func_176223_P().func_177226_a((IProperty)BlockBeetroot.field_185531_a, (Comparable)Integer.valueOf(0));
            } else if (blkCrop instanceof BlockCrops && ((BlockCrops)blkCrop).func_185525_y(state)) {
                newState = blkCrop.func_176223_P().func_177226_a((IProperty)BlockCrops.field_176488_a, (Comparable)Integer.valueOf(0));
            } else {
                bHarvest = false;
            }
            if (bHarvest) {
                int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)curItem);
                if (SettingsCropinator.bHarvestSeeds) {
                    blkCrop.func_176226_b((World)world, blockPos, state, fortune);
                } else {
                    List drops = blkCrop.getDrops((IBlockAccess)world, blockPos, state, fortune);
                    for (ItemStack item : drops) {
                        if (item.func_77973_b() instanceof ItemSeeds) continue;
                        Block.func_180635_a((World)world, (BlockPos)blockPos, (ItemStack)item);
                    }
                }
                world.func_180501_a(blockPos, newState, 2);
                Globals.playSound((World)world, SoundEvents.field_187575_bT, blockPos);
                if (iFarmed > 0 && (iFarmed % 4 == 0 || iFarmed >= iFarmableFound) && curItem != null && curItem.func_77984_f()) {
                    curItem.func_77972_a(1, (EntityLivingBase)player);
                }
                if (curItem.func_77958_k() <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                    player.field_71070_bA.func_75142_b();
                    break;
                }
            }
            if (++iFarmed <= iFarmableFound) continue;
            break;
        }
        oPacket.lstPositions.clear();
    }

    private static void getCrops(World world, AutoFurrowPacket oPacket) {
        int iPosStartEnd = 32;
        for (int iSpiral = 1; iSpiral <= iPosStartEnd; ++iSpiral) {
            for (int xOffset = -iSpiral; xOffset <= iSpiral; ++xOffset) {
                for (int zOffset = -iSpiral; zOffset <= iSpiral; ++zOffset) {
                    BlockPos blockPos = oPacket.oPos.func_177982_a(xOffset, 0, zOffset);
                    Block oBlock = world.func_180495_p(blockPos).func_177230_c();
                    if (oBlock == null || oBlock == Blocks.field_150350_a || !(oBlock instanceof BlockCrops) || !oPacket.isPositionConnected(blockPos)) continue;
                    oPacket.lstPositions.offer(blockPos);
                }
            }
        }
    }
}

