/*
 * Decompiled with CFR 0.152.
 */
package duelmonster.superminer.submods;

import duelmonster.superminer.SuperMiner_Core;
import duelmonster.superminer.config.SettingsExcavator;
import duelmonster.superminer.events.PlayerEvents;
import duelmonster.superminer.keys.KeyBindings;
import duelmonster.superminer.network.packets.AutoFurrowPacket;
import duelmonster.superminer.network.packets.PacketIDs;
import duelmonster.superminer.network.packets.SMPacket;
import duelmonster.superminer.objects.ExcavationHelper;
import duelmonster.superminer.objects.Globals;
import duelmonster.superminer.objects.GodItems;
import duelmonster.superminer.submods.Shaftanator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="superminer_excavator", name="Excavator", version="[1.10.2]-2.1.4.090", acceptedMinecraftVersions="[1.10.2]")
public class Excavator {
    public static final String MODID = "superminer_excavator";
    public static final String MODName = "Excavator";
    public static final String ChannelName = "superminer_excavator".substring(0, "superminer_excavator".length() < 20 ? "superminer_excavator".length() : 20);
    public static boolean bToggled = false;
    public static boolean bLayerOnlyToggled = false;
    public static Globals myGlobals = new Globals();
    public static List<Object> lShovelIDs = null;
    private boolean bHungerNotified = false;
    public static boolean bShouldSyncSettings = true;
    private static List<ExcavationHelper> myExcavationHelpers = new ArrayList<ExcavationHelper>();

    public static boolean isToggled() {
        return bToggled || bLayerOnlyToggled;
    }

    private static List<ExcavationHelper> getMyExcavationHelpers() {
        return new ArrayList<ExcavationHelper>(myExcavationHelpers);
    }

    public static Boolean isExcavating() {
        boolean bIsExcavating = false;
        for (ExcavationHelper oEH : Excavator.getMyExcavationHelpers()) {
            if (bIsExcavating) continue;
            bIsExcavating = oEH != null && oEH.isExcavating();
        }
        return bIsExcavating;
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        FMLEventChannel eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(ChannelName);
        eventChannel.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void syncConfig() {
        SettingsExcavator.bEnabled = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.excavator.enabled"), MODID, true, Globals.localize("superminer.excavator.enabled.desc"));
        SettingsExcavator.bGatherDrops = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.excavator.gather_drops"), MODID, true, Globals.localize("superminer.excavator.gather_drops.desc"));
        SettingsExcavator.bAutoIlluminate = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.excavator.auto_illum"), MODID, true, Globals.localize("superminer.excavator.auto_illum.desc"));
        SettingsExcavator.bDetectVariants = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.excavator.detect_variants"), MODID, true, Globals.localize("superminer.excavator.detect_variants.desc"));
        SettingsExcavator.lToolIDs = new ArrayList<String>(Arrays.asList(SuperMiner_Core.configFile.getStringList(Globals.localize("superminer.excavator.tool_ids"), MODID, SettingsExcavator.lToolIDDefaults.toArray(new String[0]), Globals.localize("superminer.excavator.tool_ids.desc"))));
        SettingsExcavator.lShovelIDs = new ArrayList<String>(Arrays.asList(SuperMiner_Core.configFile.getStringList(Globals.localize("superminer.excavator.shovel_ids"), MODID, SettingsExcavator.lShovelIDDefaults.toArray(new String[0]), Globals.localize("superminer.excavator.shovel_ids.desc"))));
        SettingsExcavator.iBlockRadius = SuperMiner_Core.configFile.getInt(Globals.localize("superminer.excavator.radius"), MODID, 3, 3, 16, Globals.localize("superminer.excavator.radius.desc"));
        SettingsExcavator.iBlockLimit = SuperMiner_Core.configFile.getInt(Globals.localize("superminer.excavator.limit"), MODID, 27, 27, 4096, Globals.localize("superminer.excavator.limit.desc"));
        SettingsExcavator.iPathWidth = SuperMiner_Core.configFile.getInt(Globals.localize("superminer.excavator.path_width"), MODID, 3, 1, 16, Globals.localize("superminer.excavator.path_width.desc"));
        SettingsExcavator.iPathLength = SuperMiner_Core.configFile.getInt(Globals.localize("superminer.excavator.path_length"), MODID, 6, 1, 64, Globals.localize("superminer.excavator.path_length.desc"));
        Excavator.myGlobals.lToolIDs = Globals.IDListToArray(SettingsExcavator.lToolIDs, false);
        lShovelIDs = Globals.IDListToArray(SettingsExcavator.lShovelIDs, false);
        Excavator.myGlobals.iBlockRadius = SettingsExcavator.iBlockRadius;
        Excavator.myGlobals.iBlockLimit = SettingsExcavator.iBlockLimit;
        ArrayList<String> order = new ArrayList<String>(7);
        order.add(Globals.localize("superminer.excavator.enabled"));
        order.add(Globals.localize("superminer.excavator.gather_drops"));
        order.add(Globals.localize("superminer.excavator.auto_illum"));
        order.add(Globals.localize("superminer.excavator.detect_variants"));
        order.add(Globals.localize("superminer.excavator.tool_ids"));
        order.add(Globals.localize("superminer.excavator.radius"));
        order.add(Globals.localize("superminer.excavator.limit"));
        order.add(Globals.localize("superminer.excavator.shovel_ids"));
        order.add(Globals.localize("superminer.excavator.path_width"));
        order.add(Globals.localize("superminer.excavator.path_length"));
        SuperMiner_Core.configFile.setCategoryPropertyOrder(MODID, order);
        if (!bShouldSyncSettings) {
            bShouldSyncSettings = SuperMiner_Core.configFile.hasChanged();
        }
    }

    @Mod.EventHandler
    public void imcCallback(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (!message.isStringMessage() || !message.key.equalsIgnoreCase("addShovel")) continue;
            SettingsExcavator.lShovelIDs.add(message.getStringValue());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void tickEvent(TickEvent.ClientTickEvent event) {
        EntityPlayerSP player;
        if (!PlayerEvents.IsPlayerInWorld() || Shaftanator.bToggled || !SettingsExcavator.bEnabled || !TickEvent.Phase.END.equals((Object)event.phase)) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (!mc.field_71415_G || mc.func_147113_T()) {
            return;
        }
        if (bShouldSyncSettings) {
            Globals.sendPacket(new CPacketCustomPayload(ChannelName, SettingsExcavator.writePacketData()));
            bShouldSyncSettings = false;
        }
        if (null == (player = mc.field_71439_g) || player.field_70128_L || player.func_70608_bn()) {
            return;
        }
        WorldClient world = mc.field_71441_e;
        if (world != null) {
            bToggled = KeyBindings.excavator_toggle.func_151470_d();
            bLayerOnlyToggled = KeyBindings.excavator_layer_only_toggle.func_151470_d();
            GodItems.isWorthy(bToggled);
            IBlockState state = null;
            Block block = null;
            BlockPos oPos = null;
            if (Excavator.isToggled() && (Globals.isAttacking(mc) || Globals.isUsingItem(mc)) && player.func_110143_aJ() > 0.0f && mc.field_71476_x != null && mc.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK) {
                oPos = mc.field_71476_x.func_178782_a();
                state = world.func_180495_p(oPos);
                block = state.func_177230_c();
                if (!Globals.isAttacking(mc) && block != null && block == Blocks.field_150350_a) {
                    block = null;
                }
                if (block != null) {
                    if (!this.bHungerNotified && player.func_71024_bL().func_75116_a() <= 1) {
                        Globals.NotifyClient(Globals.tooHungry() + MODName);
                        this.bHungerNotified = true;
                        return;
                    }
                    if (player.func_71024_bL().func_75116_a() > 1) {
                        if (player.func_184614_ca() != null && Globals.isIdInList(player.func_184614_ca().func_77973_b(), lShovelIDs) && Globals.isUsingItem(mc) && (block == Blocks.field_150349_c || block == Blocks.field_150346_d)) {
                            Globals.sendPacket(new CPacketCustomPayload(ChannelName, new AutoFurrowPacket(PacketIDs.Excavator_ShovelPacket.value(), oPos).writePacketData()));
                        } else {
                            myGlobals.addAttackBlock((EntityPlayer)player, state, oPos, mc.field_71476_x.field_178784_b, false, false, false, bLayerOnlyToggled);
                        }
                    }
                } else {
                    this.bHungerNotified = false;
                }
            }
            Iterator attackPackets = Excavator.myGlobals.attackHistory.iterator();
            while (attackPackets.hasNext()) {
                SMPacket packet = (SMPacket)attackPackets.next();
                if (System.nanoTime() - packet.nanoTime >= 3000000000L) {
                    attackPackets.remove();
                    continue;
                }
                block = world.func_180495_p(packet.oPos).func_177230_c();
                if (block != null && block != Blocks.field_150350_a) continue;
                attackPackets.remove();
                packet.block = packet.prevBlock;
                packet.bLayerOnlyToggled = bLayerOnlyToggled;
                Globals.sendPacket(new CPacketCustomPayload(ChannelName, packet.writePacketData()));
            }
        }
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        PacketBuffer payLoad = new PacketBuffer(event.getPacket().payload());
        int iPacketID = payLoad.copy().readInt();
        if (iPacketID == PacketIDs.Settings_Excavator.value()) {
            SettingsExcavator.readPacketData(payLoad);
            Excavator.myGlobals.lToolIDs = Globals.IDListToArray(SettingsExcavator.lToolIDs, false);
            Excavator.myGlobals.iBlockRadius = SettingsExcavator.iBlockRadius;
            Excavator.myGlobals.iBlockLimit = SettingsExcavator.iBlockLimit;
        } else if (SettingsExcavator.bEnabled) {
            EntityPlayerMP player = ((NetHandlerPlayServer)event.getHandler()).field_147369_b;
            if (iPacketID == PacketIDs.BLOCKINFO.value()) {
                SMPacket packet = new SMPacket();
                packet.readPacketData(payLoad);
                this.Excavate(packet, player);
            } else if (iPacketID == PacketIDs.Excavator_ShovelPacket.value()) {
                AutoFurrowPacket packet = new AutoFurrowPacket();
                packet.readPacketData(payLoad);
                Excavator.LayThePath(packet, (EntityPlayer)player);
            } else if (iPacketID == PacketIDs.GODITEMS.value()) {
                GodItems.GiveGodTools((EntityPlayer)player);
            }
        }
    }

    protected void Excavate(SMPacket packet, EntityPlayerMP player) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (null == server) {
            return;
        }
        WorldServer world = server.func_71218_a(player.field_71093_bK);
        if (world == null || !Excavator.isAllowedToMine((EntityPlayer)player, packet.block)) {
            return;
        }
        ExcavationHelper oEH = new ExcavationHelper((World)world, player, packet);
        myExcavationHelpers.add(oEH);
        oEH.getExcavationBlocks();
        if (!oEH.ExcavateSection()) {
            oEH.FinalizeExcavation();
        }
    }

    @SubscribeEvent
    public void tickEvent_Server(TickEvent.ServerTickEvent event) {
        if (TickEvent.Phase.END.equals((Object)event.phase) && myExcavationHelpers.size() > 0) {
            for (ExcavationHelper oEH : Excavator.getMyExcavationHelpers()) {
                if (!oEH.isExcavating() || oEH.ExcavateSection()) continue;
                oEH.FinalizeExcavation();
                myExcavationHelpers.remove(oEH);
            }
        }
    }

    private static boolean isAllowedToMine(EntityPlayer player, Block block) {
        IBlockState state = block.func_176194_O().func_177621_b();
        if (null == block || Blocks.field_150350_a == block || state.func_185904_a().func_76224_d() || Blocks.field_150357_h == block) {
            return false;
        }
        return player.func_184823_b(state);
    }

    private static void LayThePath(AutoFurrowPacket oPacket, EntityPlayer player) {
        BlockPos blockPos;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (null == server) {
            return;
        }
        WorldServer world = server.func_71218_a(player.field_71093_bK);
        if (world == null) {
            return;
        }
        Excavator.getPathableLand((World)world, player, oPacket);
        ItemStack curItem = player.func_184614_ca();
        int iPathableFound = oPacket.lstPositions.size();
        int iPathed = 0;
        while (iPathed <= iPathableFound && (blockPos = oPacket.lstPositions.poll()) != null) {
            if (world.func_180495_p(blockPos.func_177984_a()).func_177230_c() == Blocks.field_150350_a) {
                Block blkPathLand = Blocks.field_185774_da;
                Globals.playSound((World)world, SoundEvents.field_187575_bT, blockPos);
                world.func_175656_a(blockPos, blkPathLand.func_176223_P());
                if (curItem != null && curItem.func_77984_f()) {
                    curItem.func_77972_a(1, (EntityLivingBase)player);
                }
                if (curItem.func_77958_k() <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                    player.field_71070_bA.func_75142_b();
                    break;
                }
            }
            if (++iPathed <= iPathableFound) continue;
            break;
        }
        oPacket.lstPositions.clear();
    }

    private static void getPathableLand(World world, EntityPlayer player, AutoFurrowPacket oPacket) {
        EnumFacing facing = player.func_174811_aO();
        boolean bIsWidthEven = (SettingsExcavator.iPathWidth & 1) == 0;
        int iHalfWidth = (bIsWidthEven ? SettingsExcavator.iPathWidth : SettingsExcavator.iPathWidth - 1) / 2;
        int iYOffset = 0;
        for (int iLengthOffset = 0; iLengthOffset < SettingsExcavator.iPathLength; ++iLengthOffset) {
            int iWidthOffset;
            int n = iWidthOffset = bIsWidthEven ? -(iHalfWidth - 1) : -iHalfWidth;
            while (iWidthOffset <= iHalfWidth) {
                BlockPos oPos = oPacket.oPos.func_177982_a(facing == EnumFacing.EAST ? iLengthOffset : (facing == EnumFacing.WEST ? -iLengthOffset : (facing == EnumFacing.SOUTH ? iWidthOffset : (facing == EnumFacing.NORTH ? -iWidthOffset : 0))), iYOffset, facing == EnumFacing.SOUTH ? iLengthOffset : (facing == EnumFacing.NORTH ? -iLengthOffset : (facing == EnumFacing.EAST ? iWidthOffset : (facing == EnumFacing.WEST ? -iWidthOffset : 0))));
                IBlockState state = world.func_180495_p(oPos);
                Block oBlock = state.func_177230_c();
                if ((oBlock == Blocks.field_150349_c || oBlock == Blocks.field_150346_d) && world.func_180495_p(oPos.func_177984_a()).func_177230_c() == Blocks.field_150350_a) {
                    oPacket.lstPositions.offer(oPos);
                } else {
                    BlockPos oPosOffset = oPos.func_177977_b();
                    state = world.func_180495_p(oPosOffset);
                    oBlock = state.func_177230_c();
                    if ((oBlock == Blocks.field_150349_c || oBlock == Blocks.field_150346_d) && world.func_180495_p(oPosOffset.func_177984_a()).func_177230_c() == Blocks.field_150350_a) {
                        iYOffset = -1;
                        oPacket.lstPositions.offer(oPosOffset);
                    } else {
                        oPosOffset = oPos.func_177984_a();
                        state = world.func_180495_p(oPosOffset);
                        oBlock = state.func_177230_c();
                        if ((oBlock == Blocks.field_150349_c || oBlock == Blocks.field_150346_d) && world.func_180495_p(oPosOffset.func_177984_a()).func_177230_c() == Blocks.field_150350_a) {
                            iYOffset = 1;
                            oPacket.lstPositions.offer(oPosOffset);
                        }
                    }
                }
                ++iWidthOffset;
            }
        }
    }
}

