/*
 * Decompiled with CFR 0.152.
 */
package duelmonster.superminer.submods;

import duelmonster.superminer.SuperMiner_Core;
import duelmonster.superminer.config.SettingsIlluminator;
import duelmonster.superminer.events.PlayerEvents;
import duelmonster.superminer.keys.KeyBindings;
import duelmonster.superminer.network.packets.IlluminatorPacket;
import duelmonster.superminer.network.packets.PacketIDs;
import duelmonster.superminer.objects.Globals;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="superminer_illuminator", name="Illuminator", version="[1.10.2]-2.1.4.090", acceptedMinecraftVersions="[1.10.2]")
public class Illuminator {
    public static final String MODID = "superminer_illuminator";
    public static final String MODName = "Illuminator";
    public static final String ChannelName = "superminer_illuminator".substring(0, "superminer_illuminator".length() < 20 ? "superminer_illuminator".length() : 20);
    @Mod.Instance(value="superminer_illuminator")
    private Illuminator instance;
    private static BlockPos lastTorchLocation = null;
    public static boolean bShouldSyncSettings = true;
    private static boolean bIsPlacingTorch = false;

    public static boolean isPlacingTorch() {
        return bIsPlacingTorch;
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        FMLEventChannel eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(ChannelName);
        eventChannel.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void syncConfig() {
        SettingsIlluminator.bEnabled = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.illuminator.enabled"), MODID, true, Globals.localize("superminer.illuminator.enabled.desc"));
        SettingsIlluminator.iLowestLightLevel = SuperMiner_Core.configFile.getInt(Globals.localize("superminer.illuminator.light_level"), MODID, 7, 0, 16, Globals.localize("superminer.illuminator.light_level.desc"));
        ArrayList<String> order = new ArrayList<String>(2);
        order.add(Globals.localize("superminer.illuminator.enabled"));
        order.add(Globals.localize("superminer.illuminator.light_level"));
        SuperMiner_Core.configFile.setCategoryPropertyOrder(MODID, order);
        if (!bShouldSyncSettings) {
            bShouldSyncSettings = SuperMiner_Core.configFile.hasChanged();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void tickEvent(TickEvent.ClientTickEvent event) {
        EntityPlayerSP player;
        if (!PlayerEvents.IsPlayerInWorld() || !TickEvent.Phase.END.equals((Object)event.phase)) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (!mc.field_71415_G || mc.func_147113_T()) {
            return;
        }
        if (bShouldSyncSettings) {
            Globals.sendPacket(new CPacketCustomPayload(ChannelName, SettingsIlluminator.writePacketData()));
            bShouldSyncSettings = false;
        }
        if (null == (player = mc.field_71439_g) || player.field_70128_L || player.func_70608_bn()) {
            return;
        }
        WorldClient world = mc.field_71441_e;
        if (world != null) {
            if (KeyBindings.illuminator_place.func_151468_f()) {
                Illuminator.PlaceTorch(mc, (EntityPlayer)player);
            } else if (bIsPlacingTorch) {
                bIsPlacingTorch = false;
            } else if (SettingsIlluminator.bEnabled || Globals.isAttacking(mc) && player.func_110143_aJ() > 0.0f) {
                int x = (int)(player.func_174813_aQ().field_72340_a + 0.5);
                int y = (int)player.func_174813_aQ().field_72338_b;
                int z = (int)(player.func_174813_aQ().field_72339_c + 0.5);
                BlockPos oPos = new BlockPos(x, y, z);
                IBlockState state = world.func_180495_p(oPos.func_177977_b());
                if (!world.func_175623_d(oPos) && !state.func_177230_c().canPlaceTorchOnTop(state, (IBlockAccess)world, oPos.func_177977_b())) {
                    x = (int)(player.func_174813_aQ().field_72340_a - 0.5);
                    z = (int)(player.func_174813_aQ().field_72339_c - 0.5);
                    oPos = new BlockPos(x, y, z);
                    state = world.func_180495_p(oPos.func_177977_b());
                    if (!world.func_175623_d(oPos) && !state.func_177230_c().canPlaceTorchOnTop(state, (IBlockAccess)world, oPos.func_177977_b())) {
                        x = (int)(player.func_174813_aQ().field_72340_a + 0.5);
                        z = (int)(player.func_174813_aQ().field_72339_c - 0.5);
                        oPos = new BlockPos(x, y, z);
                        state = world.func_180495_p(oPos.func_177977_b());
                        if (!world.func_175623_d(oPos) && !state.func_177230_c().canPlaceTorchOnTop(state, (IBlockAccess)world, oPos.func_177977_b())) {
                            x = (int)(player.func_174813_aQ().field_72340_a - 0.5);
                            z = (int)(player.func_174813_aQ().field_72339_c + 0.5);
                            oPos = new BlockPos(x, y, z);
                            state = world.func_180495_p(oPos.func_177977_b());
                        }
                    }
                }
                if (world.func_175699_k(oPos) <= SettingsIlluminator.iLowestLightLevel && world.func_175623_d(oPos) && state.func_177230_c().canPlaceTorchOnTop(state, (IBlockAccess)world, oPos.func_177977_b())) {
                    Globals.sendPacket(new CPacketCustomPayload(ChannelName, new IlluminatorPacket(oPos).writePacketData()));
                }
            }
        } else {
            lastTorchLocation = null;
        }
    }

    @SubscribeEvent
    public void severTickEvent(TickEvent.ServerTickEvent event) {
        if (!SettingsIlluminator.bEnabled || !TickEvent.Phase.END.equals((Object)event.phase)) {
            return;
        }
        for (FMLInterModComms.IMCMessage imcMessage : FMLInterModComms.fetchRuntimeMessages((Object)this.instance)) {
            this.processIMC(imcMessage);
        }
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        PacketBuffer payLoad = new PacketBuffer(event.getPacket().payload());
        int iPacketID = payLoad.copy().readInt();
        if (iPacketID == PacketIDs.Settings_Illuminator.value()) {
            SettingsIlluminator.readPacketData(payLoad);
        } else if (SettingsIlluminator.bEnabled && iPacketID == 1) {
            IlluminatorPacket iPacket = new IlluminatorPacket();
            iPacket.readPacketData(payLoad);
            Illuminator.Illuminate((EntityPlayer)((NetHandlerPlayServer)event.getHandler()).field_147369_b, iPacket.oPos, iPacket.sideHit);
        }
    }

    protected static void Illuminate(EntityPlayer player, BlockPos oPos, EnumFacing sideHit) {
        ItemStack stack;
        int i;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (null == server) {
            return;
        }
        WorldServer world = server.func_71218_a(player.field_71093_bK);
        if (world == null) {
            return;
        }
        int iTorchStackCount = 0;
        int iTorchIndx = -1;
        for (i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            stack = player.field_71071_by.field_70462_a[i];
            if (stack == null || !stack.func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150478_aa))) continue;
            ++iTorchStackCount;
            iTorchIndx = player.field_71071_by.func_184429_b(stack);
        }
        if (iTorchIndx == -1) {
            for (i = 0; i < player.field_71071_by.field_184439_c.length; ++i) {
                stack = player.field_71071_by.field_184439_c[i];
                if (stack == null || !stack.func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150478_aa))) continue;
                ++iTorchStackCount;
                iTorchIndx = player.field_71071_by.func_184429_b(stack);
            }
        }
        if (iTorchIndx >= 0 && !oPos.equals((Object)lastTorchLocation)) {
            lastTorchLocation = new BlockPos((Vec3i)oPos);
            world.func_175656_a(oPos, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)sideHit));
            Globals.playSound((World)world, SoundEvents.field_187889_gU, oPos);
            ItemStack torchStack = player.field_71071_by.func_70298_a(iTorchIndx, 1);
            if (torchStack.field_77994_a <= 0) {
                lastTorchLocation = null;
                --iTorchStackCount;
            }
            if (iTorchStackCount == 0) {
                player.func_145747_a((ITextComponent)new TextComponentString("\u00a75[SuperMiner] \u00a76Illuminator: \u00a7c" + Globals.localize("superminer.illuminator.no_torches")));
            }
        }
    }

    public void processIMC(FMLInterModComms.IMCMessage imcMessage) {
        if (imcMessage.key.equalsIgnoreCase("IlluminateShaft") && imcMessage.isNBTMessage()) {
            NBTTagCompound nbt = imcMessage.getNBTValue();
            IlluminatorPacket iPacket = new IlluminatorPacket();
            iPacket.readPacketData(new PacketBuffer(Unpooled.copiedBuffer((byte[])nbt.func_74770_j("IlluminateShaftData"))));
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (null == server) {
                return;
            }
            EntityPlayer player = (EntityPlayer)server.func_130014_f_().func_73045_a(iPacket.playerID);
            if (player == null) {
                return;
            }
            WorldServer world = server.func_71218_a(player.field_71093_bK);
            if (world == null) {
                return;
            }
            int x = (int)((float)iPacket.oPos.func_177958_n() + 0.5f);
            int y = iPacket.oPos.func_177956_o();
            int z = (int)((float)iPacket.oPos.func_177952_p() + 0.5f);
            BlockPos oPos = new BlockPos(x, y, z);
            IBlockState state = world.func_180495_p(oPos.func_177977_b());
            if (!world.func_175623_d(oPos) && !state.func_177230_c().canPlaceTorchOnTop(state, (IBlockAccess)world, oPos.func_177977_b())) {
                x = (int)(player.func_174813_aQ().field_72340_a - 0.5);
                z = (int)(player.func_174813_aQ().field_72339_c - 0.5);
                oPos = new BlockPos(x, y, z);
                state = world.func_180495_p(oPos.func_177977_b());
                if (!world.func_175623_d(oPos) && !state.func_177230_c().canPlaceTorchOnTop(state, (IBlockAccess)world, oPos.func_177977_b())) {
                    x = (int)(player.func_174813_aQ().field_72340_a + 0.5);
                    z = (int)(player.func_174813_aQ().field_72339_c - 0.5);
                    oPos = new BlockPos(x, y, z);
                    state = world.func_180495_p(oPos.func_177977_b());
                    if (!world.func_175623_d(oPos) && !state.func_177230_c().canPlaceTorchOnTop(state, (IBlockAccess)world, oPos.func_177977_b())) {
                        x = (int)(player.func_174813_aQ().field_72340_a - 0.5);
                        z = (int)(player.func_174813_aQ().field_72339_c + 0.5);
                        oPos = new BlockPos(x, y, z);
                        state = world.func_180495_p(oPos.func_177977_b());
                    }
                }
            }
            if (world.func_175699_k(oPos) <= SettingsIlluminator.iLowestLightLevel && world.func_175623_d(oPos) && state.func_177230_c().canPlaceTorchOnTop(state, (IBlockAccess)world, oPos.func_177977_b())) {
                Illuminator.Illuminate(player, oPos, EnumFacing.UP);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void PlaceTorch(Minecraft mc, EntityPlayer player) {
        BlockPos oPos;
        if (mc.field_71476_x != null && mc.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK && mc.field_71441_e.func_180495_p(oPos = mc.field_71476_x.func_178782_a()).func_177230_c() != Blocks.field_150478_aa) {
            EnumFacing sideHit = mc.field_71476_x.field_178784_b;
            BlockPos oSidePos = mc.field_71476_x.func_178782_a();
            if (sideHit == EnumFacing.DOWN) {
                return;
            }
            if (sideHit == EnumFacing.UP) {
                oSidePos = oPos.func_177984_a();
            } else if (sideHit == EnumFacing.NORTH) {
                oSidePos = oPos.func_177978_c();
            } else if (sideHit == EnumFacing.SOUTH) {
                oSidePos = oPos.func_177968_d();
            } else if (sideHit == EnumFacing.EAST) {
                oSidePos = oPos.func_177974_f();
            } else if (sideHit == EnumFacing.WEST) {
                oSidePos = oPos.func_177976_e();
            }
            if (mc.field_71441_e.func_180495_p(oPos).func_177230_c().func_176200_f((IBlockAccess)mc.field_71441_e, oPos) && mc.field_71441_e.func_180495_p(oPos.func_177977_b()).isSideSolid((IBlockAccess)mc.field_71441_e, oPos.func_177977_b(), EnumFacing.UP)) {
                Globals.sendPacket(new CPacketCustomPayload(ChannelName, new IlluminatorPacket(oPos, EnumFacing.UP).writePacketData()));
            } else if (mc.field_71441_e.func_175623_d(oSidePos) && mc.field_71441_e.func_180495_p(oPos).isSideSolid((IBlockAccess)mc.field_71441_e, oPos, sideHit)) {
                Globals.sendPacket(new CPacketCustomPayload(ChannelName, new IlluminatorPacket(oSidePos, sideHit).writePacketData()));
            }
        }
    }
}

