/*
 * Decompiled with CFR 0.152.
 */
package duelmonster.superminer.submods;

import duelmonster.superminer.SuperMiner_Core;
import duelmonster.superminer.config.SettingsShaftanator;
import duelmonster.superminer.events.PlayerEvents;
import duelmonster.superminer.keys.KeyBindings;
import duelmonster.superminer.network.packets.PacketIDs;
import duelmonster.superminer.network.packets.SMPacket;
import duelmonster.superminer.objects.ExcavationHelper;
import duelmonster.superminer.objects.Globals;
import duelmonster.superminer.submods.Excavator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="superminer_shaftanator", name="Shaftanator", version="[1.10.2]-2.1.4.090", acceptedMinecraftVersions="[1.10.2]")
public class Shaftanator {
    public static final String MODID = "superminer_shaftanator";
    public static final String MODName = "Shaftanator";
    public static final String ChannelName = "superminer_shaftanator".substring(0, "superminer_shaftanator".length() < 20 ? "superminer_shaftanator".length() : 20);
    public static Globals myGlobals = new Globals();
    public static boolean bToggled = false;
    private boolean bHungerNotified = false;
    public static boolean bShouldSyncSettings = true;
    private static List<ExcavationHelper> myExcavationHelpers = new ArrayList<ExcavationHelper>();

    private static List<ExcavationHelper> getMyExcavationHelpers() {
        return new ArrayList<ExcavationHelper>(myExcavationHelpers);
    }

    public static Boolean isExcavating() {
        boolean bIsExcavating = false;
        for (ExcavationHelper oEH : Shaftanator.getMyExcavationHelpers()) {
            if (bIsExcavating) continue;
            bIsExcavating = oEH != null && oEH.isExcavating();
        }
        return bIsExcavating;
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        FMLEventChannel eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(ChannelName);
        eventChannel.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void syncConfig() {
        SettingsShaftanator.bEnabled = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.shaftanator.enabled"), MODID, true, Globals.localize("superminer.shaftanator.enabled.desc"));
        SettingsShaftanator.bGatherDrops = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.shaftanator.gather_drops"), MODID, true, Globals.localize("superminer.shaftanator.gather_drops.desc"));
        SettingsShaftanator.bAutoIlluminate = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.shaftanator.auto_illum"), MODID, true, Globals.localize("superminer.shaftanator.auto_illum.desc"));
        SettingsShaftanator.bMineVeins = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.shaftanator.mine_veins"), MODID, false, Globals.localize("superminer.shaftanator.mine_veins.desc"));
        SettingsShaftanator.iShaftLength = SuperMiner_Core.configFile.getInt(Globals.localize("superminer.shaftanator.shaft_l"), MODID, 16, 4, 128, Globals.localize("superminer.shaftanator.shaft_l.desc"));
        SettingsShaftanator.iShaftHeight = SuperMiner_Core.configFile.getInt(Globals.localize("superminer.shaftanator.shaft_h"), MODID, 2, 2, 16, Globals.localize("superminer.shaftanator.shaft_l.desc"));
        SettingsShaftanator.iShaftWidth = SuperMiner_Core.configFile.getInt(Globals.localize("superminer.shaftanator.shaft_w"), MODID, 1, 1, 16, Globals.localize("superminer.shaftanator.shaft_w.desc"));
        ArrayList<String> order = new ArrayList<String>(7);
        order.add(Globals.localize("superminer.shaftanator.enabled"));
        order.add(Globals.localize("superminer.shaftanator.gather_drops"));
        order.add(Globals.localize("superminer.shaftanator.auto_illum"));
        order.add(Globals.localize("superminer.shaftanator.mine_veins"));
        order.add(Globals.localize("superminer.shaftanator.shaft_l"));
        order.add(Globals.localize("superminer.shaftanator.shaft_h"));
        order.add(Globals.localize("superminer.shaftanator.shaft_w"));
        SuperMiner_Core.configFile.setCategoryPropertyOrder(MODID, order);
        if (!bShouldSyncSettings) {
            bShouldSyncSettings = SuperMiner_Core.configFile.hasChanged();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void tickEvent(TickEvent.ClientTickEvent event) {
        EntityPlayerSP player;
        if (!PlayerEvents.IsPlayerInWorld() || Excavator.isToggled() || !SettingsShaftanator.bEnabled || !TickEvent.Phase.END.equals((Object)event.phase)) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (!mc.field_71415_G || mc.func_147113_T()) {
            return;
        }
        if (bShouldSyncSettings) {
            Globals.sendPacket(new CPacketCustomPayload(ChannelName, SettingsShaftanator.writePacketData()));
            bShouldSyncSettings = false;
        }
        if (null == (player = mc.field_71439_g) || player.field_70128_L || player.func_70608_bn()) {
            return;
        }
        WorldClient world = mc.field_71441_e;
        if (world != null) {
            bToggled = KeyBindings.shaftanator_toggle.func_151470_d();
            IBlockState state = null;
            Block block = null;
            BlockPos oPos = null;
            if (bToggled && player.func_110143_aJ() > 0.0f && mc.field_71476_x != null && mc.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK) {
                oPos = mc.field_71476_x.func_178782_a();
                state = world.func_180495_p(oPos);
                block = state.func_177230_c();
                if (!Globals.isAttacking(mc) && block != null && block == Blocks.field_150350_a) {
                    block = null;
                }
                if (block != null) {
                    EnumFacing sideHit = mc.field_71476_x.field_178784_b;
                    if ((sideHit == EnumFacing.NORTH || sideHit == EnumFacing.EAST || sideHit == EnumFacing.SOUTH || sideHit == EnumFacing.WEST) && (double)oPos.func_177956_o() >= player.func_174813_aQ().field_72338_b && (double)oPos.func_177956_o() < player.func_174813_aQ().field_72338_b + (double)SettingsShaftanator.iShaftHeight) {
                        if (!this.bHungerNotified && player.func_71024_bL().func_75116_a() <= 1) {
                            Globals.NotifyClient(Globals.tooHungry() + MODName);
                            this.bHungerNotified = true;
                            return;
                        }
                        if (player.func_71024_bL().func_75116_a() > 1) {
                            myGlobals.addAttackBlock((EntityPlayer)player, state, oPos, sideHit, false, false, false, false);
                        }
                    }
                } else {
                    this.bHungerNotified = false;
                }
            }
            Iterator attackPackets = Shaftanator.myGlobals.attackHistory.iterator();
            while (attackPackets.hasNext()) {
                SMPacket packet = (SMPacket)attackPackets.next();
                if (System.nanoTime() - packet.nanoTime >= 3000000000L) {
                    attackPackets.remove();
                    continue;
                }
                block = world.func_180495_p(packet.oPos).func_177230_c();
                if (block != null && block != Blocks.field_150350_a) continue;
                attackPackets.remove();
                packet.block = packet.prevBlock;
                Globals.sendPacket(new CPacketCustomPayload(ChannelName, packet.writePacketData()));
            }
        }
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        PacketBuffer payLoad = new PacketBuffer(event.getPacket().payload());
        int iPacketID = payLoad.copy().readInt();
        if (iPacketID == PacketIDs.Settings_Shaftanator.value()) {
            SettingsShaftanator.readPacketData(payLoad);
        } else if (SettingsShaftanator.bEnabled && iPacketID == PacketIDs.BLOCKINFO.value()) {
            SMPacket packet = new SMPacket();
            packet.readPacketData(payLoad);
            this.Perforate(packet, ((NetHandlerPlayServer)event.getHandler()).field_147369_b);
        }
    }

    protected void Perforate(SMPacket packet, EntityPlayerMP player) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (null == server) {
            return;
        }
        WorldServer world = server.func_71218_a(player.field_71093_bK);
        if (world == null || !Shaftanator.isAllowedToMine((EntityPlayer)player, packet.block)) {
            return;
        }
        ExcavationHelper oEH = new ExcavationHelper((World)world, player, packet);
        myExcavationHelpers.add(oEH);
        oEH.getShaftBlocks();
        if (!oEH.ExcavateSection()) {
            oEH.FinalizeShaft();
        }
    }

    @SubscribeEvent
    public void tickEvent_Server(TickEvent.ServerTickEvent event) {
        if (TickEvent.Phase.END.equals((Object)event.phase) && myExcavationHelpers.size() > 0) {
            for (ExcavationHelper oEH : Shaftanator.getMyExcavationHelpers()) {
                if (!oEH.isExcavating() || oEH.ExcavateSection()) continue;
                oEH.FinalizeShaft();
                myExcavationHelpers.remove(oEH);
            }
        }
    }

    private static boolean isAllowedToMine(EntityPlayer player, Block block) {
        IBlockState state = block.func_176194_O().func_177621_b();
        if (null == block || Blocks.field_150350_a == block || state.func_185904_a().func_76224_d() || Blocks.field_150357_h == block) {
            return false;
        }
        return player.func_184823_b(state);
    }
}

