/*
 * Decompiled with CFR 0.152.
 */
package duelmonster.superminer.submods;

import duelmonster.superminer.SuperMiner_Core;
import duelmonster.superminer.config.SettingsVeinator;
import duelmonster.superminer.events.PlayerEvents;
import duelmonster.superminer.network.packets.PacketIDs;
import duelmonster.superminer.network.packets.SMPacket;
import duelmonster.superminer.objects.Globals;
import duelmonster.superminer.submods.Excavator;
import duelmonster.superminer.submods.Shaftanator;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

@Mod(modid="superminer_veinator", name="Veinator", version="[1.10.2]-2.1.4.090", acceptedMinecraftVersions="[1.10.2]")
public class Veinator {
    public static final String MODID = "superminer_veinator";
    public static final String MODName = "Veinator";
    public static final String ChannelName = "superminer_veinator".substring(0, "superminer_veinator".length() < 20 ? "superminer_veinator".length() : 20);
    @Mod.Instance(value="superminer_veinator")
    private Veinator instance;
    private static boolean bOresGot = false;
    public static Globals myGlobals = new Globals();
    private boolean bHungerNotified = false;
    public static boolean bShouldSyncSettings = true;
    private static boolean bMiningVein = false;

    public static boolean isMiningVein() {
        return bMiningVein;
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        FMLEventChannel eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(ChannelName);
        eventChannel.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void syncConfig() {
        SettingsVeinator.bEnabled = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.veinator.enabled"), MODID, true, Globals.localize("superminer.veinator.enabled.desc"));
        SettingsVeinator.bGatherDrops = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.veinator.gather_drops"), MODID, false, Globals.localize("superminer.veinator.gather_drops"));
        SettingsVeinator.lToolIDs = new ArrayList<String>(Arrays.asList(SuperMiner_Core.configFile.getStringList(Globals.localize("superminer.veinator.tool_ids"), MODID, SettingsVeinator.lToolIDDefaults.toArray(new String[0]), Globals.localize("superminer.veinator.tool_ids.desc"))));
        SettingsVeinator.lOreIDs = new ArrayList<String>(Arrays.asList(SuperMiner_Core.configFile.getStringList(Globals.localize("superminer.veinator.ore_ids"), MODID, SettingsVeinator.lOreIDDefaults.toArray(new String[0]), Globals.localize("superminer.veinator.ore_ids.desc"))));
        Veinator.myGlobals.lToolIDs = Globals.IDListToArray(SettingsVeinator.lToolIDs, false);
        Veinator.myGlobals.lBlockIDs = Globals.IDListToArray(SettingsVeinator.lOreIDs, true);
        ArrayList<String> order = new ArrayList<String>(4);
        order.add(Globals.localize("superminer.veinator.enabled"));
        order.add(Globals.localize("superminer.veinator.gather_drops"));
        order.add(Globals.localize("superminer.veinator.tool_ids"));
        order.add(Globals.localize("superminer.veinator.ore_ids"));
        SuperMiner_Core.configFile.setCategoryPropertyOrder(MODID, order);
        if (!bShouldSyncSettings) {
            bShouldSyncSettings = SuperMiner_Core.configFile.hasChanged();
        }
        if (!bOresGot) {
            String[] saOreNames;
            bOresGot = true;
            for (String sOreName : saOreNames = OreDictionary.getOreNames()) {
                if (!sOreName.startsWith("ore")) continue;
                for (ItemStack item : OreDictionary.getOres((String)sOreName)) {
                    String sID;
                    boolean bMCIncluded;
                    if (!(item.func_77973_b() instanceof ItemBlock) || (!(bMCIncluded = (sID = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)item.func_77973_b())).toString().trim()).startsWith("minecraft:")) || SettingsVeinator.lOreIDs.contains(sID.substring(10))) && (bMCIncluded || SettingsVeinator.lOreIDs.contains(sID))) continue;
                    SettingsVeinator.lOreIDs.add(sID);
                    SuperMiner_Core.configFile.get(MODID, Globals.localize("superminer.veinator.ore_ids"), SettingsVeinator.lOreIDDefaults.toArray(new String[0]), Globals.localize("superminer.veinator.ore_ids.desc")).set(SettingsVeinator.lOreIDs.toArray(new String[0]));
                    SuperMiner_Core.configFile.save();
                    try {
                        int id = Integer.parseInt(sID.trim());
                        Veinator.myGlobals.lBlockIDs.add(Block.field_149771_c.func_148754_a(id));
                    }
                    catch (NumberFormatException e) {
                        Veinator.myGlobals.lBlockIDs.add(Block.field_149771_c.func_82594_a((Object)new ResourceLocation(sID)));
                    }
                }
            }
        }
    }

    @Mod.EventHandler
    public void imcCallback(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (!message.isStringMessage() || !message.key.equalsIgnoreCase("addPickaxe") || SettingsVeinator.lToolIDs.contains(message.getStringValue())) continue;
            SettingsVeinator.lToolIDs.add(message.getStringValue());
            SuperMiner_Core.configFile.get(MODID, Globals.localize("superminer.veinator.tool_ids"), SettingsVeinator.lToolIDDefaults.toArray(new String[0]), Globals.localize("superminer.veinator.tool_ids.desc")).set(SettingsVeinator.lToolIDs.toArray(new String[0]));
            SuperMiner_Core.configFile.save();
            try {
                int id = Integer.parseInt(message.getStringValue());
                Veinator.myGlobals.lToolIDs.add(Item.field_150901_e.func_148754_a(id));
            }
            catch (NumberFormatException e) {
                Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(message.getStringValue()));
                if (item == null) continue;
                Veinator.myGlobals.lToolIDs.add(item);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void tickEvent(TickEvent.ClientTickEvent event) {
        EntityPlayerSP player;
        if (!PlayerEvents.IsPlayerInWorld() || Excavator.isToggled() || Shaftanator.bToggled || !SettingsVeinator.bEnabled || !TickEvent.Phase.END.equals((Object)event.phase)) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (!mc.field_71415_G || mc.func_147113_T()) {
            return;
        }
        if (bShouldSyncSettings) {
            Globals.sendPacket(new CPacketCustomPayload(ChannelName, SettingsVeinator.writePacketData()));
            bShouldSyncSettings = false;
        }
        if (null == (player = mc.field_71439_g) || player.field_70128_L || player.func_70608_bn()) {
            return;
        }
        WorldClient world = mc.field_71441_e;
        if (world != null) {
            IBlockState state = null;
            Block block = null;
            BlockPos oPos = null;
            if (player.func_110143_aJ() > 0.0f && mc.field_71476_x != null && mc.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK) {
                oPos = mc.field_71476_x.func_178782_a();
                state = world.func_180495_p(oPos);
                block = state.func_177230_c();
                if (!Globals.isAttacking(mc) && block != null && block == Blocks.field_150350_a) {
                    block = null;
                }
            }
            if (block != null && Globals.isIdInList(block, Veinator.myGlobals.lBlockIDs)) {
                if (!this.bHungerNotified && player.func_71024_bL().func_75116_a() <= 1) {
                    Globals.NotifyClient(Globals.tooHungry() + MODName);
                    this.bHungerNotified = true;
                    return;
                }
                if (player.func_71024_bL().func_75116_a() > 1) {
                    myGlobals.addAttackBlock((EntityPlayer)player, state, oPos, false, true, true, false);
                }
            } else {
                this.bHungerNotified = false;
            }
            Iterator attackPackets = Veinator.myGlobals.attackHistory.iterator();
            while (attackPackets.hasNext()) {
                SMPacket packet = (SMPacket)attackPackets.next();
                if (System.nanoTime() - packet.nanoTime >= 3000000000L) {
                    attackPackets.remove();
                    continue;
                }
                block = world.func_180495_p(new BlockPos(packet.oPos.func_177958_n(), packet.oPos.func_177956_o(), packet.oPos.func_177952_p())).func_177230_c();
                if (block != null && block != Blocks.field_150350_a) continue;
                attackPackets.remove();
                Globals.sendPacket(new CPacketCustomPayload(ChannelName, packet.writePacketData()));
            }
        }
    }

    @SubscribeEvent
    public void severTickEvent(TickEvent.ServerTickEvent event) {
        if (!SettingsVeinator.bEnabled || !TickEvent.Phase.END.equals((Object)event.phase)) {
            return;
        }
        for (FMLInterModComms.IMCMessage imcMessage : FMLInterModComms.fetchRuntimeMessages((Object)this.instance)) {
            this.processIMC(imcMessage);
        }
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        PacketBuffer payLoad = new PacketBuffer(event.getPacket().payload());
        int iPacketID = payLoad.copy().readInt();
        if (iPacketID == PacketIDs.Settings_Veinator.value()) {
            SettingsVeinator.readPacketData(payLoad);
            Veinator.myGlobals.lToolIDs = Globals.IDListToArray(SettingsVeinator.lToolIDs, false);
            Veinator.myGlobals.lBlockIDs = Globals.IDListToArray(SettingsVeinator.lOreIDs, true);
        } else if (SettingsVeinator.bEnabled && iPacketID == PacketIDs.BLOCKINFO.value()) {
            SMPacket packet = new SMPacket();
            packet.readPacketData(payLoad);
            Veinator.executeVeinator(packet, ((NetHandlerPlayServer)event.getHandler()).field_147369_b);
        }
    }

    protected static void executeVeinator(SMPacket p, EntityPlayerMP player) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (null == server) {
            return;
        }
        WorldServer world = server.func_71218_a(player.field_71093_bK);
        if (!Veinator.isAllowedToMine((EntityPlayer)player, p)) {
            return;
        }
        Veinator.mineVein((World)world, player, p);
        myGlobals.clearHistory();
    }

    private static boolean isAllowedToMine(EntityPlayer player, SMPacket p) {
        IBlockState state = player.field_70170_p.func_180495_p(p.oPos);
        Block block = state.func_177230_c();
        if (null == block || Blocks.field_150350_a == block || Blocks.field_150357_h == block) {
            return false;
        }
        state = block.func_176221_a(state, (IBlockAccess)player.field_70170_p, p.oPos);
        ItemStack oEquippedItem = player.func_184614_ca();
        if (state.func_185904_a().func_76229_l() || oEquippedItem == null || oEquippedItem.field_77994_a <= 0 || !Globals.isIdInList(oEquippedItem.func_77973_b(), Veinator.myGlobals.lToolIDs) || !oEquippedItem.func_150998_b(state) || !ForgeHooks.canToolHarvestBlock((IBlockAccess)player.field_70170_p, (BlockPos)p.oPos, (ItemStack)oEquippedItem)) {
            return false;
        }
        if (p.flag_rs) {
            return Globals.isIdInList(Blocks.field_150450_ax, Veinator.myGlobals.lBlockIDs) || Globals.isIdInList(Blocks.field_150439_ay, Veinator.myGlobals.lBlockIDs);
        }
        return Globals.isIdInList(block, Veinator.myGlobals.lBlockIDs);
    }

    private static void mineVein(World world, EntityPlayerMP player, SMPacket packet) {
        List<Entity> list;
        bMiningVein = true;
        myGlobals.checkConnection(world, packet.oPos, packet, true);
        while (Veinator.breakBlock(world, player, packet)) {
        }
        packet.positions.clear();
        Globals.stackItems(world, (EntityPlayer)player, new AxisAlignedBB((double)packet.oPos.func_177958_n(), (double)packet.oPos.func_177956_o(), (double)packet.oPos.func_177952_p(), (double)packet.oPos.func_177958_n(), (double)packet.oPos.func_177956_o(), (double)packet.oPos.func_177952_p()).func_72314_b(16.0, 16.0, 16.0));
        if (SettingsVeinator.bGatherDrops && (list = Globals.getNearbyEntities(world, player.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0))) != null && !list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.field_70128_L) continue;
                entity.func_70107_b((double)packet.oPos.func_177958_n(), (double)packet.oPos.func_177956_o(), (double)packet.oPos.func_177952_p());
            }
        }
        bMiningVein = false;
    }

    private static boolean breakBlock(World world, EntityPlayerMP player, SMPacket p) {
        BlockPos blockPos = p.positions.poll();
        if (blockPos == null) {
            return false;
        }
        IBlockState state = world.func_180495_p(blockPos);
        if (Globals.checkBlock(state, p)) {
            ++p.count;
            while (SuperMiner_Core.isMCTicking()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!world.func_175623_d(blockPos)) {
                player.field_71134_c.func_180237_b(blockPos);
            }
            myGlobals.checkConnection(world, blockPos, p, true);
        }
        return true;
    }

    public void processIMC(FMLInterModComms.IMCMessage imcMessage) {
        if (imcMessage.key.equalsIgnoreCase("MineVein") && imcMessage.isNBTMessage()) {
            NBTTagCompound nbt = imcMessage.getNBTValue();
            SMPacket iPacket = new SMPacket();
            iPacket.readPacketData(new PacketBuffer(Unpooled.copiedBuffer((byte[])nbt.func_74770_j("MineVein"))));
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (null == server) {
                return;
            }
            EntityPlayerMP player = (EntityPlayerMP)server.func_130014_f_().func_73045_a(iPacket.playerID);
            if (player == null) {
                return;
            }
            Veinator.executeVeinator(iPacket, player);
        }
    }
}

