/*
 * Decompiled with CFR 0.152.
 */
package noppes.mpm;

import java.net.InetAddress;
import java.net.UnknownHostException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import noppes.mpm.ModelData;
import noppes.mpm.Server;
import noppes.mpm.client.AnalyticsTracking;
import noppes.mpm.constants.EnumAnimation;
import noppes.mpm.constants.EnumPackets;

public class ServerTickHandler {
    private String serverName = null;

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.CLIENT || event.phase == TickEvent.Phase.START) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        ModelData data = ModelData.get((EntityPlayer)player);
        ItemStack item = player.field_71071_by.field_70462_a[0];
        if (data.backItem != item) {
            if (item == null) {
                Server.sendAssociatedData((Entity)player, EnumPackets.BACK_ITEM_REMOVE, player.func_110124_au());
            } else {
                NBTTagCompound tag = item.func_77955_b(new NBTTagCompound());
                Server.sendAssociatedData((Entity)player, EnumPackets.BACK_ITEM_UPDATE, player.func_110124_au(), tag);
            }
            data.backItem = item;
        }
        data.eyes.update((EntityPlayer)player);
        if (data.animation != EnumAnimation.NONE) {
            ServerTickHandler.checkAnimation((EntityPlayer)player, data);
        }
        data.prevPosX = player.field_70165_t;
        data.prevPosY = player.field_70163_u;
        data.prevPosZ = player.field_70161_v;
    }

    public static void checkAnimation(EntityPlayer player, ModelData data) {
        boolean isJumping;
        if (data.prevPosY <= 0.0 || player.field_70173_aa < 40) {
            return;
        }
        double motionX = data.prevPosX - player.field_70165_t;
        double motionY = data.prevPosY - player.field_70163_u;
        double motionZ = data.prevPosZ - player.field_70161_v;
        double speed = motionX * motionX + motionZ * motionZ;
        boolean bl = isJumping = motionY * motionY > 0.08;
        if (data.animationTime > 0) {
            --data.animationTime;
        }
        if (player.func_70608_bn() || player.func_184218_aH() || data.animationTime == 0 || data.animation == EnumAnimation.BOW && player.func_70093_af()) {
            data.setAnimation(EnumAnimation.NONE);
        }
        if (!isJumping && player.func_70093_af() && (data.animation == EnumAnimation.HUG || data.animation == EnumAnimation.CRAWLING || data.animation == EnumAnimation.SITTING || data.animation == EnumAnimation.DANCING)) {
            return;
        }
        if (speed > 0.01 || isJumping || player.func_70608_bn() || player.func_184218_aH() || data.isSleeping() && speed > 0.001) {
            data.setAnimation(EnumAnimation.NONE);
        }
    }

    @SubscribeEvent
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (this.serverName == null) {
            String e = "local";
            MinecraftServer server = event.player.func_184102_h();
            if (server.func_71262_S()) {
                try {
                    e = InetAddress.getByName(server.func_71211_k()).getCanonicalHostName();
                }
                catch (UnknownHostException e1) {
                    e = server.func_71211_k();
                }
                if (server.func_71215_F() != 25565) {
                    e = e + ":" + server.func_71215_F();
                }
            }
            if (e == null || e.startsWith("192.168") || e.contains("127.0.0.1") || e.startsWith("localhost")) {
                e = "local";
            }
            this.serverName = e;
        }
        AnalyticsTracking.sendData(event.player, "join", this.serverName);
    }
}

