/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.client.render;

import info.ata4.minecraft.dragon.client.model.DragonModel;
import info.ata4.minecraft.dragon.client.model.DragonModelMode;
import info.ata4.minecraft.dragon.client.render.breeds.DefaultDragonBreedRenderer;
import info.ata4.minecraft.dragon.server.block.BlockDragonBreedEgg;
import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import info.ata4.minecraft.dragon.server.entity.breeds.EnumDragonBreed;
import info.ata4.minecraft.dragon.server.entity.helper.DragonLifeStageHelper;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class DragonRenderer
extends RenderLiving<EntityTameableDragon> {
    public static final String TEX_BASE = "textures/entities/dragon/";
    private final Map<EnumDragonBreed, DefaultDragonBreedRenderer> breedRenderers = new EnumMap<EnumDragonBreed, DefaultDragonBreedRenderer>(EnumDragonBreed.class);

    public DragonRenderer(RenderManager renderManager) {
        super(renderManager, null, 2.0f);
        for (EnumDragonBreed breed : EnumDragonBreed.values()) {
            if (this.breedRenderers.containsKey((Object)breed)) continue;
            this.breedRenderers.put(breed, new DefaultDragonBreedRenderer(this, breed));
        }
    }

    public DefaultDragonBreedRenderer getBreedRenderer(EntityTameableDragon dragon) {
        return this.breedRenderers.get((Object)dragon.getBreedType());
    }

    public void doRender(EntityTameableDragon dragon, double x, double y, double z, float yaw, float partialTicks) {
        DragonModel breedModel = this.getBreedRenderer(dragon).getModel();
        breedModel.setMode(DragonModelMode.FULL);
        this.field_77045_g = breedModel;
        this.func_177067_a((EntityLivingBase)dragon, x, y, z);
        if (dragon.isEgg()) {
            this.renderEgg(dragon, x, y, z, yaw, partialTicks);
        } else {
            super.func_76986_a((EntityLiving)dragon, x, y, z, yaw, partialTicks);
        }
    }

    protected void renderLayers(EntityTameableDragon dragon, float moveTime, float moveSpeed, float partialTicks, float ticksExisted, float lookYaw, float lookPitch, float scale) {
        List<LayerRenderer<EntityTameableDragon>> layers = this.getBreedRenderer(dragon).getLayers();
        layers.forEach(layer -> {
            boolean brighnessSet = this.func_177092_a((EntityLivingBase)dragon, partialTicks, layer.func_177142_b());
            layer.func_177141_a((EntityLivingBase)dragon, moveTime, moveSpeed, partialTicks, ticksExisted, lookYaw, lookPitch, scale);
            if (brighnessSet) {
                this.func_177091_f();
            }
        });
    }

    protected void renderModel(EntityTameableDragon dragon, float moveTime, float moveSpeed, float ticksExisted, float lookYaw, float lookPitch, float scale) {
        float death = (float)dragon.getDeathTime() / (float)dragon.getMaxDeathTime();
        if (death > 0.0f) {
            GL11.glPushAttrib((int)16640);
            GlStateManager.func_179143_c((int)515);
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)death);
            this.func_110776_a(this.getBreedRenderer(dragon).getDissolveTexture());
            this.field_77045_g.func_78088_a((Entity)dragon, moveTime, moveSpeed, ticksExisted, lookYaw, lookPitch, scale);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179143_c((int)514);
        }
        super.func_77036_a((EntityLivingBase)dragon, moveTime, moveSpeed, ticksExisted, lookYaw, lookPitch, scale);
        if (death > 0.0f) {
            GlStateManager.func_179099_b();
        }
    }

    protected void renderEgg(EntityTameableDragon dragon, double x, double y, double z, float pitch, float partialTicks) {
        DragonLifeStageHelper lifeStage = dragon.getLifeStageHelper();
        float tickX = lifeStage.getEggWiggleX();
        float tickZ = lifeStage.getEggWiggleZ();
        float rotX = 0.0f;
        float rotZ = 0.0f;
        if (tickX > 0.0f) {
            rotX = (float)Math.sin(tickX - partialTicks) * 8.0f;
        }
        if (tickZ > 0.0f) {
            rotZ = (float)Math.sin(tickZ - partialTicks) * 8.0f;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)rotX, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rotZ, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        this.func_110776_a(TextureMap.field_110575_b);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vb = tessellator.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        BlockDragonBreedEgg block = BlockDragonBreedEgg.INSTANCE;
        IBlockState iblockstate = block.func_176223_P().func_177226_a(BlockDragonBreedEgg.BREED, (Comparable)((Object)dragon.getBreedType()));
        BlockPos blockpos = dragon.func_180425_c();
        double tx = (double)(-blockpos.func_177958_n()) - 0.5;
        double ty = -blockpos.func_177956_o();
        double tz = (double)(-blockpos.func_177952_p()) - 0.5;
        vb.func_178969_c(tx, ty, tz);
        BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
        IBakedModel bakedModel = brd.func_184389_a(iblockstate);
        brd.func_175019_b().func_178267_a((IBlockAccess)dragon.field_70170_p, bakedModel, iblockstate, blockpos, vb, false);
        vb.func_178969_c(0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
    }

    protected void rotateCorpse(EntityTameableDragon dragon, float par2, float par3, float par4) {
        GlStateManager.func_179114_b((float)(180.0f - par3), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    protected void preRenderCallback(EntityTameableDragon dragon, float partialTicks) {
        float scale = dragon.getScale() * 0.8f;
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
    }

    protected ResourceLocation getEntityTexture(EntityTameableDragon dragon) {
        return this.getBreedRenderer(dragon).getBodyTexture();
    }
}

